'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH after n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
after \- 延迟一段时间之后执行一个命令
.SH 总览 SYNOPSIS
\fBafter \fIms\fR
.sp
\fBafter \fIms \fR?\fIscript script script ...\fR?
.sp
\fBafter cancel \fIid\fR
.sp
\fBafter cancel \fIscript script script ...\fR
.sp
\fBafter idle \fR?\fIscript script script ...\fR?
.sp
\fBafter info \fR?\fIid\fR?
.BE

.SH 描述 DESCRIPTION
.PP
 这个命令被用于延迟执行程序或者在将来某时在后台执行一个命令。它有几种形式，依靠给命令的第一个参数(来区分):
.TP
\fBafter \fIms\fR
\fIMs\fR 必须是整数，给出以毫秒为单位的时间。命令在睡眠(sleep) \fIms\fR 毫秒之后返回。当命令在睡眠的时候，应用不响应事件。
.TP
\fBafter \fIms \fR?\fIscript script script ...\fR?
在这种形式中，命令立即返回，它安排一个 Tcl 命令在 \fIms\fR 毫秒之后作为事件处理器(handler)来运行。在给定时间，命令将被精确的执行一次。延迟的命令是通过连接(concatenate)所有的  \fIscript\fR 参数形成的，这与 \fBconcat\fR 命令的方式(fashion)一样。命令将在全局层次上执行(在任何 Tcl 过程的上下文之外)。在执行延迟命令时如果有错误发生，则使用 \fBbgerror\fR 机制来报告错误。\fBafter\fR 命令返回一个标识符，\fBafter cancel\fR 命令用它来取消延迟的命令。
.TP
\fBafter cancel \fIid\fR
取消前面安排的延迟命令的执行。\fIId\fR 指示要取消那条命令；它必须是前面 \fBafter\fR 命令返回的。如果用 \fIid\fR 给出的命令已经执行了则 \fBafter cancel\fR 命令不起作用。
.TP
\fBafter cancel \fIscript script ...\fR
这个命令也取消一个延迟命令的执行。用空格分隔符来连接 \fIscript\fR 参数(如同在 \fBconcat\fR 命令中那样)。如果有一条等待的命令与这个字符串匹配，则取消它并永不执行；如果当前没有这样的等待命令则 \fBafter cancel\fR 命令不起作用。
.TP
\fBafter idle \fIscript \fR?\fIscript script ...\fR?
用空格分隔符连接 \fIscript\fR 参数(如同在 \fBconcat\fR 命令中那样)，并被作为一个空闲回调(idle callback)来安排结果脚本在以后执行。下次进入事件循环并且没有事件要处理(的时候)，这个脚本被精确的执行一次。命令返回一个标识符，\fBafter cancel\fR 命令用它来取消延迟的命令。在执行延迟命令时如果有错误发生，则使用 \fBbgerror\fR 机制来报告错误。
.TP
\fBafter info \fR?\fIid\fR?
这个命令返回关于存在的事件处理器的信息。如果没提供 \fIid\fR 参数，命令为所有通过 \fBafter\fR 命令给这个解释器建立的事件处理器返回一个标识符的列表。如果提供了 \fIid\fR，它指定一个现存的处理器；\fIid\fR 必须是以前调用 \fBafter\fR 返回的值并且仍未被触发或取消。这种情况下命令返回一个有两个元素的列表。列表的第一个元素是与 \fIid\fR 关联的脚本，第二个元素要么是 \fBidle\fR 要么是 \fBtimer\fR，指示它是那种类型的事件处理器。
.LP
命令的 \fBafter \fIms\fR 和 \fBafter idle\fR 形式假定应用是事件驱动的: 除非应用进入事件循环否则延迟命令将不被执行。在通常不事件驱动的应用中，如 \fBtclsh\fR，用 \fBvwait\fR 和 \fBupdate\fR 命令进入事件循环。


.SH "参见 SEE ALSO"
bgerror

.SH 关键字 KEYWORDS
cancel, delay, idle callback, sleep, time

.SH [中文版维护人]
.B 寒蝉退士
.SH [中文版最新更新]
.B 2001/06/21
.SH 《中国 Linux 论坛 man 手册页翻译计划》:
.B http://cmpp.linuxforum.net
