/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "file_utils.h"
#include "map_seeking.h"
#include "menus.h"
#include "sounds.h"
#include "config_file.h"

extern player_t *player;
extern game_data_t *world;
extern map_names_t *map_names;
extern char *filename;
extern options_t *options;

extern GLuint t_cursor, t_cursor_mask;
options_menu_t *options_menu;
extern menu_common_t *menu_shared;

const char *options_menu_tex_names[N_OPTIONS_MENU_TEX] =
  {
    SHXMAN_DATA "menus/options/options_0.png",
    SHXMAN_DATA "menus/options/options_1.png",
    SHXMAN_DATA "menus/options/options_2.png",
    SHXMAN_DATA "menus/options/options_3.png"
  };

enum
  {
    E_OPT_DYN_BACK0,
    E_OPT_DYN_BACK1,
    E_OPT_DYN_APPLY0,
    E_OPT_DYN_APPLY1,

    E_OPT_DYN_FS,
    E_OPT_DYN_SMOOTH,
    E_OPT_DYN_PROX,

    E_OPT_DYN_MANGO,
    E_OPT_DYN_MANGO_MASK
  };

const char *options_menu_dyn_tex_names[N_OPTIONS_MENU_DYN_TEX] =
  {
    SHXMAN_DATA "menus/options/back_0.png",
    SHXMAN_DATA "menus/options/back_1.png",
    SHXMAN_DATA "menus/options/apply_0.png",
    SHXMAN_DATA "menus/options/apply_1.png",

    SHXMAN_DATA "menus/options/fullscreen_enabled.png",
    SHXMAN_DATA "menus/options/smooth_enabled.png",
    SHXMAN_DATA "menus/options/proximity_enabled.png",

    SHXMAN_DATA "menus/options/mango.png",
    SHXMAN_DATA "menus/options/mango_mask.png",
  };

#define OPT_APPLY_X1 660
#define OPT_APPLY_X2 768
#define OPT_APPLY_Y1 532
#define OPT_APPLY_Y2 576

#define OPT_BACK_X1 544
#define OPT_BACK_X2 652
#define OPT_BACK_Y1 532
#define OPT_BACK_Y2 576

#define OPT_APPLY_PICT_X 640
#define OPT_APPLY_PICT_Y 512

#define OPT_BACK_PICT_X 544
#define OPT_BACK_PICT_Y 512

#define OPT_FS_PICT_X 192
#define OPT_FS_PICT_Y 248

#define OPT_FS_X1 192
#define OPT_FS_X2 224
#define OPT_FS_Y1 248
#define OPT_FS_Y2 280

#define OPT_PROX_PICT_X 192
#define OPT_PROX_PICT_Y 400

#define OPT_PROX_X1 192
#define OPT_PROX_X2 224
#define OPT_PROX_Y1 400
#define OPT_PROX_Y2 432

#define OPT_SMOOTH_PICT_X 192
#define OPT_SMOOTH_PICT_Y 312

#define OPT_SMOOTH_X1 192
#define OPT_SMOOTH_X2 224
#define OPT_SMOOTH_Y1 312
#define OPT_SMOOTH_Y2 344

#define OPT_SOUND_TEXT_X 729
#define OPT_SOUND_TEXT_Y 219
#define OPT_MUSIC_TEXT_Y 179
#define OPT_SENS_TEXT_Y 380
#define OPT_SMOOTH_TEXT_Y 340

#define OPT_RADIUS_TEXT_X 745
#define OPT_RADIUS_TEXT_Y 468

#define OPT_MANGO_X1 429
#define OPT_MANGO_X2 705
#define OPT_MANGO_SOUND_Y 192
#define OPT_MANGO_MUSIC_Y 152
#define OPT_MANGO_MOUSE_SMOOTH_Y 312
#define OPT_MANGO_MOUSE_SENS_Y 352
#define OPT_MANGO_RADIUS_Y 440


void load_menu_options()
{
  int i=0;
  options_menu = new options_menu_t;
  SDL_Surface *images_options[N_OPTIONS_MENU_TEX];
  SDL_Surface *images_options_dyn[N_OPTIONS_MENU_DYN_TEX];

  glGenTextures(N_OPTIONS_MENU_TEX, options_menu->tex_menu);
  for (i=0; i<N_OPTIONS_MENU_TEX; i++)
    {
      images_options[i] = ImageLoad(options_menu_tex_names[i]);
      
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_options[i]->w, images_options[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_options[i]->pixels);

      SDL_FreeSurface(images_options[i]);
    }

  glGenTextures(N_OPTIONS_MENU_DYN_TEX, options_menu->tex_dyn_menu);
  for (i=0; i<N_OPTIONS_MENU_DYN_TEX; i++)
    {
      images_options_dyn[i] = ImageLoad(options_menu_dyn_tex_names[i]);
      
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_options_dyn[i]->w, images_options_dyn[i]->h,0, GL_RGB, GL_UNSIGNED_BYTE, images_options_dyn[i]->pixels);

      SDL_FreeSurface(images_options_dyn[i]);
    }

  options_menu->mat_amb_diff[0] = 0.937;
  options_menu->mat_amb_diff[1]= 0.937;
  options_menu->mat_amb_diff[2] = 0.937;
  options_menu->mat_amb_diff[3] = 1.0;
}

void cleanup_menu_options()
{
  glDeleteTextures(N_OPTIONS_MENU_TEX,options_menu->tex_menu);
  glDeleteTextures(N_OPTIONS_MENU_DYN_TEX,options_menu->tex_dyn_menu);
  delete options_menu;
}

void draw_options_menu_static()
{
  GLfloat x = 0, y=600; int i=0;
  glPushMatrix();

  for (i=0; i < N_OPTIONS_MENU_TEX; i++)
    {
      if (i == 2) x+=400;
      if (i==0 || i== 2) y=600; else y=300;

      glBindTexture(GL_TEXTURE_2D,options_menu->tex_menu[i]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-300);
      glTexCoord2f(1, 0);
      glVertex2f(x+400,y-300);
      glTexCoord2f(1, 1);
      glVertex2f(x+400, y);

      glEnd();
    }
}

void draw_options_menu()
{
  set_GL_projection (MANGO_2D);
  set_GL_options (MANGO_2D);
  glClear(GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();

  glPushMatrix();
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, options_menu->mat_amb_diff);

  glEnable(GL_TEXTURE_2D);

  /* first we draw static elements of the menu */
  draw_options_menu_static();

  draw_options_menu_mouseover();
  options_menu_draw_dynamic_options();

  /* then we draw the cursor */
  draw_cursor();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();
  SDL_GL_SwapBuffers();
}

void draw_options_menu_mouseover()
{
  if (options_menu->need_draw_apply) draw_options_apply_active();
  if (options_menu->need_draw_back) draw_options_back_active();
}

void draw_options_apply_active()
{
  GLfloat x=0, y=0;
  x=OPT_APPLY_PICT_X;
  y=600-OPT_APPLY_PICT_Y;

  glPushMatrix();
  glDisable(GL_BLEND);
  
  for (int i=E_OPT_DYN_APPLY0; i <E_OPT_DYN_APPLY1+1; i++)
    {
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,options_menu->tex_dyn_menu[i]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-64);
      glTexCoord2f(1, 0);
      glVertex2f(x+64,y-64);
      glTexCoord2f(1, 1);
      glVertex2f(x+64, y);
      
      glEnd();

      x+=64;
    }
  glEnable(GL_BLEND);
  glPopMatrix();

}

void draw_options_back_active()
{
GLfloat x=0, y=0;
  x=OPT_BACK_PICT_X;
  y=600-OPT_BACK_PICT_Y;

  glPushMatrix();
  glDisable(GL_BLEND);
  for (int i=E_OPT_DYN_BACK0; i <E_OPT_DYN_BACK1+1; i++)
    {
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,options_menu->tex_dyn_menu[i]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-64);
      glTexCoord2f(1, 0);
      glVertex2f(x+64,y-64);
      glTexCoord2f(1, 1);
      glVertex2f(x+64, y);
      
      glEnd();

      x+=64;
    }
  glEnable(GL_BLEND);
  glPopMatrix();
}


void analyze_options_menu_hoover()
{
  if ((menu_shared->mouse_x >= OPT_APPLY_X1) && (menu_shared->mouse_x < OPT_APPLY_X2)
      && (menu_shared->mouse_y >= OPT_APPLY_Y1) && (menu_shared->mouse_y < OPT_APPLY_Y2))
    {
      options_menu->need_draw_apply=1;
    }

if ((menu_shared->mouse_x >= OPT_BACK_X1) && (menu_shared->mouse_x < OPT_BACK_X2)
      && (menu_shared->mouse_y >= OPT_BACK_Y1) && (menu_shared->mouse_y < OPT_BACK_Y2))
    {
      options_menu->need_draw_back=1;
    }
}

void options_menu_loop(char is_in_game)
{
  int loop_end = 0;
  options_menu->need_draw_apply=0;
  options_menu->need_draw_back=0;
  options_menu->option_modified=0;
  menu_shared->is_button_down=0;

  options_menu_read_options();

  while (!(loop_end))
  {
    {
      if (is_in_game) {
	world->game_sync->update_temps();
	world->game_timer->update_temps();
      }

      SDL_Event event;
      
      while (SDL_PollEvent(&event))
	{
	  if (event.type == SDL_KEYDOWN)
	    {
	      switch (event.key.keysym.sym)
		{
		case SDLK_ESCAPE:
		  loop_end = 1;
		  break;
		  
		default:
		  break;
		}
	    }
	  
	  if (event.type == SDL_MOUSEBUTTONDOWN)
	    {
	      menu_shared->is_button_down=1;
	    }

	  if (event.type == SDL_MOUSEBUTTONUP)
	    {
	      menu_shared->is_button_down=0;
	    }
	}
    }
    SDL_GetMouseState(&menu_shared->mouse_x,&menu_shared->mouse_y);
    if (menu_shared->is_button_down)
      analyze_options_menu_buttondown(&loop_end);   

    analyze_options_menu_hoover();
    draw_options_menu();
    options_reset_draw_needs();
  }
  options_menu_read_options();
  if (options_menu->option_modified)
    write_config_file();
}

void analyze_options_menu_buttondown(int *loop_flag)
{
  /* Apply button */
  if ((menu_shared->mouse_x >= OPT_APPLY_X1) && (menu_shared->mouse_x < OPT_APPLY_X2) && (menu_shared->mouse_y >= OPT_APPLY_Y1) && (menu_shared->mouse_y < OPT_APPLY_Y2))
    {
      play_menu_sound(MENU_SOUND_LAUNCH);
      options_menu_apply();
      menu_shared->is_button_down=0;
    }

  /* Back button */
  if ((menu_shared->mouse_x >= OPT_BACK_X1) && (menu_shared->mouse_x < OPT_BACK_X2) && (menu_shared->mouse_y >= OPT_BACK_Y1) && (menu_shared->mouse_y < OPT_BACK_Y2))
    {
      *loop_flag = 1;
      play_menu_sound(MENU_SOUND_BACK);
      menu_shared->is_button_down=0;
    }

  /* Fullscreen tick */
  if ((menu_shared->mouse_x >= OPT_FS_X1) && (menu_shared->mouse_x < OPT_FS_X2) && (menu_shared->mouse_y >= OPT_FS_Y1) && (menu_shared->mouse_y < OPT_FS_Y2))
    {
      if (options_menu->options_buffer.fullscreen) options_menu->options_buffer.fullscreen =0;
      else options_menu->options_buffer.fullscreen=1;

      menu_shared->is_button_down=0;
    }


  /* Smooth mouse tick */
  if ((menu_shared->mouse_x >= OPT_SMOOTH_X1) && (menu_shared->mouse_x < OPT_SMOOTH_X2) && (menu_shared->mouse_y >= OPT_SMOOTH_Y1) && (menu_shared->mouse_y < OPT_SMOOTH_Y2))
    {
      if (options_menu->options_buffer.mouse_smooth) options_menu->options_buffer.mouse_smooth =0;
      else {
	if (options->mouse_smooth) 
	  options_menu->options_buffer.mouse_smooth=options->mouse_smooth;
	else options_menu->options_buffer.mouse_smooth=25;
      }

      menu_shared->is_button_down=0;
    }

  /* Proximity warning tick */
  if ((menu_shared->mouse_x >= OPT_PROX_X1) && (menu_shared->mouse_x < OPT_PROX_X2) && (menu_shared->mouse_y >= OPT_PROX_Y1) && (menu_shared->mouse_y < OPT_PROX_Y2))
    {
      if (options_menu->options_buffer.proximity_setting) options_menu->options_buffer.proximity_setting =0;
      else {
	if (options->proximity_setting) 
	  options_menu->options_buffer.proximity_setting=options->proximity_setting;
	else options_menu->options_buffer.proximity_setting=5;
      }
      menu_shared->is_button_down=0;
    }

  /* music cursor */
  if ((menu_shared->mouse_x >= OPT_MANGO_X1) && (menu_shared->mouse_x < OPT_MANGO_X2+20) && (menu_shared->mouse_y >= OPT_MANGO_MUSIC_Y-5) && (menu_shared->mouse_y < OPT_MANGO_MUSIC_Y+30))
    {
      options_menu->options_buffer.music_volume = (int)ceil( (float)(menu_shared->mouse_x-OPT_MANGO_X1) / (float)(OPT_MANGO_X2-OPT_MANGO_X1) * 100.0f);

      if (options_menu->options_buffer.music_volume > 100) options_menu->options_buffer.music_volume = 100;
if (options_menu->options_buffer.music_volume < 0) options_menu->options_buffer.music_volume = 0;
    }

  /* sound cursor */
  if ((menu_shared->mouse_x >= OPT_MANGO_X1) && (menu_shared->mouse_x < OPT_MANGO_X2+20) && (menu_shared->mouse_y >= OPT_MANGO_SOUND_Y-5) && (menu_shared->mouse_y < OPT_MANGO_SOUND_Y+30))
    {
      options_menu->options_buffer.sound_volume = (int)ceil( (float)(menu_shared->mouse_x-OPT_MANGO_X1) / (float)(OPT_MANGO_X2-OPT_MANGO_X1) * 100.0f);

      if (options_menu->options_buffer.sound_volume > 100) options_menu->options_buffer.sound_volume = 100;
if (options_menu->options_buffer.sound_volume < 0) options_menu->options_buffer.sound_volume = 0;
    }

  /* smooth mouse cursor */
  if ((menu_shared->mouse_x >= OPT_MANGO_X1) && (menu_shared->mouse_x < OPT_MANGO_X2+20) && (menu_shared->mouse_y >= OPT_MANGO_MOUSE_SMOOTH_Y-5) && (menu_shared->mouse_y < OPT_MANGO_MOUSE_SMOOTH_Y+30))
    {
      options_menu->options_buffer.mouse_smooth = (int)ceil( (float)(menu_shared->mouse_x-OPT_MANGO_X1) / (float)(OPT_MANGO_X2-OPT_MANGO_X1) * 50.0f);

      if (options_menu->options_buffer.mouse_smooth > 50) options_menu->options_buffer.mouse_smooth = 50;
      if (options_menu->options_buffer.mouse_smooth < 1) options_menu->options_buffer.mouse_smooth = 1;
    }

  /* mouse sensitivity cursor */
 if ((menu_shared->mouse_x >= OPT_MANGO_X1) && (menu_shared->mouse_x < OPT_MANGO_X2+20) && (menu_shared->mouse_y >= OPT_MANGO_MOUSE_SENS_Y-5) && (menu_shared->mouse_y < OPT_MANGO_MOUSE_SENS_Y+30))
    {
      options_menu->options_buffer.mouse_sens_pre = (int)ceil( (float)(menu_shared->mouse_x-OPT_MANGO_X1) / (float)(OPT_MANGO_X2-OPT_MANGO_X1) * 20.0f);

      if (options_menu->options_buffer.mouse_sens_pre > 20) options_menu->options_buffer.mouse_sens_pre = 20;
      if (options_menu->options_buffer.mouse_sens_pre < 1) options_menu->options_buffer.mouse_sens_pre = 1;
    }

  /* proximity warning radius cursor */
  if ((menu_shared->mouse_x >= OPT_MANGO_X1) && (menu_shared->mouse_x < OPT_MANGO_X2+20) && (menu_shared->mouse_y >= OPT_MANGO_RADIUS_Y-5) && (menu_shared->mouse_y < OPT_MANGO_RADIUS_Y+30))
    {
      options_menu->options_buffer.proximity_setting = (int)ceil( (float)(menu_shared->mouse_x-OPT_MANGO_X1) / (float)(OPT_MANGO_X2-OPT_MANGO_X1) * 15.0f);

      if (options_menu->options_buffer.proximity_setting > 15) options_menu->options_buffer.proximity_setting = 15;
      if (options_menu->options_buffer.proximity_setting < 1) options_menu->options_buffer.proximity_setting = 1;
    }
}

void options_menu_draw_dynamic_options()
{
  options_menu_draw_audio();
  options_menu_draw_video();
  options_menu_draw_mouse();
  options_menu_draw_gameplay();
}

void options_menu_draw_audio()
{
  GLfloat x=0, y=0;
  x = (GLfloat)OPT_MANGO_X1 + ((GLfloat)options_menu->options_buffer.sound_volume / 100.0f) * (GLfloat)(OPT_MANGO_X2-OPT_MANGO_X1)-13;
  y = 600-OPT_MANGO_SOUND_Y;

  /* sound mango */
  //glPushMatrix();
  glEnable(GL_BLEND);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO_MASK]);

  glBegin(GL_QUADS);
  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO]);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glDisable(GL_BLEND);

  //glPopMatrix();

  /* sound volume */
  menu_shared->tgaFont.SetSize(13);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(OPT_SOUND_TEXT_X,600-OPT_SOUND_TEXT_Y,"%d%%",options_menu->options_buffer.sound_volume);

  x = (GLfloat)OPT_MANGO_X1 + ((GLfloat)options_menu->options_buffer.music_volume / 100.0f) * (GLfloat)(OPT_MANGO_X2-OPT_MANGO_X1) - 13;
  y = 600-OPT_MANGO_MUSIC_Y;

  /* music mango */
  //glPushMatrix();
  glEnable(GL_BLEND);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO_MASK]);

  glBegin(GL_QUADS);
  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO]);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glDisable(GL_BLEND);

  //glPopMatrix();

  /* music volume */
  menu_shared->tgaFont.SetSize(13);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(OPT_SOUND_TEXT_X,600-OPT_MUSIC_TEXT_Y,"%d%%",options_menu->options_buffer.music_volume);

}

void options_menu_draw_video()
{
  /* fullscreen tick */
  GLfloat x=0,y=0;
  x=OPT_FS_PICT_X;
  y=600-OPT_FS_PICT_Y;

  if (options_menu->options_buffer.fullscreen)
    {
      glPushMatrix();
  
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,options_menu->tex_dyn_menu[E_OPT_DYN_FS]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      
      glEnd();

      glPopMatrix();
    }
}

void options_menu_draw_mouse()
{
  /* smooth mouse tick */
  GLfloat x=0,y=0;
  x=OPT_SMOOTH_PICT_X;
  y=600-OPT_SMOOTH_PICT_Y;

  if (options_menu->options_buffer.mouse_smooth)
    {
      glPushMatrix();
  
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,options_menu->tex_dyn_menu[E_OPT_DYN_SMOOTH]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      
      glEnd();

      glPopMatrix();
  
      x = (GLfloat)OPT_MANGO_X1 + ((GLfloat)options_menu->options_buffer.mouse_smooth / 50.0f) * (GLfloat)(OPT_MANGO_X2-OPT_MANGO_X1) - 13;
      y = 600-OPT_MANGO_MOUSE_SMOOTH_Y;
      /* mouse smooth mango */
      //glPushMatrix();
      glEnable(GL_BLEND);
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO_MASK]);

      glBegin(GL_QUADS);
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      glEnd();

      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      glEnd();

      glDisable(GL_BLEND);

      //glPopMatrix();

      /* mouse smooth value */
      menu_shared->tgaFont.SetSize(13);
      menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
      menu_shared->tgaFont.Draw(OPT_SOUND_TEXT_X+7,600-OPT_SMOOTH_TEXT_Y,"%d",options_menu->options_buffer.mouse_smooth);
    }

  /* mouse sensitivity mango */

  x = (GLfloat)OPT_MANGO_X1 + ((GLfloat)options_menu->options_buffer.mouse_sens_pre / 20.0f) * (GLfloat)(OPT_MANGO_X2-OPT_MANGO_X1) - 13;
  y = 600-OPT_MANGO_MOUSE_SENS_Y;

  //glPushMatrix();
  glEnable(GL_BLEND);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO_MASK]);

  glBegin(GL_QUADS);
  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glBlendFunc(GL_ONE, GL_ONE);
  glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO]);
  glBegin(GL_QUADS);

  glTexCoord2f(0, 1);
  glVertex2f(x, y);
  glTexCoord2f(0, 0);
  glVertex2f(x, y-32);
  glTexCoord2f(1, 0);
  glVertex2f(x+32,y-32);
  glTexCoord2f(1, 1);
  glVertex2f(x+32, y);
  glEnd();

  glDisable(GL_BLEND);

  //glPopMatrix();

  /* mouse sensitivity value */
  menu_shared->tgaFont.SetSize(13);
  menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
  menu_shared->tgaFont.Draw(OPT_SOUND_TEXT_X+7,600-OPT_SENS_TEXT_Y,"%d",options_menu->options_buffer.mouse_sens_pre);
}

void options_menu_draw_gameplay()
{
  GLfloat x=0,y=0;
  x=OPT_PROX_PICT_X;
  y=600-OPT_PROX_PICT_Y;

  if (options_menu->options_buffer.proximity_setting)
    {
      /* tick for warning*/
      glPushMatrix();
  
      glEnable(GL_TEXTURE_2D);
      glBindTexture(GL_TEXTURE_2D,options_menu->tex_dyn_menu[E_OPT_DYN_PROX]);
      glBegin(GL_QUADS);
      
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      
      glEnd();

      glPopMatrix();


      x = (GLfloat)OPT_MANGO_X1 + ((GLfloat)options_menu->options_buffer.proximity_setting / 15.0f) * (GLfloat)(OPT_MANGO_X2-OPT_MANGO_X1) - 13;
      y = 600-OPT_MANGO_RADIUS_Y;
      /* warning radius mango */
      //glPushMatrix();
      glEnable(GL_BLEND);
      glBlendFunc(GL_DST_COLOR, GL_ZERO);
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO_MASK]);
      
      glBegin(GL_QUADS);
      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      glEnd();

      glBlendFunc(GL_ONE, GL_ONE);
      glBindTexture(GL_TEXTURE_2D, options_menu->tex_dyn_menu[E_OPT_DYN_MANGO]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-32);
      glTexCoord2f(1, 0);
      glVertex2f(x+32,y-32);
      glTexCoord2f(1, 1);
      glVertex2f(x+32, y);
      glEnd();

      glDisable(GL_BLEND);

      //glPopMatrix();

      /* radius value for warning */
      menu_shared->tgaFont.SetSize(13);
      menu_shared->tgaFont.Color3f(0.0, 0.0, 0.0);
      menu_shared->tgaFont.Draw(OPT_RADIUS_TEXT_X+7,600-OPT_RADIUS_TEXT_Y,"%d",options_menu->options_buffer.proximity_setting);
      
    }
  
}

void options_reset_draw_needs()
{
  options_menu->need_draw_apply=0;
  options_menu->need_draw_back=0;
}

void options_menu_apply()
{
  if (options->sound_volume != options_menu->options_buffer.sound_volume) {
    options->sound_volume = options_menu->options_buffer.sound_volume;

#ifdef HAVE_SDL_MIXER
    if (options->use_sound) 
      Mix_Volume(-1, options->sound_volume * 128 / 100);
#endif

  options_menu->option_modified=1;

  }

  if (options->music_volume != options_menu->options_buffer.music_volume) {
    options->music_volume = options_menu->options_buffer.music_volume;
      
#ifdef HAVE_SDL_MIXER
    if (options->use_sound) 
      Mix_VolumeMusic(options->music_volume * 128 / 100);
#endif

    options_menu->option_modified=1;
  }

  if (options->fullscreen != options_menu->options_buffer.fullscreen) {
    options->fullscreen = options_menu->options_buffer.fullscreen;

#ifndef WIN32    
    if (options->fullscreen) 
      SDL_WM_ToggleFullScreen(world->screen);
    else SDL_WM_ToggleFullScreen(world->screen);
#else
    printf("Windowed mode disabled on windows\n");
    /*if (options->fullscreen) {
      world->screen=SDL_SetVideoMode(800, 600, 16, world->videoFlags_fs);
    }
    else world->screen=SDL_SetVideoMode(800, 600, 16, world->videoFlags);*/

#endif    
    options_menu->option_modified=1;
  }
  
  if (options->proximity_setting != options_menu->options_buffer.proximity_setting) {
    options->proximity_setting=options_menu->options_buffer.proximity_setting; 
    options_menu->option_modified=1;
  }

  if (options->mouse_smooth != options_menu->options_buffer.mouse_smooth) {
    options->mouse_smooth = options_menu->options_buffer.mouse_smooth;
    options_menu->option_modified=1;
  }

  if (options->mouse_sens_pre != options_menu->options_buffer.mouse_sens_pre) {
    options->mouse_sens_pre =  options_menu->options_buffer.mouse_sens_pre;
    options_menu->option_modified=1;      
  }

  if (options->mouse_sens_post!=options_menu->options_buffer.mouse_sens_post) {
    options->mouse_sens_post = options_menu->options_buffer.mouse_sens_post;
    options_menu->option_modified=1; 
  }

  if (options->is_mouse_y != options_menu->options_buffer.is_mouse_y) {
    options->is_mouse_y= options_menu->options_buffer.is_mouse_y;
    options_menu->option_modified=1;
  }

  if (options->music_volume != options_menu->options_buffer.music_volume) {
    options->music_volume = options_menu->options_buffer.music_volume;
    options_menu->option_modified=1;
  }
  
}

void options_menu_read_options()
{
  options_menu->options_buffer.proximity_setting = options->proximity_setting;

  options_menu->options_buffer.mouse_smooth = options->mouse_smooth;
  options_menu->options_buffer.mouse_sens_pre = options->mouse_sens_pre;
  options_menu->options_buffer.mouse_sens_post = options->mouse_sens_post;
  options_menu->options_buffer.is_mouse_y = options->is_mouse_y;

  options_menu->options_buffer.sound_volume=options->sound_volume;
  options_menu->options_buffer.music_volume = options->music_volume;

  options_menu->options_buffer.fullscreen = options->fullscreen;
}
