/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MAP_H_
#define _MAP_H_

#include <zlib.h>
#ifdef WIN32
#  ifndef ZLIB_DLL
#   define ZLIB_DLL
#  endif
#  ifndef _WINDOWS
#   define _WINDOWS
#  endif
#endif

void load_map(char *filename);
int verify_map(gzFile the_file);
void load_description(gzFile the_file);
void load_geometry(gzFile the_file);
void read_all_portals(gzFile the_file);
void read_portals_numbers(gzFile the_file, int indice);
void read_triangles(gzFile the_file, int indice);
void read_bonus(gzFile the_file, int indice);

void reset_all_states();

void unload_map();
void unload_geometry();
void unload_description();

unsigned char test_left(int pos);
unsigned char test_right(int pos);
unsigned char test_up(int pos);
unsigned char test_down(int pos);
unsigned char test_up_right(int pos);
unsigned char test_up_left(int pos);
unsigned char test_down_right(int pos);
unsigned char test_down_left(int pos);

int get_left(int pos);
int get_right(int pos);
int get_up(int pos);
int get_down(int pos);

int test_bonus(int pos);
int test_special(int pos);
int get_bonus_param(int square);
int is_teleport(int square);

int square_to_map_x(int square);
int square_to_map_z(int square);
int map_to_square(int x, int z);

#endif
