/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesi T5
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfBenesiT5bIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfBenesiT5bIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	REAL tempXZ = mad(z.x, SQRT_2_3, -z.z * SQRT_1_3);
	z = (REAL4){
		(tempXZ - z.y) * SQRT_1_2, (tempXZ + z.y) * SQRT_1_2, z.x * SQRT_1_3 + z.z * SQRT_2_3, z.w};

	// if (z.x > -1e-21f && z.x < 1e-21f)
	// z.x = (z.x > 0) ? 1e-21f : -1e-21f;
	// if (z.y > -1e-21f && z.y < 1e-21f)
	// z.y = (z.y > 0) ? 1e-21f : -1e-21f;
	// if (z.z > -1e-21f && z.z < 1e-21f)
	// z.z = (z.z > 0) ? 1e-21f : -1e-21f;
	REAL4 tempV2 = z;
	tempV2.x = fabs(native_powr(native_powr(z.y, fractal->transformCommon.int8X)
																+ native_powr(z.z, fractal->transformCommon.int8X),
		fractal->transformCommon.power025.x));
	tempV2.y = fabs(native_powr(native_powr(z.x, fractal->transformCommon.int8Y)
																+ native_powr(z.z, fractal->transformCommon.int8Y),
		fractal->transformCommon.power025.y));
	tempV2.z = fabs(native_powr(native_powr(z.x, fractal->transformCommon.int8Z)
																+ native_powr(z.y, fractal->transformCommon.int8Z),
		fractal->transformCommon.power025.z));
	z = (fabs(tempV2 - fractal->transformCommon.offsetC111)) * fractal->transformCommon.scale3Dd222;

	if (fractal->transformCommon.rotationEnabled)
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);

	tempXZ = (z.y + z.x) * SQRT_1_2;
	z = (REAL4){z.z * SQRT_1_3 + tempXZ * SQRT_2_3, (z.y - z.x) * SQRT_1_2,
		z.z * SQRT_2_3 - tempXZ * SQRT_1_3, z.w};
	return z;
}