// PopAccount.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2004  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef POPACCOUNT_HH
#define POPACCOUNT_HH

#ifndef SINGLE_LINE
#define SINGLE_LINE true
#define MULTI_LINE  false
#endif

#include <vector>
#include <string>
extern "C" {
#include <stdio.h>
}
#ifndef HAVE_SNPRINTF
#include <stdarg.h>
#endif
#include "Account.hh"
#include "Header.hh"
#include "Preferences.hh"
#include "SocketConnection.hh"

using namespace std;

namespace acc {


  // The Windows users don't know snprintf, so here's a work-around for that function
#ifndef HAVE_SNPRINTF
  int snprintf(char *str, size_t size, const char *format, ...) {
    int i;
    va_list args;
    va_start(args, format);
    i = vsnprintf(str, size, format, args);
    va_end(args);
    return i;
  }
#else
  extern int snprintf(char *str, size_t size, const char *format, ...);
#endif
  

  class PopAccount: public Account {
  private:
    // Variables from account
    pref::Preferences* prefs;

    // Methods
    int loginHost(void);
    bool logoutHost(void);
    int removeMessage(int);
    bool successful(const string&);
    void getHash(char*, char*, char*);
    string getWord(const string&, int);

  public:
    PopAccount(const string&, const string&, const string&, int, int, pref::Preferences*, fb::Feedback*);
    ~PopAccount();
    int check();
  };


  // Exceptions
  class UnknownError {};


}

#endif
