// SocketConnection.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef SOCKETCONNECTION_HH
#define SOCKETCONNECTION_HH

#include <string>
#include "Connection.hh"

#ifndef MAX_BYTES
#define MAX_BYTES 512
#endif

using namespace std;

namespace conn {

  class SocketConnection: public Connection {
  private:
    int mySocket;           // Socket descriptor
    int port;               // Connection port
    int timeOut;            // Response time out

  public:
    SocketConnection();
    ~SocketConnection();
    
    // For a function description refer to Connection.hh
    int connectHost(const string&, int, int);
    int disconnectHost(void);
    int sendHost(const string&);
    string receiveHost(const bool);
    static void connectAlarm(int);
  };

}

#endif
