// Account.cc - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include "Connection.hh"
#include "SocketConnection.hh"
#include "Account.hh"
#include "Feedback.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

using namespace std;

namespace acc {


  Account::Account(fb::Feedback* fb) {
    report = fb;
  }


  Account::~Account() {
  }


  // Sends a command to the server.
  int Account::sendHost(const string& command) {
    if (command.find("PASS ") == 0)
      report->message(6, (string)PACKAGE + (string)": Sending PASS *****\n");
    else
      report->message(6, (string)PACKAGE + (string)": Sending " + command);
  
    return host.sendHost(command);
  }

  
  // Receives a result from the server, either a single line response, or a multi-line response is expected
  string Account::receiveHost(const bool singleLine) {
    try {
      string results = host.receiveHost(singleLine);
      return results;
    }
    catch (conn::ConnectionTimeOut) {
      throw;
    }
    catch (conn::IOException) {
      throw;
    }
    catch (...) {
      throw;
    }
  }


  int Account::connectHost(const string& hostname, int port, int timeout) {
    return host.connectHost(hostname, port, timeout);
  }


  int Account::disconnectHost(void) {
    return host.disconnectHost();
  }


  // Returns the current list of message IDs, specific for this particular PopAccount object
  const vector<string>& Account::getMessageIDs(void) {
    return msgIDs;
  }


  // Adds new message IDs to the current list, so the duplicates from other previously checked accounts can be detected
  void Account::addMessageIDs(const vector<string>& newIDs) {
    vector<string>::const_iterator newID = newIDs.begin();

    while (newID != newIDs.end()) {
      msgIDs.push_back(*newID);
      newID++;
    }
  }


}
