/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This module lists all packages, sorted by package size.
*****/
#include <assert.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "magpie.h"

#include "parser.h"

#define OUTPUT_FILE	"sizes.html"


/*+
Comparison function for sorting by package size.
+*/
static int cmp_size (const void *p, const void *q)
{
	struct package_info *pp = *((struct package_info **) p);
	struct package_info *qq = *((struct package_info **) q);

	return -(pp->size - qq->size);
}
	

/*+
+*/
static int sizes_init (void)
{
	int i;
	FILE *fp;
	struct package_info *p;

#	define MAX_VALUES	100
	int histogram[MAX_VALUES];

	memset (histogram, 0, sizeof histogram);

	qsort (cache, cachecnt, sizeof (cache[0]), cmp_size);

	fp = fopen (OUTPUT_FILE, "w");
	mp_doc_open (fp, "All Packages Sorted by Size");

	mp_abstract (fp, "\
This is a list of packages ordered by size.  It could be useful\n\
to someone trying to select packages for a ZIP disk or CD-R(W)\n\
using the classic \"greedy\" algorithm.");

	mp_list_open (fp);
	for (i = 0; i < cachecnt; i++) {
		p = cache[i];
		mp_package (fp, p, 2, T_SIZE);

		if (p->size / 20480 < MAX_VALUES)
			histogram[p->size/20480]++;
	}
	mp_list_close (fp);

	mp_break (fp);
	mp_title (fp, 2, "Histogram");
	fprintf (fp, "\
This is a histogram showing the number of packages with the indicated\n\
package size.  Each tick is 20k.  Packages over %dk are ignored.\n",
		MAX_VALUES * 20);

	mp_histogram (fp, histogram, MAX_VALUES);

	mp_doc_close (fp);
	fclose (fp);

	gzip (OUTPUT_FILE);

	return 0;
}


/*+
List all packages ordered by size.
+*/
static int sizes_index (FILE *fp, int type)
{
	if (type != MAGPIE_ALL_PACKAGES)
		return 0;

	mp_item_open (fp); 
	mp_url (fp, "%s.gz", "Ordered by package size", OUTPUT_FILE);
	mp_item_close (fp); 

	return 0;
}


struct magpie_module mod_sizes = { 
	version           : MAGPIE_VERSION,
	description       : "group packages by package size",
	init              : sizes_init,
	unannotated_index : sizes_index
};
