# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1NodeSystemInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'machine_id': 'str',
            'system_uuid': 'str',
            'boot_id': 'str',
            'kernel_version': 'str',
            'os_image': 'str',
            'container_runtime_version': 'str',
            'kubelet_version': 'str',
            'kube_proxy_version': 'str'
        }

        self.attribute_map = {
            'machine_id': 'machineID',
            'system_uuid': 'systemUUID',
            'boot_id': 'bootID',
            'kernel_version': 'kernelVersion',
            'os_image': 'osImage',
            'container_runtime_version': 'containerRuntimeVersion',
            'kubelet_version': 'kubeletVersion',
            'kube_proxy_version': 'kubeProxyVersion'
        }

        self._machine_id = None
        self._system_uuid = None
        self._boot_id = None
        self._kernel_version = None
        self._os_image = None
        self._container_runtime_version = None
        self._kubelet_version = None
        self._kube_proxy_version = None

    @property
    def machine_id(self):
        """
        Gets the machine_id of this V1NodeSystemInfo.
        machine-id reported by the node

        :return: The machine_id of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._machine_id

    @machine_id.setter
    def machine_id(self, machine_id):
        """
        Sets the machine_id of this V1NodeSystemInfo.
        machine-id reported by the node

        :param machine_id: The machine_id of this V1NodeSystemInfo.
        :type: str
        """
        self._machine_id = machine_id

    @property
    def system_uuid(self):
        """
        Gets the system_uuid of this V1NodeSystemInfo.
        system-uuid reported by the node

        :return: The system_uuid of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._system_uuid

    @system_uuid.setter
    def system_uuid(self, system_uuid):
        """
        Sets the system_uuid of this V1NodeSystemInfo.
        system-uuid reported by the node

        :param system_uuid: The system_uuid of this V1NodeSystemInfo.
        :type: str
        """
        self._system_uuid = system_uuid

    @property
    def boot_id(self):
        """
        Gets the boot_id of this V1NodeSystemInfo.
        boot id is the boot-id reported by the node

        :return: The boot_id of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._boot_id

    @boot_id.setter
    def boot_id(self, boot_id):
        """
        Sets the boot_id of this V1NodeSystemInfo.
        boot id is the boot-id reported by the node

        :param boot_id: The boot_id of this V1NodeSystemInfo.
        :type: str
        """
        self._boot_id = boot_id

    @property
    def kernel_version(self):
        """
        Gets the kernel_version of this V1NodeSystemInfo.
        Kernel version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)

        :return: The kernel_version of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._kernel_version

    @kernel_version.setter
    def kernel_version(self, kernel_version):
        """
        Sets the kernel_version of this V1NodeSystemInfo.
        Kernel version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)

        :param kernel_version: The kernel_version of this V1NodeSystemInfo.
        :type: str
        """
        self._kernel_version = kernel_version

    @property
    def os_image(self):
        """
        Gets the os_image of this V1NodeSystemInfo.
        OS image used reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))

        :return: The os_image of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._os_image

    @os_image.setter
    def os_image(self, os_image):
        """
        Sets the os_image of this V1NodeSystemInfo.
        OS image used reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))

        :param os_image: The os_image of this V1NodeSystemInfo.
        :type: str
        """
        self._os_image = os_image

    @property
    def container_runtime_version(self):
        """
        Gets the container_runtime_version of this V1NodeSystemInfo.
        Container runtime version reported by the node through runtime remote API (e.g. docker://1.5.0)

        :return: The container_runtime_version of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._container_runtime_version

    @container_runtime_version.setter
    def container_runtime_version(self, container_runtime_version):
        """
        Sets the container_runtime_version of this V1NodeSystemInfo.
        Container runtime version reported by the node through runtime remote API (e.g. docker://1.5.0)

        :param container_runtime_version: The container_runtime_version of this V1NodeSystemInfo.
        :type: str
        """
        self._container_runtime_version = container_runtime_version

    @property
    def kubelet_version(self):
        """
        Gets the kubelet_version of this V1NodeSystemInfo.
        Kubelet version reported by the node

        :return: The kubelet_version of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._kubelet_version

    @kubelet_version.setter
    def kubelet_version(self, kubelet_version):
        """
        Sets the kubelet_version of this V1NodeSystemInfo.
        Kubelet version reported by the node

        :param kubelet_version: The kubelet_version of this V1NodeSystemInfo.
        :type: str
        """
        self._kubelet_version = kubelet_version

    @property
    def kube_proxy_version(self):
        """
        Gets the kube_proxy_version of this V1NodeSystemInfo.
        Kube-proxy version reported by the node

        :return: The kube_proxy_version of this V1NodeSystemInfo.
        :rtype: str
        """
        return self._kube_proxy_version

    @kube_proxy_version.setter
    def kube_proxy_version(self, kube_proxy_version):
        """
        Sets the kube_proxy_version of this V1NodeSystemInfo.
        Kube-proxy version reported by the node

        :param kube_proxy_version: The kube_proxy_version of this V1NodeSystemInfo.
        :type: str
        """
        self._kube_proxy_version = kube_proxy_version

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
