/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoAttributes.cc
    \brief Implemtation of HiLo Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:45 2012
*/    

#include "HiLoAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;

template <class P>
HiLoAttributes<P>::HiLoAttributes():
	window_size_(ParameterManager::getInt("contour_hilo_window_size")),
	suppress_radius_(ParameterManager::getDouble("contour_hilo_suppress_radius")),
	hilo_max_value_(ParameterManager::getDouble("contour_hilo_max_value")),
	hilo_min_value_(ParameterManager::getDouble("contour_hilo_min_value")),
	hi_max_value_(ParameterManager::getDouble("contour_hi_max_value")),
	hi_min_value_(ParameterManager::getDouble("contour_hi_min_value")),
	lo_max_value_(ParameterManager::getDouble("contour_lo_max_value")),
	lo_min_value_(ParameterManager::getDouble("contour_lo_min_value"))
{

	MagTranslator<string, HiLoTechnique<P> > type;
	setType(type.magics("contour_hilo_type"));

	MagTranslator<string, HiLoMarkerBase<P> > marker;
	setMarker(marker.magics("contour_hilo_marker"));

	MagTranslator<string, HiLoSaveBase<P> > position_write;
	setPosition_write(position_write.magics("contour_hilo_position_write"));
} 


template <class P>
HiLoAttributes<P>::~HiLoAttributes()
{
}

template <class P>    
void HiLoAttributes<P>::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "contour_hilo";
	prefix[1] = "contour";

	setMember(prefix, "contour_hilo_type", type_, params);
	setAttribute(prefix, "contour_hilo_window_size", window_size_, params);
	setAttribute(prefix, "contour_hilo_suppress_radius", suppress_radius_, params);
	setAttribute(prefix, "contour_hilo_max_value", hilo_max_value_, params);
	setAttribute(prefix, "contour_hilo_min_value", hilo_min_value_, params);
	setAttribute(prefix, "contour_hi_max_value", hi_max_value_, params);
	setAttribute(prefix, "contour_hi_min_value", hi_min_value_, params);
	setAttribute(prefix, "contour_lo_max_value", lo_max_value_, params);
	setAttribute(prefix, "contour_lo_min_value", lo_min_value_, params);
	setMember(prefix, "contour_hilo_marker", marker_, params);
	setMember(prefix, "contour_hilo_position_write", position_write_, params);
}
template <class P>
void HiLoAttributes<P>::copy(const HiLoAttributes& other)
{
	setType(other.type_->clone());
	window_size_ = other.window_size_;
	suppress_radius_ = other.suppress_radius_;
	hilo_max_value_ = other.hilo_max_value_;
	hilo_min_value_ = other.hilo_min_value_;
	hi_max_value_ = other.hi_max_value_;
	hi_min_value_ = other.hi_min_value_;
	lo_max_value_ = other.lo_max_value_;
	lo_min_value_ = other.lo_min_value_;
	setMarker(other.marker_->clone());
	setPosition_write(other.position_write_->clone());
} 

template <class P>
bool HiLoAttributes<P>::accept(const string& node)
{	
	if ( magCompare(node, "hilo")  )
		return true;

	if ( acceptNode(node, type_) )
		return true;

	if ( acceptNode(node, marker_) )
		return true;

	if ( acceptNode(node, position_write_) )
		return true;
	return false;
}
template <class P>
void HiLoAttributes<P>::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "hilo") )
		set(node.attributes());
	else {
		setMember(node.name(), type_, node);
		setMember(node.name(), marker_, node);
		setMember(node.name(), position_write_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), type_, *(*elt)); 
		setMember((*elt)->name(), marker_, *(*elt)); 
		setMember((*elt)->name(), position_write_, *(*elt)); 
	}
}
template <class P>
void HiLoAttributes<P>::print(ostream& out)  const
{
	out << "HiLoAttributes[";
	out << "type = " << *type_;
	out << ", window_size = " << window_size_;
	out << ", suppress_radius = " << suppress_radius_;
	out << ", hilo_max_value = " << hilo_max_value_;
	out << ", hilo_min_value = " << hilo_min_value_;
	out << ", hi_max_value = " << hi_max_value_;
	out << ", hi_min_value = " << hi_min_value_;
	out << ", lo_max_value = " << lo_max_value_;
	out << ", lo_min_value = " << lo_min_value_;
	out << ", marker = " << *marker_;
	out << ", position_write = " << *position_write_;
	out << "]" << "\n";
}

template <class P>
void HiLoAttributes<P>::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"hilo\"";
	 out << ", \"contour_hilo_type\":";
	 type_->toxml(out, 0);
	 out << ", \"contour_hilo_window_size\":";
	 niceprint(out,window_size_);
	 out << ", \"contour_hilo_suppress_radius\":";
	 niceprint(out,suppress_radius_);
	 out << ", \"contour_hilo_max_value\":";
	 niceprint(out,hilo_max_value_);
	 out << ", \"contour_hilo_min_value\":";
	 niceprint(out,hilo_min_value_);
	 out << ", \"contour_hi_max_value\":";
	 niceprint(out,hi_max_value_);
	 out << ", \"contour_hi_min_value\":";
	 niceprint(out,hi_min_value_);
	 out << ", \"contour_lo_max_value\":";
	 niceprint(out,lo_max_value_);
	 out << ", \"contour_lo_min_value\":";
	 niceprint(out,lo_min_value_);
	 out << ", \"contour_hilo_marker\":";
	 marker_->toxml(out, 0);
	 out << ", \"contour_hilo_position_write\":";
	 position_write_->toxml(out, 0);
}
static MagicsParameter<string> contour_hilo_type("contour_hilo_type", "text", " New Magics: Parameter contour_hilo_type sent to new Magics[HiLo].  ");
static MagicsParameter<int> contour_hilo_window_size("contour_hilo_window_size", 3, " New Magics: Parameter contour_hilo_window_size sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_suppress_radius("contour_hilo_suppress_radius", 15.0, " New Magics: Parameter contour_hilo_suppress_radius sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_max_value("contour_hilo_max_value", 1.0e+21, " New Magics: Parameter contour_hilo_max_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_min_value("contour_hilo_min_value", -1.0e+21, " New Magics: Parameter contour_hilo_min_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hi_max_value("contour_hi_max_value", 1.0e+21, " New Magics: Parameter contour_hi_max_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hi_min_value("contour_hi_min_value", -1.0e+21, " New Magics: Parameter contour_hi_min_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_lo_max_value("contour_lo_max_value", 1.0e+21, "");
static MagicsParameter<double> contour_lo_min_value("contour_lo_min_value", -1.0e+21, "");
static MagicsParameter<string> contour_hilo_marker("contour_hilo_marker", "off", "");
static MagicsParameter<string> contour_hilo_position_write("contour_hilo_position_write", "off", "");
#include "HiLoBoth.h"
#include "UserPoint.h"
#include "HiLoText.h"
#include "GeoPoint.h"
#include "HiLoNumber.h"
static SimpleObjectMaker<HiLoText<GeoPoint>, HiLoTechnique<GeoPoint> > text_HiLoText_GeoPoint("text");
static SimpleObjectMaker<HiLoText<UserPoint>, HiLoTechnique<UserPoint> > text_HiLoText_UserPoint("text");
static SimpleObjectMaker<HiLoNumber<GeoPoint>, HiLoTechnique<GeoPoint> > number_HiLoNumber_GeoPoint("number");
static SimpleObjectMaker<HiLoNumber<UserPoint>, HiLoTechnique<UserPoint> > number_HiLoNumber_UserPoint("number");
static SimpleObjectMaker<HiLoBoth<GeoPoint>, HiLoTechnique<GeoPoint> > both_HiLoBoth_GeoPoint("both");
static SimpleObjectMaker<HiLoBoth<UserPoint>, HiLoTechnique<UserPoint> > both_HiLoBoth_UserPoint("both");
#include "UserPoint.h"
#include "GeoPoint.h"
#include "HiLoMarker.h"
static SimpleObjectMaker<HiLoMarker<GeoPoint>, HiLoMarkerBase<GeoPoint> > on_HiLoMarker_GeoPoint("on");
static SimpleObjectMaker<HiLoMarker<GeoPoint>, HiLoMarkerBase<GeoPoint> > marker_HiLoMarker_GeoPoint("marker");
static SimpleObjectMaker<HiLoMarker<UserPoint>, HiLoMarkerBase<UserPoint> > on_HiLoMarker_UserPoint("on");
static SimpleObjectMaker<HiLoMarker<UserPoint>, HiLoMarkerBase<UserPoint> > marker_HiLoMarker_UserPoint("marker");
static SimpleObjectMaker<NoHiLoMarker<GeoPoint>, HiLoMarkerBase<GeoPoint> > off_NoHiLoMarker_GeoPoint("off");
static SimpleObjectMaker<NoHiLoMarker<GeoPoint>, HiLoMarkerBase<GeoPoint> > nomarker_NoHiLoMarker_GeoPoint("nomarker");
static SimpleObjectMaker<NoHiLoMarker<UserPoint>, HiLoMarkerBase<UserPoint> > off_NoHiLoMarker_UserPoint("off");
static SimpleObjectMaker<NoHiLoMarker<UserPoint>, HiLoMarkerBase<UserPoint> > nomarker_NoHiLoMarker_UserPoint("nomarker");
#include "UserPoint.h"
#include "HiLoSave.h"
#include "GeoPoint.h"
static SimpleObjectMaker<HiLoSave<GeoPoint>, HiLoSaveBase<GeoPoint> > on_HiLoSave_GeoPoint("on");
static SimpleObjectMaker<HiLoSave<GeoPoint>, HiLoSaveBase<GeoPoint> > save_HiLoSave_GeoPoint("save");
static SimpleObjectMaker<HiLoSave<UserPoint>, HiLoSaveBase<UserPoint> > on_HiLoSave_UserPoint("on");
static SimpleObjectMaker<HiLoSave<UserPoint>, HiLoSaveBase<UserPoint> > save_HiLoSave_UserPoint("save");
static SimpleObjectMaker<NoHiLoSave<GeoPoint>, HiLoSaveBase<GeoPoint> > off_NoHiLoSave_GeoPoint("off");
static SimpleObjectMaker<NoHiLoSave<GeoPoint>, HiLoSaveBase<GeoPoint> > nosave_NoHiLoSave_GeoPoint("nosave");
static SimpleObjectMaker<NoHiLoSave<UserPoint>, HiLoSaveBase<UserPoint> > off_NoHiLoSave_UserPoint("off");
static SimpleObjectMaker<NoHiLoSave<UserPoint>, HiLoSaveBase<UserPoint> > nosave_NoHiLoSave_UserPoint("nosave");
