.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtSet-Sensitive XtIs-Sensitive wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtSetSensitive __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtSetSensitive, XtIsSensitive \- set and check a widget's sensitivity state
.SH SYNTAX
.HP
void XtSetSensitive(Widget \fIw\fP, Boolean \fIsensitive\fP);
.HP
Boolean XtIsSensitive(Widget \fIw\fP);
.SH ARGUMENTS
.IP \fIsensitive\fP 1i
Specifies a Boolean value that indicates whether the widget should receive
keyboard and pointer events.
.IP \fIw\fP 1i
Specifies the widget.
.SH DESCRIPTION
The
.ZN XtSetSensitive
function first calls
.ZN XtSetValues
on the current widget with an argument list specifying that the
sensitive field should change to the new value.
It then recursively propagates the new value
down the managed children tree by calling
.ZN XtSetValues
on each child to set the ancestor_sensitive to the new value if the new
values for sensitive and the child's ancestor_sensitive are not the same.
.LP
.ZN XtSetSensitive
calls
.ZN XtSetValues
to change sensitive and ancestor_sensitive.
Therefore, when one of these changes,
the widget's set_values procedure should
take whatever display actions are needed
(for example, greying out or stippling the widget).
.LP
.ZN XtSetSensitive
maintains the invariant that if parent has either sensitive
or ancestor_sensitive
.ZN False ,
then all children have ancestor_sensitive
.ZN False .
.LP
The
.ZN XtIsSensitive
function returns
.ZN True
or
.ZN False
to indicate whether or not user input events are being dispatched.
If both core.sensitive and core.ancestor_sensitive are
.ZN True ,
.ZN XtIsSensitive
returns
.ZN True ;
otherwise, it returns
.ZN False .
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
