/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.jdo;

import org.apache.tools.ant.BuildException;

import xdoclet.DocletTask;

/**
 * This task that executes various JDO-specific sub-tasks.
 *
 * @author        Ludovic Claude (ludovicc@users.sourceforge.net)
 * @author        Marco Schulze (nlmarco@users.sourceforge.net) - added JDO 2.0 support (mainly changes in *.xdt)
 * @created       June 11, 20012
 * @version       $Revision: 1.5 $
 * @ant.element   name="jdodoclet" display-name="JDO Task"
 */
public class JdoDocletTask extends DocletTask
{
    /**
     * Defaults to JDO 1.0.
     */
    private String  jdoSpec = JdoSpecVersion.JDO_1_0;

    /**
     * Gets the JdoSpec attribute of the JdoDocletTask object
     *
     * @return   The JdoSpec value
     */
    public String getJdoSpec()
    {
        return jdoSpec;
    }

    /**
     * Sets the jdo spec to use. Valid values are "1.0" and "2.0". Default is "1.0"
     *
     * @param jdoSpec
     * @ant.not-required.
     */
    public void setJdoSpec(JdoSpecVersion jdoSpec)
    {
        this.jdoSpec = jdoSpec.getValue();
    }

    protected void validateOptions() throws BuildException
    {
        super.validateOptions();
    }

    /**
     * @author    Ludovic Claude (ludovicc@users.sourceforge.net)
     * @created   June 11, 20012
     */
    public static class JdoSpecVersion extends org.apache.tools.ant.types.EnumeratedAttribute
    {
        public final static String JDO_1_0 = "1.0";
        public final static String JDO_2_0 = "2.0";

        /**
         * Gets the Values attribute of the JdoSpecVersion object
         *
         * @return   The Values value
         */
        public java.lang.String[] getValues()
        {
            return (new java.lang.String[]{
                JDO_1_0, JDO_2_0
                });
        }
    }

}
