/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"



void WX11_DrawArrow (CmdInfo *cmd)
{
    //
    // Draw Filled Arrow in cmd
    //
    int GAP=3;

    Display *dpy=WX11_GetDisplay();
    Window win=cmd->win;
    GC gc=(cmd->gc) ? cmd->gc : WX11_GCGet();
    XPoint base[3];

    if (cmd->Tipo==SCROLL_UP)
    {
        base[0].x = (short) (cmd->Width)/2;
        base[0].y = (short) GAP;
        base[1].x = (short) (cmd->Width)-GAP;
        base[1].y = (short) (cmd->Height)-GAP;
        base[2].x = (short) GAP;
        base[2].y = (short) (cmd->Height)-GAP;
    }
    if (cmd->Tipo==SCROLL_DN)
    {
        base[0].x = (short) GAP; 
        base[0].y = (short) GAP;
        base[1].x = (short) (cmd->Width)-GAP; 
        base[1].y = (short) GAP;
        base[2].x = (short) (cmd->Width)/2;;
        base[2].y = (short) (cmd->Height)-GAP;
    }
    if (cmd->Tipo==SCROLL_SX)
    {
        base[0].x = (short) (cmd->Width)-GAP; 
        base[0].y = (short) GAP;
        base[1].x = (short) (cmd->Width)-GAP; 
        base[1].y = (short) (cmd->Height)-GAP;
        base[2].x = (short) GAP;
        base[2].y = (short) (cmd->Height)/2;
    }
    if (cmd->Tipo==SCROLL_DX)
    {
        base[0].x = (short) GAP; 
        base[0].y = (short) GAP;
        base[1].x = (short) (cmd->Width)-GAP; 
        base[1].y = (short) (cmd->Height)/2;
        base[2].x = (short) GAP;
        base[2].y = (short) (cmd->Height)-GAP;
    }

    XFillPolygon(dpy, win, gc,  base, 3, Convex, CoordModeOrigin);
}


int WX11_BorderSet (int depth, int type)
{
	return ((depth << 2) | type);	
}

int WX11_BorderGet (CmdInfo *cmd)
{
	
	return ((cmd->Bordo & 0xFFFC) >> 2);
}



void WX11_BorderRelief (CmdInfo *cmd)
{
/*
  Border Rilief

depth given by Bordo 

Tipo == 1 rilievo squadrato
Tipo == 2 rilievo arrotondato


   2 +---------------------------+ 3
     |+-------------------------+|
     ||+-----------------------+||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     ||+xxxxxxxxxxxxxxxxxxxxxxx+||
     |+-------------------------+|
   1 +---------------------------+ 4


     3  +---------------------+ 4
       /+---------------------+\
      //+---------------------+\\
   2 +++xxxxxxxxxxxxxxxxxxxxxxx+++ 5
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
     |||xxxxxxxxxxxxxxxxxxxxxxx|||
   1 +++xxxxxxxxxxxxxxxxxxxxxxx+++ 6
      \\+---------------------+//
       \+---------------------+/
     8  +---------------------+ 7

*/
    Display *dpy=WX11_GetDisplay();
    GC gc=(cmd->gc) ? cmd->gc : WX11_GCGet();
    Window win=cmd->parent;
    int depth=cmd->Bordo;

    XPoint base[6];
    int npoints=0;
    int Tipo=1;

    int i;
    unsigned int light=WX11_ColorLight(cmd->Bg);//WX11_ColorLight(WX11_ColorGet(WINBG));
    unsigned int dark=WX11_ColorDark(cmd->Bg);//WX11_ColorDark(WX11_ColorGet(WINBG));
    unsigned int c1,c2;

    c1=dark; c2=light;
    if (cmd->BUpDn) 
        {c2=dark; c1=light;}
    if ((cmd->Tipo==BUTTON || cmd->IsButton) && cmd->Focus)
        {c1=dark; c2=light;}

    for (i = 1; i <= depth; i++)
    {
        XSetForeground(dpy, gc, WX11_RGB(c1));
        if (Tipo==1)
        {
	        base[0].x = (short) (cmd->x)-i;				// 1x
        	base[0].y = (short) (cmd->y)+(cmd->Height)+i;		// 1y
	        base[1].x = (short) (cmd->x)-i;				// 2x
        	base[1].y = (short) (cmd->y)-i;				// 2y
	        base[2].x = (short) (cmd->x)+(cmd->Width)+i;		// 3x
        	base[2].y = (short) (cmd->y)-i;				// 3y
		npoints=3;
        }
        else if (Tipo==2)
        {

	        base[0].x = (short) (cmd->x)-i;				// 1x
        	base[0].y = (short) (cmd->y)+(cmd->Height)-1;		// 1y
        	base[1].x = (short) (cmd->x)-i;				// 2x
        	base[1].y = (short) (cmd->y);				// 2y
        	base[2].x = (short) (cmd->x);				// 3x
        	base[2].y = (short) (cmd->y)-i;				// 3y
        	base[3].x = (short) (cmd->x)+(cmd->Width)-1;		// 4x
        	base[3].y = (short) (cmd->y)-i;				// 4y
		npoints=4;
	}

	XDrawLines(dpy, win, gc, base, npoints, CoordModeOrigin);

        XSetForeground(dpy, gc, WX11_RGB(c2));
        if (Tipo==1)
        {
	        base[0].x = (short) (cmd->x)+(cmd->Width)+i;		// 3x
        	base[0].y = (short) (cmd->y)-i;				// 3y
	        base[1].x = (short) (cmd->x)+(cmd->Width)+i;		// 4x
        	base[1].y = (short) (cmd->y)+(cmd->Height)+i;		// 4y
	        base[2].x = (short) (cmd->x)-i;				// 1x
        	base[2].y = (short) (cmd->y)+(cmd->Height)+i;		// 1y
		npoints=3;
        }
        else if (Tipo==2)
        {

	        base[0].x = (short) (cmd->x)+(cmd->Width)-1;		// 4x
        	base[0].y = (short) (cmd->y)-i;				// 4y
	        base[1].x = (short) (cmd->x)+(cmd->Width)-1+i;		// 5x
        	base[1].y = (short) (cmd->y);				// 5y
	        base[2].x = (short) (cmd->x)+(cmd->Width)-1+i;		// 6x
        	base[2].y = (short) (cmd->y)+(cmd->Height)-1;		// 6y
	        base[3].x = (short) (cmd->x)+(cmd->Width)-1;		// 7x
        	base[3].y = (short) (cmd->y)+(cmd->Height)-1+i;		// 7y
	        base[4].x = (short) (cmd->x);				// 8x
        	base[4].y = (short) (cmd->y)+(cmd->Height)-1+i;		// 8y
	        base[5].x = (short) (cmd->x)-i;				// 1x
        	base[5].y = (short) (cmd->y)+(cmd->Height)-1;		// 1y
		npoints=6;
        }

	XDrawLines(dpy, win, gc, base, npoints, CoordModeOrigin);
    }

    XSetForeground(dpy, gc,WX11_RGB(WX11_ColorGet(WINFG)) );
}
