/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#ifndef wnconjH
#define wnconjH


double wn_penalty(double x);
double wn_dpenalty(double x);

double wn_barrier(double x);
double wn_dbarrier(double x);

double wn_barrier2(double x);
double wn_dbarrier2(double x);

double wn_clamp(double x);
double wn_dclamp(double x);

void wn_conj_direction_method
(
  int *pcode,
  double *pval_min,
  double vect[],
  int len,
  double (*pfunction)(double vect[]),
  int max_iterations
);
void wn_force_conj_direction_stop(void);

void wn_conj_gradient_method
(
  int *pcode,
  double *pval_min,
  double vect[],
  int len,
  double (*pfunction)(double vect[]),
  void (*pgradient)(double grad[],double vect[]),
  int max_iterations
);
void wn_conj_gradient_diff_method
(
  int *pcode,
  double *pval_min,
  double vect[],
  double delta_vect[],
  int len,
  double (*pfunction)(double vect[]),
  int max_iterations
);
void wn_force_conj_gradient_stop(void);


void wn_fit_parabola_3p
(
  int *pcode,
  double *pa,double *px0,double *pb,
  double x1,double y1,
  double x2,double y2,
  double x3,double y3
);
void wn_fit_parabola_2pd
(
  int *pcode,
  double *pa,double *px0,double *pb,
  double x1,double y1,double dy1,
  double x2,double y2
);

void wn_minimize_1d
(
  int *pcode,
  double *pval_min,
  double *px_min,
  double (*pfunction)(double x),
  int max_iterations
);
void wn_minimize_1d_raw
(
  int *pcode,
  double *pf0,
  double *pf1,
  double *pf2,
  double *px0,
  double *px1,
  double *px2,
  double f_goal,
  double (*pfunction)(double x),
  int max_iterations
);


#endif

