#GPL
#GPL  libwhisker copyright 2000,2001,2002 by rfp.labs
#GPL
#GPL  This program is free software; you can redistribute it and/or
#GPL  modify it under the terms of the GNU General Public License
#GPL  as published by the Free Software Foundation; either version 2
#GPL  of the License, or (at your option) any later version.
#GPL
#GPL  This program is distributed in the hope that it will be useful,
#GPL  but WITHOUT ANY WARRANTY; without even the implied warranty of
#GPL  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GPL  GNU General Public License for more details.
#GPL

=pod    


=head1 ++ Sub package: auth
        
The auth sub package implements HTTP authentication routines.

=cut

########################################################################

=pod    

=head1 - Function: LW::auth_brute_force
        
Params: $auth_method, \%hin, $user, \@passwords [, $domain]
Return: $first_valid_password, undef if error/none found

Perform a HTTP authentication brute force against a server (host and URI 
defined in %hin).  It will try every password in the password array for 
the given user.  The first password (in conjunction with the given user) 
that doesn't return HTTP 401 is returned (and the brute force is stopped 
at that point).  $domain is optional, and is only used for NTLM auth.

=cut

sub auth_brute_force {
 my ($auth_method, $hrin, $user, $pwordref, $dom)=@_;
 my ($P,%hout);

 return undef if(!defined $auth_method || length($auth_method)==0);
 return undef if(!defined $user        || length($user)       ==0);
 return undef if(!(defined $hrin     && ref($hrin)    ));
 return undef if(!(defined $pwordref && ref($pwordref)));

 map {
    ($P=$_)=~tr/\r\n//d;
    auth_set_header($auth_method,$hrin,$user,$P,$dom);
    return undef if(http_do_request($hrin,\%hout));
    return $P if($hout{'whisker'}->{'http_resp'} ne 401);
 } @$pwordref;

 return undef;}


########################################################################

=pod

=head1 - Function: LW::auth_set_header

Params: $auth_method, \%hin, $user, $password [, $domain]
Return: nothing (modifies %hin)

Set the appropriate authentication header in %hin.

NOTE: right now only BASIC and NTLM are supported.

=cut

sub auth_set_header {
 my ($method, $href, $user, $pass, $domain)=(lc(shift),@_);

 return if(!(defined $href && ref($href)));
 return if(!defined $user || !defined $pass);

 if($method eq 'basic'){
	$$href{'Authorization'}='Basic '.encode_base64($user.':'.$pass,'');
 }

 if($method eq 'proxy-basic'){
	$$href{'Proxy-Authorization'}='Basic '.encode_base64($user.':'.$pass,'');
 }

 if($method eq 'ntlm'){
	my $o=ntlm_new($user,$pass,$domain);
	$$href{'whisker'}->{'ntlm_obj'}=$o;
	$$href{'whisker'}->{'ntlm_step'}=0;
	$$href{'Authorization'}='NTLM '.ntlm_client($o);
 }

}


########################################################################

=pod

=head1 - Function: LW::do_auth

Params: $auth_method, \%hin, $user, $password [, $domain]
Return: nothing (modifies %hin)

This is an alias for auth_set_header().

=cut

sub do_auth {
	goto &auth_set_header;
}
