#!/usr/bin/perl

# this script is an example on how to make a HTTP request using libwhisker

$|++;
use LW;

# %request contains the request values passed to libwhisker/server
# %response contains the response values received from libwhisker/server
# %jar contains all our cookies
my (%request, %response, %jar);


# this sets up some standard values in the given hash
LW::http_init_request(\%request);


# set the target host and URI
$request{'whisker'}->{'host'}="www.wiretrip.net";
$request{'whisker'}->{'uri'}="/";
# $request{'whisker'}->{'port'}=80;  # port 80 is default


# SSL support seems ok, but still reserves the right to be buggy
#$request{'whisker'}->{'host'}="www.hushmail.com";
#$request{'whisker'}->{'port'}=443;
#$request{'whisker'}->{'ssl'}=1;
#$request{'whisker'}->{'save_ssl_info'}=1;


# proxy support
# $request{'whisker'}->{'proxy_host'}='localhost';
# $request{'whisker'}->{'proxy_port'}=8080;


# anti-IDS
# $request{'whisker'}->{'anti_ids'}='12345'; # values are the modes


# basic auth
#LW::do_auth('basic',\%request,'username','password');
#LW::do_auth('basic-proxy',\%request,'username','password');
#LW::do_auth('ntlm',\%request,'username','password');
#LW::do_auth('ntlm',\%request,'username','password','domain');


# special function to tweak the request to make sure it's valid HTTP 
# (not required if you set it all manually, but it never hurts)
LW::http_fixup_request(\%request);


# if there's any cookies in the %jar, then set them as appropriate
# LW::cookie_write(\%jar,\%request);

# actually make the request (and get response)
if(LW::http_do_request(\%request,\%response)){

	print 'ERROR: ', $response{'whisker'}->{'error'}, "\n";
	print $response{'whisker'}->{'data'}, "\n";

} else {

	# save any cookies sent to us into our %jar
	# LW::cookie_read(\%jar,\%response);

	print $response{'whisker'}->{'code'}, "\n"; # HTTP return code
	print $response{'Server'}, "\n";		# Server banner

#       Uncomment following line if you want to see resulting HTML data
#	print $response{'whisker'}->{'data'}, "\n";

	# If we are using the retry feature, we can print previous errors that
	# we didn't see
	if(defined $response{whisker}->{retry_errors}){
		print "Previous (retry) errors:\n\t";
		print join("\n\t",@{$response{whisker}->{retry_errors}});
		print "\n";
	}


	# If we wanted to save the SSL info (only works with Net::SSLeay)
	if(defined $request{whisker}->{save_ssl_info}){
		print 'SSL cipher: ',
			$response{whisker}->{ssl_cipher},"\n";
		print "Server cert:\n\t",
			$response{whisker}->{ssl_cert_subject},"\n";
		print "Cert issuer:\n\t",
			$response{whisker}->{ssl_cert_issuer},"\n";
	}

}


# good practice to clean up our mess
&LW::http_reset;
