/*
 * tifftclDecls.h --
 *
 *	Declarations of functions in the platform independent public TIFFTCL API.
 *
 */

#ifndef _TIFFTCLDECLS
#define _TIFFTCLDECLS

/*
 * WARNING: The contents of this file is automatically generated by the
 * genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the tifftcl.decls script.
 */

#include <tcl.h>
#include <tifftclDeclsMask.h>
#include <../tiffio.h>
#include <../tiffiop.h>
#include <../tif_predict.h>
#include <tifftclDeclsUnmask.h>

/* !BEGIN!: Do not edit below this line. */

/*
 * Ensure usage of <stdarg.h>
 */

#if defined(NO_STDARG)
#  error "This code requires <stdarg.h>"
#else
#  include <stdarg.h>
#endif

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN const char*	TIFFGetVersion _ANSI_ARGS_((void));
/* 1 */
EXTERN const TIFFCodec*	 TIFFFindCODEC _ANSI_ARGS_((uint16 a));
/* 2 */
EXTERN TIFFCodec*	TIFFRegisterCODEC _ANSI_ARGS_((uint16 a, 
				const char* b, TIFFInitMethod c));
/* 3 */
EXTERN void		TIFFUnRegisterCODEC _ANSI_ARGS_((TIFFCodec* a));
/* 4 */
EXTERN tdata_t		_TIFFmalloc _ANSI_ARGS_((tsize_t a));
/* 5 */
EXTERN tdata_t		_TIFFrealloc _ANSI_ARGS_((tdata_t a, tsize_t b));
/* 6 */
EXTERN void		_TIFFmemset _ANSI_ARGS_((tdata_t a, int b, tsize_t c));
/* 7 */
EXTERN void		_TIFFmemcpy _ANSI_ARGS_((tdata_t a, const tdata_t b, 
				tsize_t c));
/* 8 */
EXTERN int		_TIFFmemcmp _ANSI_ARGS_((const tdata_t a, 
				const tdata_t b, tsize_t c));
/* 9 */
EXTERN void		_TIFFfree _ANSI_ARGS_((tdata_t a));
/* 10 */
EXTERN void		TIFFClose _ANSI_ARGS_((TIFF* tiffptr));
/* 11 */
EXTERN int		TIFFFlush _ANSI_ARGS_((TIFF* tiffptr));
/* 12 */
EXTERN int		TIFFFlushData _ANSI_ARGS_((TIFF* tiffptr));
/* 13 */
EXTERN int		TIFFGetField _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, 
				... ));
/* 14 */
EXTERN int		TIFFVGetField _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, 
				va_list b));
/* 15 */
EXTERN int		TIFFGetFieldDefaulted _ANSI_ARGS_((TIFF* tiffptr, 
				ttag_t a, ... ));
/* 16 */
EXTERN int		TIFFVGetFieldDefaulted _ANSI_ARGS_((TIFF* tiffptr, 
				ttag_t a, va_list b));
/* 17 */
EXTERN int		TIFFReadDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 18 */
EXTERN tsize_t		TIFFScanlineSize _ANSI_ARGS_((TIFF* tiffptr));
/* 19 */
EXTERN tsize_t		TIFFRasterScanlineSize _ANSI_ARGS_((TIFF* tiffptr));
/* 20 */
EXTERN tsize_t		TIFFStripSize _ANSI_ARGS_((TIFF* tiffptr));
/* 21 */
EXTERN tsize_t		TIFFVStripSize _ANSI_ARGS_((TIFF* tiffptr, uint32 a));
/* 22 */
EXTERN tsize_t		TIFFTileRowSize _ANSI_ARGS_((TIFF* tiffptr));
/* 23 */
EXTERN tsize_t		TIFFTileSize _ANSI_ARGS_((TIFF* tiffptr));
/* 24 */
EXTERN tsize_t		TIFFVTileSize _ANSI_ARGS_((TIFF* tiffptr, uint32 a));
/* 25 */
EXTERN uint32		TIFFDefaultStripSize _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a));
/* 26 */
EXTERN void		TIFFDefaultTileSize _ANSI_ARGS_((TIFF* tiffptr, 
				uint32* a, uint32* b));
/* 27 */
EXTERN int		TIFFFileno _ANSI_ARGS_((TIFF* tiffptr));
/* 28 */
EXTERN int		TIFFGetMode _ANSI_ARGS_((TIFF* tiffptr));
/* 29 */
EXTERN int		TIFFIsTiled _ANSI_ARGS_((TIFF* tiffptr));
/* 30 */
EXTERN int		TIFFIsByteSwapped _ANSI_ARGS_((TIFF* tiffptr));
/* 31 */
EXTERN int		TIFFIsUpSampled _ANSI_ARGS_((TIFF* tiffptr));
/* 32 */
EXTERN int		TIFFIsMSB2LSB _ANSI_ARGS_((TIFF* tiffptr));
/* 33 */
EXTERN uint32		TIFFCurrentRow _ANSI_ARGS_((TIFF* tiffptr));
/* 34 */
EXTERN tdir_t		TIFFCurrentDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 35 */
EXTERN tdir_t		TIFFNumberOfDirectories _ANSI_ARGS_((TIFF* tiffptr));
/* 36 */
EXTERN uint32		TIFFCurrentDirOffset _ANSI_ARGS_((TIFF* tiffptr));
/* 37 */
EXTERN tstrip_t		TIFFCurrentStrip _ANSI_ARGS_((TIFF* tiffptr));
/* 38 */
EXTERN ttile_t		TIFFCurrentTile _ANSI_ARGS_((TIFF* tiffptr));
/* 39 */
EXTERN int		TIFFReadBufferSetup _ANSI_ARGS_((TIFF* tiffptr, 
				tdata_t a, tsize_t b));
/* 40 */
EXTERN int		TIFFWriteBufferSetup _ANSI_ARGS_((TIFF* tiffptr, 
				tdata_t a, tsize_t b));
/* 41 */
EXTERN int		TIFFWriteCheck _ANSI_ARGS_((TIFF* tiffptr, int a, 
				const char * b));
/* 42 */
EXTERN int		TIFFCreateDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 43 */
EXTERN int		TIFFLastDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 44 */
EXTERN int		TIFFSetDirectory _ANSI_ARGS_((TIFF* tiffptr, 
				tdir_t a));
/* 45 */
EXTERN int		TIFFSetSubDirectory _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a));
/* 46 */
EXTERN int		TIFFUnlinkDirectory _ANSI_ARGS_((TIFF* tiffptr, 
				tdir_t a));
/* 47 */
EXTERN int		TIFFSetField _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, 
				... ));
/* 48 */
EXTERN int		TIFFVSetField _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, 
				va_list b));
/* 49 */
EXTERN int		TIFFWriteDirectory _ANSI_ARGS_((TIFF * tiffptr));
/* 50 */
EXTERN int		TIFFReassignTagToIgnore _ANSI_ARGS_((
				enum TIFFIgnoreSense a, int b));
/* 51 */
EXTERN void		TIFFPrintDirectory _ANSI_ARGS_((TIFF* tiffptr, 
				FILE* a, long b));
/* 52 */
EXTERN int		TIFFReadScanline _ANSI_ARGS_((TIFF* tiffptr, 
				tdata_t a, uint32 b, tsample_t c));
/* 53 */
EXTERN int		TIFFWriteScanline _ANSI_ARGS_((TIFF* tiffptr, 
				tdata_t a, uint32 b, tsample_t c));
/* 54 */
EXTERN int		TIFFReadRGBAImage _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a, uint32 b, uint32* c, int d));
/* 55 */
EXTERN int		TIFFReadRGBAStrip _ANSI_ARGS_((TIFF* tiffptr, 
				tstrip_t a, uint32 * b));
/* 56 */
EXTERN int		TIFFReadRGBATile _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a, uint32 b, uint32 * c));
/* 57 */
EXTERN int		TIFFRGBAImageOK _ANSI_ARGS_((TIFF* tiffptr, char* a));
/* 58 */
EXTERN int		TIFFRGBAImageBegin _ANSI_ARGS_((TIFFRGBAImage* a, 
				TIFF* tiffptr, int b, char* c));
/* 59 */
EXTERN int		TIFFRGBAImageGet _ANSI_ARGS_((TIFFRGBAImage* d, 
				uint32* c, uint32 b, uint32 a));
/* 60 */
EXTERN void		TIFFRGBAImageEnd _ANSI_ARGS_((TIFFRGBAImage* a));
/* 61 */
EXTERN TIFF*		TIFFOpen _ANSI_ARGS_((const char* b, const char* a));
/* 62 */
EXTERN TIFF*		TIFFFdOpen _ANSI_ARGS_((int a, const char* b, 
				const char* c));
/* 63 */
EXTERN TIFF*		TIFFClientOpen _ANSI_ARGS_((const char* a, 
				const char* b, thandle_t c, 
				TIFFReadWriteProc d, TIFFReadWriteProc e, 
				TIFFSeekProc f, TIFFCloseProc g, 
				TIFFSizeProc h, TIFFMapFileProc i, 
				TIFFUnmapFileProc j));
/* 64 */
EXTERN const char*	TIFFFileName _ANSI_ARGS_((TIFF* tiffptr));
/* 65 */
EXTERN void		TIFFError _ANSI_ARGS_((const char* a, const char* b, 
				... ));
/* 66 */
EXTERN void		TIFFWarning _ANSI_ARGS_((const char* a, 
				const char* b, ... ));
/* 67 */
EXTERN TIFFErrorHandler	 TIFFSetErrorHandler _ANSI_ARGS_((TIFFErrorHandler a));
/* 68 */
EXTERN TIFFErrorHandler	 TIFFSetWarningHandler _ANSI_ARGS_((
				TIFFErrorHandler a));
/* 69 */
EXTERN TIFFExtendProc	TIFFSetTagExtender _ANSI_ARGS_((TIFFExtendProc a));
/* 70 */
EXTERN ttile_t		TIFFComputeTile _ANSI_ARGS_((TIFF* tiffptr, uint32 a, 
				uint32 b, uint32 c, tsample_t d));
/* 71 */
EXTERN int		TIFFCheckTile _ANSI_ARGS_((TIFF* tiffptr, uint32 d, 
				uint32 c, uint32 b, tsample_t a));
/* 72 */
EXTERN ttile_t		TIFFNumberOfTiles _ANSI_ARGS_((TIFF* tiffptr));
/* 73 */
EXTERN tsize_t		TIFFReadTile _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, 
				uint32 b, uint32 c, uint32 d, tsample_t e));
/* 74 */
EXTERN tsize_t		TIFFWriteTile _ANSI_ARGS_((TIFF* tiffptr, tdata_t e, 
				uint32 d, uint32 c, uint32 b, tsample_t a));
/* 75 */
EXTERN tstrip_t		TIFFComputeStrip _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a, tsample_t b));
/* 76 */
EXTERN tstrip_t		TIFFNumberOfStrips _ANSI_ARGS_((TIFF* tiffptr));
/* 77 */
EXTERN tsize_t		TIFFReadEncodedStrip _ANSI_ARGS_((TIFF* tiffptr, 
				tstrip_t a, tdata_t b, tsize_t c));
/* 78 */
EXTERN tsize_t		TIFFReadRawStrip _ANSI_ARGS_((TIFF* tiffptr, 
				tstrip_t a, tdata_t b, tsize_t c));
/* 79 */
EXTERN tsize_t		TIFFReadEncodedTile _ANSI_ARGS_((TIFF* tiffptr, 
				ttile_t a, tdata_t b, tsize_t c));
/* 80 */
EXTERN tsize_t		TIFFReadRawTile _ANSI_ARGS_((TIFF* tiffptr, 
				ttile_t c, tdata_t b, tsize_t a));
/* 81 */
EXTERN tsize_t		TIFFWriteEncodedStrip _ANSI_ARGS_((TIFF* tiffptr, 
				tstrip_t a, tdata_t b, tsize_t c));
/* 82 */
EXTERN tsize_t		TIFFWriteRawStrip _ANSI_ARGS_((TIFF* tiffptr, 
				tstrip_t a, tdata_t b, tsize_t c));
/* 83 */
EXTERN tsize_t		TIFFWriteEncodedTile _ANSI_ARGS_((TIFF* tiffptr, 
				ttile_t a, tdata_t b, tsize_t c));
/* 84 */
EXTERN tsize_t		TIFFWriteRawTile _ANSI_ARGS_((TIFF* tiffptr, 
				ttile_t c, tdata_t b, tsize_t a));
/* 85 */
EXTERN void		TIFFSetWriteOffset _ANSI_ARGS_((TIFF* tiffptr, 
				toff_t a));
/* 86 */
EXTERN void		TIFFSwabShort _ANSI_ARGS_((uint16* a));
/* 87 */
EXTERN void		TIFFSwabLong _ANSI_ARGS_((uint32* a));
/* 88 */
EXTERN void		TIFFSwabDouble _ANSI_ARGS_((double* a));
/* 89 */
EXTERN void		TIFFSwabArrayOfShort _ANSI_ARGS_((uint16* a, 
				unsigned long b));
/* 90 */
EXTERN void		TIFFSwabArrayOfLong _ANSI_ARGS_((uint32* b, 
				unsigned long a));
/* 91 */
EXTERN void		TIFFSwabArrayOfDouble _ANSI_ARGS_((double* a, 
				unsigned long b));
/* 92 */
EXTERN void		TIFFReverseBits _ANSI_ARGS_((unsigned char* a, 
				unsigned long b));
/* 93 */
EXTERN const unsigned char* TIFFGetBitRevTable _ANSI_ARGS_((int a));
/* Slot 94 is reserved */
/* Slot 95 is reserved */
/* Slot 96 is reserved */
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
/* 100 */
EXTERN int		TIFFPredictorInit _ANSI_ARGS_((TIFF* tiffptr));
/* Slot 101 is reserved */
/* Slot 102 is reserved */
/* Slot 103 is reserved */
/* Slot 104 is reserved */
/* Slot 105 is reserved */
/* Slot 106 is reserved */
/* Slot 107 is reserved */
/* Slot 108 is reserved */
/* Slot 109 is reserved */
/* 110 */
EXTERN void		_TIFFSetupFieldInfo _ANSI_ARGS_((TIFF* tiffptr));
/* 111 */
EXTERN void		_TIFFMergeFieldInfo _ANSI_ARGS_((TIFF* tiffptr, 
				const TIFFFieldInfo* a, int b));
/* 112 */
EXTERN void		_TIFFPrintFieldInfo _ANSI_ARGS_((TIFF* tiffptr, 
				FILE* a));
/* 113 */
EXTERN const TIFFFieldInfo* _TIFFFindFieldInfo _ANSI_ARGS_((TIFF* tiffptr, 
				ttag_t a, TIFFDataType b));
/* 114 */
EXTERN const TIFFFieldInfo* _TIFFFieldWithTag _ANSI_ARGS_((TIFF* tiffptr, 
				ttag_t a));
/* 115 */
EXTERN TIFFDataType	_TIFFSampleToTagType _ANSI_ARGS_((TIFF* tiffptr));
/* Slot 116 is reserved */
/* Slot 117 is reserved */
/* Slot 118 is reserved */
/* Slot 119 is reserved */
/* 120 */
EXTERN int		_TIFFgetMode _ANSI_ARGS_((const char* a, 
				const char* b));
/* 121 */
EXTERN int		_TIFFNoRowEncode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b, tsample_t c));
/* 122 */
EXTERN int		_TIFFNoStripEncode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t c, tsize_t b, tsample_t a));
/* 123 */
EXTERN int		_TIFFNoTileEncode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b, tsample_t c));
/* 124 */
EXTERN int		_TIFFNoRowDecode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t c, tsize_t b, tsample_t a));
/* 125 */
EXTERN int		_TIFFNoStripDecode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b, tsample_t c));
/* 126 */
EXTERN int		_TIFFNoTileDecode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t c, tsize_t b, tsample_t a));
/* 127 */
EXTERN void		_TIFFNoPostDecode _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b));
/* 128 */
EXTERN int		_TIFFNoPreCode _ANSI_ARGS_((TIFF* tiffptr, 
				tsample_t a));
/* 129 */
EXTERN int		_TIFFNoSeek _ANSI_ARGS_((TIFF* tiffptr, uint32 a));
/* 130 */
EXTERN void		_TIFFSwab16BitData _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b));
/* 131 */
EXTERN void		_TIFFSwab32BitData _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t b, tsize_t a));
/* 132 */
EXTERN void		_TIFFSwab64BitData _ANSI_ARGS_((TIFF* tiffptr, 
				tidata_t a, tsize_t b));
/* 133 */
EXTERN int		TIFFFlushData1 _ANSI_ARGS_((TIFF* tiffptr));
/* 134 */
EXTERN void		TIFFFreeDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 135 */
EXTERN int		TIFFDefaultDirectory _ANSI_ARGS_((TIFF* tiffptr));
/* 136 */
EXTERN int		TIFFSetCompressionScheme _ANSI_ARGS_((TIFF* tiffptr, 
				int a));
/* 137 */
EXTERN int		_TIFFSetDefaultCompressionState _ANSI_ARGS_((
				TIFF* tiffptr));
/* 138 */
EXTERN uint32		_TIFFDefaultStripSize _ANSI_ARGS_((TIFF* tiffptr, 
				uint32 a));
/* 139 */
EXTERN void		_TIFFDefaultTileSize _ANSI_ARGS_((TIFF* tiffptr, 
				uint32* a, uint32* b));
/* 140 */
EXTERN void		_TIFFsetByteArray _ANSI_ARGS_((void** a, void* b, 
				long c));
/* 141 */
EXTERN void		_TIFFsetString _ANSI_ARGS_((char** a, char* b));
/* 142 */
EXTERN void		_TIFFsetShortArray _ANSI_ARGS_((uint16** a, 
				uint16* b, long c));
/* 143 */
EXTERN void		_TIFFsetLongArray _ANSI_ARGS_((uint32** a, uint32* b, 
				long c));
/* 144 */
EXTERN void		_TIFFsetFloatArray _ANSI_ARGS_((float** a, float* b, 
				long c));
/* 145 */
EXTERN void		_TIFFsetDoubleArray _ANSI_ARGS_((double** a, 
				double* b, long c));
/* 146 */
EXTERN void		_TIFFprintAscii _ANSI_ARGS_((FILE* a, const char* b));
/* 147 */
EXTERN void		_TIFFprintAsciiTag _ANSI_ARGS_((FILE* a, 
				const char* b, const char* c));
/* 148 */
EXTERN int		TIFFInitDumpMode _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 149 */
EXTERN int		TIFFInitPackBits _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 150 */
EXTERN int		TIFFInitCCITTRLE _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 151 */
EXTERN int		TIFFInitCCITTRLEW _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 152 */
EXTERN int		TIFFInitCCITTFax3 _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 153 */
EXTERN int		TIFFInitCCITTFax4 _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 154 */
EXTERN int		TIFFInitThunderScan _ANSI_ARGS_((TIFF* tiffptr, 
				int a));
/* 155 */
EXTERN int		TIFFInitNeXT _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 156 */
EXTERN int		TIFFInitLZW _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 157 */
EXTERN int		TIFFInitOJPEG _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 158 */
EXTERN int		TIFFInitJPEG _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 159 */
EXTERN int		TIFFInitJBIG _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 160 */
EXTERN int		TIFFInitZIP _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 161 */
EXTERN int		TIFFInitPixarLog _ANSI_ARGS_((TIFF* tiffptr, int a));
/* 162 */
EXTERN int		TIFFInitSGILog _ANSI_ARGS_((TIFF* tiffptr, int a));

typedef struct TifftclStubs {
    int magic;
    struct TifftclStubHooks *hooks;

    const char* (*tIFFGetVersion) _ANSI_ARGS_((void)); /* 0 */
    const TIFFCodec* (*tIFFFindCODEC) _ANSI_ARGS_((uint16 a)); /* 1 */
    TIFFCodec* (*tIFFRegisterCODEC) _ANSI_ARGS_((uint16 a, const char* b, TIFFInitMethod c)); /* 2 */
    void (*tIFFUnRegisterCODEC) _ANSI_ARGS_((TIFFCodec* a)); /* 3 */
    tdata_t (*_TIFFmalloc) _ANSI_ARGS_((tsize_t a)); /* 4 */
    tdata_t (*_TIFFrealloc) _ANSI_ARGS_((tdata_t a, tsize_t b)); /* 5 */
    void (*_TIFFmemset) _ANSI_ARGS_((tdata_t a, int b, tsize_t c)); /* 6 */
    void (*_TIFFmemcpy) _ANSI_ARGS_((tdata_t a, const tdata_t b, tsize_t c)); /* 7 */
    int (*_TIFFmemcmp) _ANSI_ARGS_((const tdata_t a, const tdata_t b, tsize_t c)); /* 8 */
    void (*_TIFFfree) _ANSI_ARGS_((tdata_t a)); /* 9 */
    void (*tIFFClose) _ANSI_ARGS_((TIFF* tiffptr)); /* 10 */
    int (*tIFFFlush) _ANSI_ARGS_((TIFF* tiffptr)); /* 11 */
    int (*tIFFFlushData) _ANSI_ARGS_((TIFF* tiffptr)); /* 12 */
    int (*tIFFGetField) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, ... )); /* 13 */
    int (*tIFFVGetField) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, va_list b)); /* 14 */
    int (*tIFFGetFieldDefaulted) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, ... )); /* 15 */
    int (*tIFFVGetFieldDefaulted) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, va_list b)); /* 16 */
    int (*tIFFReadDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 17 */
    tsize_t (*tIFFScanlineSize) _ANSI_ARGS_((TIFF* tiffptr)); /* 18 */
    tsize_t (*tIFFRasterScanlineSize) _ANSI_ARGS_((TIFF* tiffptr)); /* 19 */
    tsize_t (*tIFFStripSize) _ANSI_ARGS_((TIFF* tiffptr)); /* 20 */
    tsize_t (*tIFFVStripSize) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 21 */
    tsize_t (*tIFFTileRowSize) _ANSI_ARGS_((TIFF* tiffptr)); /* 22 */
    tsize_t (*tIFFTileSize) _ANSI_ARGS_((TIFF* tiffptr)); /* 23 */
    tsize_t (*tIFFVTileSize) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 24 */
    uint32 (*tIFFDefaultStripSize) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 25 */
    void (*tIFFDefaultTileSize) _ANSI_ARGS_((TIFF* tiffptr, uint32* a, uint32* b)); /* 26 */
    int (*tIFFFileno) _ANSI_ARGS_((TIFF* tiffptr)); /* 27 */
    int (*tIFFGetMode) _ANSI_ARGS_((TIFF* tiffptr)); /* 28 */
    int (*tIFFIsTiled) _ANSI_ARGS_((TIFF* tiffptr)); /* 29 */
    int (*tIFFIsByteSwapped) _ANSI_ARGS_((TIFF* tiffptr)); /* 30 */
    int (*tIFFIsUpSampled) _ANSI_ARGS_((TIFF* tiffptr)); /* 31 */
    int (*tIFFIsMSB2LSB) _ANSI_ARGS_((TIFF* tiffptr)); /* 32 */
    uint32 (*tIFFCurrentRow) _ANSI_ARGS_((TIFF* tiffptr)); /* 33 */
    tdir_t (*tIFFCurrentDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 34 */
    tdir_t (*tIFFNumberOfDirectories) _ANSI_ARGS_((TIFF* tiffptr)); /* 35 */
    uint32 (*tIFFCurrentDirOffset) _ANSI_ARGS_((TIFF* tiffptr)); /* 36 */
    tstrip_t (*tIFFCurrentStrip) _ANSI_ARGS_((TIFF* tiffptr)); /* 37 */
    ttile_t (*tIFFCurrentTile) _ANSI_ARGS_((TIFF* tiffptr)); /* 38 */
    int (*tIFFReadBufferSetup) _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, tsize_t b)); /* 39 */
    int (*tIFFWriteBufferSetup) _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, tsize_t b)); /* 40 */
    int (*tIFFWriteCheck) _ANSI_ARGS_((TIFF* tiffptr, int a, const char * b)); /* 41 */
    int (*tIFFCreateDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 42 */
    int (*tIFFLastDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 43 */
    int (*tIFFSetDirectory) _ANSI_ARGS_((TIFF* tiffptr, tdir_t a)); /* 44 */
    int (*tIFFSetSubDirectory) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 45 */
    int (*tIFFUnlinkDirectory) _ANSI_ARGS_((TIFF* tiffptr, tdir_t a)); /* 46 */
    int (*tIFFSetField) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, ... )); /* 47 */
    int (*tIFFVSetField) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, va_list b)); /* 48 */
    int (*tIFFWriteDirectory) _ANSI_ARGS_((TIFF * tiffptr)); /* 49 */
    int (*tIFFReassignTagToIgnore) _ANSI_ARGS_((enum TIFFIgnoreSense a, int b)); /* 50 */
    void (*tIFFPrintDirectory) _ANSI_ARGS_((TIFF* tiffptr, FILE* a, long b)); /* 51 */
    int (*tIFFReadScanline) _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, uint32 b, tsample_t c)); /* 52 */
    int (*tIFFWriteScanline) _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, uint32 b, tsample_t c)); /* 53 */
    int (*tIFFReadRGBAImage) _ANSI_ARGS_((TIFF* tiffptr, uint32 a, uint32 b, uint32* c, int d)); /* 54 */
    int (*tIFFReadRGBAStrip) _ANSI_ARGS_((TIFF* tiffptr, tstrip_t a, uint32 * b)); /* 55 */
    int (*tIFFReadRGBATile) _ANSI_ARGS_((TIFF* tiffptr, uint32 a, uint32 b, uint32 * c)); /* 56 */
    int (*tIFFRGBAImageOK) _ANSI_ARGS_((TIFF* tiffptr, char* a)); /* 57 */
    int (*tIFFRGBAImageBegin) _ANSI_ARGS_((TIFFRGBAImage* a, TIFF* tiffptr, int b, char* c)); /* 58 */
    int (*tIFFRGBAImageGet) _ANSI_ARGS_((TIFFRGBAImage* d, uint32* c, uint32 b, uint32 a)); /* 59 */
    void (*tIFFRGBAImageEnd) _ANSI_ARGS_((TIFFRGBAImage* a)); /* 60 */
    TIFF* (*tIFFOpen) _ANSI_ARGS_((const char* b, const char* a)); /* 61 */
    TIFF* (*tIFFFdOpen) _ANSI_ARGS_((int a, const char* b, const char* c)); /* 62 */
    TIFF* (*tIFFClientOpen) _ANSI_ARGS_((const char* a, const char* b, thandle_t c, TIFFReadWriteProc d, TIFFReadWriteProc e, TIFFSeekProc f, TIFFCloseProc g, TIFFSizeProc h, TIFFMapFileProc i, TIFFUnmapFileProc j)); /* 63 */
    const char* (*tIFFFileName) _ANSI_ARGS_((TIFF* tiffptr)); /* 64 */
    void (*tIFFError) _ANSI_ARGS_((const char* a, const char* b, ... )); /* 65 */
    void (*tIFFWarning) _ANSI_ARGS_((const char* a, const char* b, ... )); /* 66 */
    TIFFErrorHandler (*tIFFSetErrorHandler) _ANSI_ARGS_((TIFFErrorHandler a)); /* 67 */
    TIFFErrorHandler (*tIFFSetWarningHandler) _ANSI_ARGS_((TIFFErrorHandler a)); /* 68 */
    TIFFExtendProc (*tIFFSetTagExtender) _ANSI_ARGS_((TIFFExtendProc a)); /* 69 */
    ttile_t (*tIFFComputeTile) _ANSI_ARGS_((TIFF* tiffptr, uint32 a, uint32 b, uint32 c, tsample_t d)); /* 70 */
    int (*tIFFCheckTile) _ANSI_ARGS_((TIFF* tiffptr, uint32 d, uint32 c, uint32 b, tsample_t a)); /* 71 */
    ttile_t (*tIFFNumberOfTiles) _ANSI_ARGS_((TIFF* tiffptr)); /* 72 */
    tsize_t (*tIFFReadTile) _ANSI_ARGS_((TIFF* tiffptr, tdata_t a, uint32 b, uint32 c, uint32 d, tsample_t e)); /* 73 */
    tsize_t (*tIFFWriteTile) _ANSI_ARGS_((TIFF* tiffptr, tdata_t e, uint32 d, uint32 c, uint32 b, tsample_t a)); /* 74 */
    tstrip_t (*tIFFComputeStrip) _ANSI_ARGS_((TIFF* tiffptr, uint32 a, tsample_t b)); /* 75 */
    tstrip_t (*tIFFNumberOfStrips) _ANSI_ARGS_((TIFF* tiffptr)); /* 76 */
    tsize_t (*tIFFReadEncodedStrip) _ANSI_ARGS_((TIFF* tiffptr, tstrip_t a, tdata_t b, tsize_t c)); /* 77 */
    tsize_t (*tIFFReadRawStrip) _ANSI_ARGS_((TIFF* tiffptr, tstrip_t a, tdata_t b, tsize_t c)); /* 78 */
    tsize_t (*tIFFReadEncodedTile) _ANSI_ARGS_((TIFF* tiffptr, ttile_t a, tdata_t b, tsize_t c)); /* 79 */
    tsize_t (*tIFFReadRawTile) _ANSI_ARGS_((TIFF* tiffptr, ttile_t c, tdata_t b, tsize_t a)); /* 80 */
    tsize_t (*tIFFWriteEncodedStrip) _ANSI_ARGS_((TIFF* tiffptr, tstrip_t a, tdata_t b, tsize_t c)); /* 81 */
    tsize_t (*tIFFWriteRawStrip) _ANSI_ARGS_((TIFF* tiffptr, tstrip_t a, tdata_t b, tsize_t c)); /* 82 */
    tsize_t (*tIFFWriteEncodedTile) _ANSI_ARGS_((TIFF* tiffptr, ttile_t a, tdata_t b, tsize_t c)); /* 83 */
    tsize_t (*tIFFWriteRawTile) _ANSI_ARGS_((TIFF* tiffptr, ttile_t c, tdata_t b, tsize_t a)); /* 84 */
    void (*tIFFSetWriteOffset) _ANSI_ARGS_((TIFF* tiffptr, toff_t a)); /* 85 */
    void (*tIFFSwabShort) _ANSI_ARGS_((uint16* a)); /* 86 */
    void (*tIFFSwabLong) _ANSI_ARGS_((uint32* a)); /* 87 */
    void (*tIFFSwabDouble) _ANSI_ARGS_((double* a)); /* 88 */
    void (*tIFFSwabArrayOfShort) _ANSI_ARGS_((uint16* a, unsigned long b)); /* 89 */
    void (*tIFFSwabArrayOfLong) _ANSI_ARGS_((uint32* b, unsigned long a)); /* 90 */
    void (*tIFFSwabArrayOfDouble) _ANSI_ARGS_((double* a, unsigned long b)); /* 91 */
    void (*tIFFReverseBits) _ANSI_ARGS_((unsigned char* a, unsigned long b)); /* 92 */
    const unsigned char* (*tIFFGetBitRevTable) _ANSI_ARGS_((int a)); /* 93 */
    void *reserved94;
    void *reserved95;
    void *reserved96;
    void *reserved97;
    void *reserved98;
    void *reserved99;
    int (*tIFFPredictorInit) _ANSI_ARGS_((TIFF* tiffptr)); /* 100 */
    void *reserved101;
    void *reserved102;
    void *reserved103;
    void *reserved104;
    void *reserved105;
    void *reserved106;
    void *reserved107;
    void *reserved108;
    void *reserved109;
    void (*_TIFFSetupFieldInfo) _ANSI_ARGS_((TIFF* tiffptr)); /* 110 */
    void (*_TIFFMergeFieldInfo) _ANSI_ARGS_((TIFF* tiffptr, const TIFFFieldInfo* a, int b)); /* 111 */
    void (*_TIFFPrintFieldInfo) _ANSI_ARGS_((TIFF* tiffptr, FILE* a)); /* 112 */
    const TIFFFieldInfo* (*_TIFFFindFieldInfo) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a, TIFFDataType b)); /* 113 */
    const TIFFFieldInfo* (*_TIFFFieldWithTag) _ANSI_ARGS_((TIFF* tiffptr, ttag_t a)); /* 114 */
    TIFFDataType (*_TIFFSampleToTagType) _ANSI_ARGS_((TIFF* tiffptr)); /* 115 */
    void *reserved116;
    void *reserved117;
    void *reserved118;
    void *reserved119;
    int (*_TIFFgetMode) _ANSI_ARGS_((const char* a, const char* b)); /* 120 */
    int (*_TIFFNoRowEncode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b, tsample_t c)); /* 121 */
    int (*_TIFFNoStripEncode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t c, tsize_t b, tsample_t a)); /* 122 */
    int (*_TIFFNoTileEncode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b, tsample_t c)); /* 123 */
    int (*_TIFFNoRowDecode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t c, tsize_t b, tsample_t a)); /* 124 */
    int (*_TIFFNoStripDecode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b, tsample_t c)); /* 125 */
    int (*_TIFFNoTileDecode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t c, tsize_t b, tsample_t a)); /* 126 */
    void (*_TIFFNoPostDecode) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b)); /* 127 */
    int (*_TIFFNoPreCode) _ANSI_ARGS_((TIFF* tiffptr, tsample_t a)); /* 128 */
    int (*_TIFFNoSeek) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 129 */
    void (*_TIFFSwab16BitData) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b)); /* 130 */
    void (*_TIFFSwab32BitData) _ANSI_ARGS_((TIFF* tiffptr, tidata_t b, tsize_t a)); /* 131 */
    void (*_TIFFSwab64BitData) _ANSI_ARGS_((TIFF* tiffptr, tidata_t a, tsize_t b)); /* 132 */
    int (*tIFFFlushData1) _ANSI_ARGS_((TIFF* tiffptr)); /* 133 */
    void (*tIFFFreeDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 134 */
    int (*tIFFDefaultDirectory) _ANSI_ARGS_((TIFF* tiffptr)); /* 135 */
    int (*tIFFSetCompressionScheme) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 136 */
    int (*_TIFFSetDefaultCompressionState) _ANSI_ARGS_((TIFF* tiffptr)); /* 137 */
    uint32 (*_TIFFDefaultStripSize) _ANSI_ARGS_((TIFF* tiffptr, uint32 a)); /* 138 */
    void (*_TIFFDefaultTileSize) _ANSI_ARGS_((TIFF* tiffptr, uint32* a, uint32* b)); /* 139 */
    void (*_TIFFsetByteArray) _ANSI_ARGS_((void** a, void* b, long c)); /* 140 */
    void (*_TIFFsetString) _ANSI_ARGS_((char** a, char* b)); /* 141 */
    void (*_TIFFsetShortArray) _ANSI_ARGS_((uint16** a, uint16* b, long c)); /* 142 */
    void (*_TIFFsetLongArray) _ANSI_ARGS_((uint32** a, uint32* b, long c)); /* 143 */
    void (*_TIFFsetFloatArray) _ANSI_ARGS_((float** a, float* b, long c)); /* 144 */
    void (*_TIFFsetDoubleArray) _ANSI_ARGS_((double** a, double* b, long c)); /* 145 */
    void (*_TIFFprintAscii) _ANSI_ARGS_((FILE* a, const char* b)); /* 146 */
    void (*_TIFFprintAsciiTag) _ANSI_ARGS_((FILE* a, const char* b, const char* c)); /* 147 */
    int (*tIFFInitDumpMode) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 148 */
    int (*tIFFInitPackBits) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 149 */
    int (*tIFFInitCCITTRLE) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 150 */
    int (*tIFFInitCCITTRLEW) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 151 */
    int (*tIFFInitCCITTFax3) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 152 */
    int (*tIFFInitCCITTFax4) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 153 */
    int (*tIFFInitThunderScan) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 154 */
    int (*tIFFInitNeXT) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 155 */
    int (*tIFFInitLZW) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 156 */
    int (*tIFFInitOJPEG) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 157 */
    int (*tIFFInitJPEG) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 158 */
    int (*tIFFInitJBIG) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 159 */
    int (*tIFFInitZIP) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 160 */
    int (*tIFFInitPixarLog) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 161 */
    int (*tIFFInitSGILog) _ANSI_ARGS_((TIFF* tiffptr, int a)); /* 162 */
} TifftclStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern TifftclStubs *tifftclStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TIFFTCL_STUBS) && !defined(USE_TIFFTCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef TIFFGetVersion
#define TIFFGetVersion \
	(tifftclStubsPtr->tIFFGetVersion) /* 0 */
#endif
#ifndef TIFFFindCODEC
#define TIFFFindCODEC \
	(tifftclStubsPtr->tIFFFindCODEC) /* 1 */
#endif
#ifndef TIFFRegisterCODEC
#define TIFFRegisterCODEC \
	(tifftclStubsPtr->tIFFRegisterCODEC) /* 2 */
#endif
#ifndef TIFFUnRegisterCODEC
#define TIFFUnRegisterCODEC \
	(tifftclStubsPtr->tIFFUnRegisterCODEC) /* 3 */
#endif
#ifndef _TIFFmalloc
#define _TIFFmalloc \
	(tifftclStubsPtr->_TIFFmalloc) /* 4 */
#endif
#ifndef _TIFFrealloc
#define _TIFFrealloc \
	(tifftclStubsPtr->_TIFFrealloc) /* 5 */
#endif
#ifndef _TIFFmemset
#define _TIFFmemset \
	(tifftclStubsPtr->_TIFFmemset) /* 6 */
#endif
#ifndef _TIFFmemcpy
#define _TIFFmemcpy \
	(tifftclStubsPtr->_TIFFmemcpy) /* 7 */
#endif
#ifndef _TIFFmemcmp
#define _TIFFmemcmp \
	(tifftclStubsPtr->_TIFFmemcmp) /* 8 */
#endif
#ifndef _TIFFfree
#define _TIFFfree \
	(tifftclStubsPtr->_TIFFfree) /* 9 */
#endif
#ifndef TIFFClose
#define TIFFClose \
	(tifftclStubsPtr->tIFFClose) /* 10 */
#endif
#ifndef TIFFFlush
#define TIFFFlush \
	(tifftclStubsPtr->tIFFFlush) /* 11 */
#endif
#ifndef TIFFFlushData
#define TIFFFlushData \
	(tifftclStubsPtr->tIFFFlushData) /* 12 */
#endif
#ifndef TIFFGetField
#define TIFFGetField \
	(tifftclStubsPtr->tIFFGetField) /* 13 */
#endif
#ifndef TIFFVGetField
#define TIFFVGetField \
	(tifftclStubsPtr->tIFFVGetField) /* 14 */
#endif
#ifndef TIFFGetFieldDefaulted
#define TIFFGetFieldDefaulted \
	(tifftclStubsPtr->tIFFGetFieldDefaulted) /* 15 */
#endif
#ifndef TIFFVGetFieldDefaulted
#define TIFFVGetFieldDefaulted \
	(tifftclStubsPtr->tIFFVGetFieldDefaulted) /* 16 */
#endif
#ifndef TIFFReadDirectory
#define TIFFReadDirectory \
	(tifftclStubsPtr->tIFFReadDirectory) /* 17 */
#endif
#ifndef TIFFScanlineSize
#define TIFFScanlineSize \
	(tifftclStubsPtr->tIFFScanlineSize) /* 18 */
#endif
#ifndef TIFFRasterScanlineSize
#define TIFFRasterScanlineSize \
	(tifftclStubsPtr->tIFFRasterScanlineSize) /* 19 */
#endif
#ifndef TIFFStripSize
#define TIFFStripSize \
	(tifftclStubsPtr->tIFFStripSize) /* 20 */
#endif
#ifndef TIFFVStripSize
#define TIFFVStripSize \
	(tifftclStubsPtr->tIFFVStripSize) /* 21 */
#endif
#ifndef TIFFTileRowSize
#define TIFFTileRowSize \
	(tifftclStubsPtr->tIFFTileRowSize) /* 22 */
#endif
#ifndef TIFFTileSize
#define TIFFTileSize \
	(tifftclStubsPtr->tIFFTileSize) /* 23 */
#endif
#ifndef TIFFVTileSize
#define TIFFVTileSize \
	(tifftclStubsPtr->tIFFVTileSize) /* 24 */
#endif
#ifndef TIFFDefaultStripSize
#define TIFFDefaultStripSize \
	(tifftclStubsPtr->tIFFDefaultStripSize) /* 25 */
#endif
#ifndef TIFFDefaultTileSize
#define TIFFDefaultTileSize \
	(tifftclStubsPtr->tIFFDefaultTileSize) /* 26 */
#endif
#ifndef TIFFFileno
#define TIFFFileno \
	(tifftclStubsPtr->tIFFFileno) /* 27 */
#endif
#ifndef TIFFGetMode
#define TIFFGetMode \
	(tifftclStubsPtr->tIFFGetMode) /* 28 */
#endif
#ifndef TIFFIsTiled
#define TIFFIsTiled \
	(tifftclStubsPtr->tIFFIsTiled) /* 29 */
#endif
#ifndef TIFFIsByteSwapped
#define TIFFIsByteSwapped \
	(tifftclStubsPtr->tIFFIsByteSwapped) /* 30 */
#endif
#ifndef TIFFIsUpSampled
#define TIFFIsUpSampled \
	(tifftclStubsPtr->tIFFIsUpSampled) /* 31 */
#endif
#ifndef TIFFIsMSB2LSB
#define TIFFIsMSB2LSB \
	(tifftclStubsPtr->tIFFIsMSB2LSB) /* 32 */
#endif
#ifndef TIFFCurrentRow
#define TIFFCurrentRow \
	(tifftclStubsPtr->tIFFCurrentRow) /* 33 */
#endif
#ifndef TIFFCurrentDirectory
#define TIFFCurrentDirectory \
	(tifftclStubsPtr->tIFFCurrentDirectory) /* 34 */
#endif
#ifndef TIFFNumberOfDirectories
#define TIFFNumberOfDirectories \
	(tifftclStubsPtr->tIFFNumberOfDirectories) /* 35 */
#endif
#ifndef TIFFCurrentDirOffset
#define TIFFCurrentDirOffset \
	(tifftclStubsPtr->tIFFCurrentDirOffset) /* 36 */
#endif
#ifndef TIFFCurrentStrip
#define TIFFCurrentStrip \
	(tifftclStubsPtr->tIFFCurrentStrip) /* 37 */
#endif
#ifndef TIFFCurrentTile
#define TIFFCurrentTile \
	(tifftclStubsPtr->tIFFCurrentTile) /* 38 */
#endif
#ifndef TIFFReadBufferSetup
#define TIFFReadBufferSetup \
	(tifftclStubsPtr->tIFFReadBufferSetup) /* 39 */
#endif
#ifndef TIFFWriteBufferSetup
#define TIFFWriteBufferSetup \
	(tifftclStubsPtr->tIFFWriteBufferSetup) /* 40 */
#endif
#ifndef TIFFWriteCheck
#define TIFFWriteCheck \
	(tifftclStubsPtr->tIFFWriteCheck) /* 41 */
#endif
#ifndef TIFFCreateDirectory
#define TIFFCreateDirectory \
	(tifftclStubsPtr->tIFFCreateDirectory) /* 42 */
#endif
#ifndef TIFFLastDirectory
#define TIFFLastDirectory \
	(tifftclStubsPtr->tIFFLastDirectory) /* 43 */
#endif
#ifndef TIFFSetDirectory
#define TIFFSetDirectory \
	(tifftclStubsPtr->tIFFSetDirectory) /* 44 */
#endif
#ifndef TIFFSetSubDirectory
#define TIFFSetSubDirectory \
	(tifftclStubsPtr->tIFFSetSubDirectory) /* 45 */
#endif
#ifndef TIFFUnlinkDirectory
#define TIFFUnlinkDirectory \
	(tifftclStubsPtr->tIFFUnlinkDirectory) /* 46 */
#endif
#ifndef TIFFSetField
#define TIFFSetField \
	(tifftclStubsPtr->tIFFSetField) /* 47 */
#endif
#ifndef TIFFVSetField
#define TIFFVSetField \
	(tifftclStubsPtr->tIFFVSetField) /* 48 */
#endif
#ifndef TIFFWriteDirectory
#define TIFFWriteDirectory \
	(tifftclStubsPtr->tIFFWriteDirectory) /* 49 */
#endif
#ifndef TIFFReassignTagToIgnore
#define TIFFReassignTagToIgnore \
	(tifftclStubsPtr->tIFFReassignTagToIgnore) /* 50 */
#endif
#ifndef TIFFPrintDirectory
#define TIFFPrintDirectory \
	(tifftclStubsPtr->tIFFPrintDirectory) /* 51 */
#endif
#ifndef TIFFReadScanline
#define TIFFReadScanline \
	(tifftclStubsPtr->tIFFReadScanline) /* 52 */
#endif
#ifndef TIFFWriteScanline
#define TIFFWriteScanline \
	(tifftclStubsPtr->tIFFWriteScanline) /* 53 */
#endif
#ifndef TIFFReadRGBAImage
#define TIFFReadRGBAImage \
	(tifftclStubsPtr->tIFFReadRGBAImage) /* 54 */
#endif
#ifndef TIFFReadRGBAStrip
#define TIFFReadRGBAStrip \
	(tifftclStubsPtr->tIFFReadRGBAStrip) /* 55 */
#endif
#ifndef TIFFReadRGBATile
#define TIFFReadRGBATile \
	(tifftclStubsPtr->tIFFReadRGBATile) /* 56 */
#endif
#ifndef TIFFRGBAImageOK
#define TIFFRGBAImageOK \
	(tifftclStubsPtr->tIFFRGBAImageOK) /* 57 */
#endif
#ifndef TIFFRGBAImageBegin
#define TIFFRGBAImageBegin \
	(tifftclStubsPtr->tIFFRGBAImageBegin) /* 58 */
#endif
#ifndef TIFFRGBAImageGet
#define TIFFRGBAImageGet \
	(tifftclStubsPtr->tIFFRGBAImageGet) /* 59 */
#endif
#ifndef TIFFRGBAImageEnd
#define TIFFRGBAImageEnd \
	(tifftclStubsPtr->tIFFRGBAImageEnd) /* 60 */
#endif
#ifndef TIFFOpen
#define TIFFOpen \
	(tifftclStubsPtr->tIFFOpen) /* 61 */
#endif
#ifndef TIFFFdOpen
#define TIFFFdOpen \
	(tifftclStubsPtr->tIFFFdOpen) /* 62 */
#endif
#ifndef TIFFClientOpen
#define TIFFClientOpen \
	(tifftclStubsPtr->tIFFClientOpen) /* 63 */
#endif
#ifndef TIFFFileName
#define TIFFFileName \
	(tifftclStubsPtr->tIFFFileName) /* 64 */
#endif
#ifndef TIFFError
#define TIFFError \
	(tifftclStubsPtr->tIFFError) /* 65 */
#endif
#ifndef TIFFWarning
#define TIFFWarning \
	(tifftclStubsPtr->tIFFWarning) /* 66 */
#endif
#ifndef TIFFSetErrorHandler
#define TIFFSetErrorHandler \
	(tifftclStubsPtr->tIFFSetErrorHandler) /* 67 */
#endif
#ifndef TIFFSetWarningHandler
#define TIFFSetWarningHandler \
	(tifftclStubsPtr->tIFFSetWarningHandler) /* 68 */
#endif
#ifndef TIFFSetTagExtender
#define TIFFSetTagExtender \
	(tifftclStubsPtr->tIFFSetTagExtender) /* 69 */
#endif
#ifndef TIFFComputeTile
#define TIFFComputeTile \
	(tifftclStubsPtr->tIFFComputeTile) /* 70 */
#endif
#ifndef TIFFCheckTile
#define TIFFCheckTile \
	(tifftclStubsPtr->tIFFCheckTile) /* 71 */
#endif
#ifndef TIFFNumberOfTiles
#define TIFFNumberOfTiles \
	(tifftclStubsPtr->tIFFNumberOfTiles) /* 72 */
#endif
#ifndef TIFFReadTile
#define TIFFReadTile \
	(tifftclStubsPtr->tIFFReadTile) /* 73 */
#endif
#ifndef TIFFWriteTile
#define TIFFWriteTile \
	(tifftclStubsPtr->tIFFWriteTile) /* 74 */
#endif
#ifndef TIFFComputeStrip
#define TIFFComputeStrip \
	(tifftclStubsPtr->tIFFComputeStrip) /* 75 */
#endif
#ifndef TIFFNumberOfStrips
#define TIFFNumberOfStrips \
	(tifftclStubsPtr->tIFFNumberOfStrips) /* 76 */
#endif
#ifndef TIFFReadEncodedStrip
#define TIFFReadEncodedStrip \
	(tifftclStubsPtr->tIFFReadEncodedStrip) /* 77 */
#endif
#ifndef TIFFReadRawStrip
#define TIFFReadRawStrip \
	(tifftclStubsPtr->tIFFReadRawStrip) /* 78 */
#endif
#ifndef TIFFReadEncodedTile
#define TIFFReadEncodedTile \
	(tifftclStubsPtr->tIFFReadEncodedTile) /* 79 */
#endif
#ifndef TIFFReadRawTile
#define TIFFReadRawTile \
	(tifftclStubsPtr->tIFFReadRawTile) /* 80 */
#endif
#ifndef TIFFWriteEncodedStrip
#define TIFFWriteEncodedStrip \
	(tifftclStubsPtr->tIFFWriteEncodedStrip) /* 81 */
#endif
#ifndef TIFFWriteRawStrip
#define TIFFWriteRawStrip \
	(tifftclStubsPtr->tIFFWriteRawStrip) /* 82 */
#endif
#ifndef TIFFWriteEncodedTile
#define TIFFWriteEncodedTile \
	(tifftclStubsPtr->tIFFWriteEncodedTile) /* 83 */
#endif
#ifndef TIFFWriteRawTile
#define TIFFWriteRawTile \
	(tifftclStubsPtr->tIFFWriteRawTile) /* 84 */
#endif
#ifndef TIFFSetWriteOffset
#define TIFFSetWriteOffset \
	(tifftclStubsPtr->tIFFSetWriteOffset) /* 85 */
#endif
#ifndef TIFFSwabShort
#define TIFFSwabShort \
	(tifftclStubsPtr->tIFFSwabShort) /* 86 */
#endif
#ifndef TIFFSwabLong
#define TIFFSwabLong \
	(tifftclStubsPtr->tIFFSwabLong) /* 87 */
#endif
#ifndef TIFFSwabDouble
#define TIFFSwabDouble \
	(tifftclStubsPtr->tIFFSwabDouble) /* 88 */
#endif
#ifndef TIFFSwabArrayOfShort
#define TIFFSwabArrayOfShort \
	(tifftclStubsPtr->tIFFSwabArrayOfShort) /* 89 */
#endif
#ifndef TIFFSwabArrayOfLong
#define TIFFSwabArrayOfLong \
	(tifftclStubsPtr->tIFFSwabArrayOfLong) /* 90 */
#endif
#ifndef TIFFSwabArrayOfDouble
#define TIFFSwabArrayOfDouble \
	(tifftclStubsPtr->tIFFSwabArrayOfDouble) /* 91 */
#endif
#ifndef TIFFReverseBits
#define TIFFReverseBits \
	(tifftclStubsPtr->tIFFReverseBits) /* 92 */
#endif
#ifndef TIFFGetBitRevTable
#define TIFFGetBitRevTable \
	(tifftclStubsPtr->tIFFGetBitRevTable) /* 93 */
#endif
/* Slot 94 is reserved */
/* Slot 95 is reserved */
/* Slot 96 is reserved */
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
#ifndef TIFFPredictorInit
#define TIFFPredictorInit \
	(tifftclStubsPtr->tIFFPredictorInit) /* 100 */
#endif
/* Slot 101 is reserved */
/* Slot 102 is reserved */
/* Slot 103 is reserved */
/* Slot 104 is reserved */
/* Slot 105 is reserved */
/* Slot 106 is reserved */
/* Slot 107 is reserved */
/* Slot 108 is reserved */
/* Slot 109 is reserved */
#ifndef _TIFFSetupFieldInfo
#define _TIFFSetupFieldInfo \
	(tifftclStubsPtr->_TIFFSetupFieldInfo) /* 110 */
#endif
#ifndef _TIFFMergeFieldInfo
#define _TIFFMergeFieldInfo \
	(tifftclStubsPtr->_TIFFMergeFieldInfo) /* 111 */
#endif
#ifndef _TIFFPrintFieldInfo
#define _TIFFPrintFieldInfo \
	(tifftclStubsPtr->_TIFFPrintFieldInfo) /* 112 */
#endif
#ifndef _TIFFFindFieldInfo
#define _TIFFFindFieldInfo \
	(tifftclStubsPtr->_TIFFFindFieldInfo) /* 113 */
#endif
#ifndef _TIFFFieldWithTag
#define _TIFFFieldWithTag \
	(tifftclStubsPtr->_TIFFFieldWithTag) /* 114 */
#endif
#ifndef _TIFFSampleToTagType
#define _TIFFSampleToTagType \
	(tifftclStubsPtr->_TIFFSampleToTagType) /* 115 */
#endif
/* Slot 116 is reserved */
/* Slot 117 is reserved */
/* Slot 118 is reserved */
/* Slot 119 is reserved */
#ifndef _TIFFgetMode
#define _TIFFgetMode \
	(tifftclStubsPtr->_TIFFgetMode) /* 120 */
#endif
#ifndef _TIFFNoRowEncode
#define _TIFFNoRowEncode \
	(tifftclStubsPtr->_TIFFNoRowEncode) /* 121 */
#endif
#ifndef _TIFFNoStripEncode
#define _TIFFNoStripEncode \
	(tifftclStubsPtr->_TIFFNoStripEncode) /* 122 */
#endif
#ifndef _TIFFNoTileEncode
#define _TIFFNoTileEncode \
	(tifftclStubsPtr->_TIFFNoTileEncode) /* 123 */
#endif
#ifndef _TIFFNoRowDecode
#define _TIFFNoRowDecode \
	(tifftclStubsPtr->_TIFFNoRowDecode) /* 124 */
#endif
#ifndef _TIFFNoStripDecode
#define _TIFFNoStripDecode \
	(tifftclStubsPtr->_TIFFNoStripDecode) /* 125 */
#endif
#ifndef _TIFFNoTileDecode
#define _TIFFNoTileDecode \
	(tifftclStubsPtr->_TIFFNoTileDecode) /* 126 */
#endif
#ifndef _TIFFNoPostDecode
#define _TIFFNoPostDecode \
	(tifftclStubsPtr->_TIFFNoPostDecode) /* 127 */
#endif
#ifndef _TIFFNoPreCode
#define _TIFFNoPreCode \
	(tifftclStubsPtr->_TIFFNoPreCode) /* 128 */
#endif
#ifndef _TIFFNoSeek
#define _TIFFNoSeek \
	(tifftclStubsPtr->_TIFFNoSeek) /* 129 */
#endif
#ifndef _TIFFSwab16BitData
#define _TIFFSwab16BitData \
	(tifftclStubsPtr->_TIFFSwab16BitData) /* 130 */
#endif
#ifndef _TIFFSwab32BitData
#define _TIFFSwab32BitData \
	(tifftclStubsPtr->_TIFFSwab32BitData) /* 131 */
#endif
#ifndef _TIFFSwab64BitData
#define _TIFFSwab64BitData \
	(tifftclStubsPtr->_TIFFSwab64BitData) /* 132 */
#endif
#ifndef TIFFFlushData1
#define TIFFFlushData1 \
	(tifftclStubsPtr->tIFFFlushData1) /* 133 */
#endif
#ifndef TIFFFreeDirectory
#define TIFFFreeDirectory \
	(tifftclStubsPtr->tIFFFreeDirectory) /* 134 */
#endif
#ifndef TIFFDefaultDirectory
#define TIFFDefaultDirectory \
	(tifftclStubsPtr->tIFFDefaultDirectory) /* 135 */
#endif
#ifndef TIFFSetCompressionScheme
#define TIFFSetCompressionScheme \
	(tifftclStubsPtr->tIFFSetCompressionScheme) /* 136 */
#endif
#ifndef _TIFFSetDefaultCompressionState
#define _TIFFSetDefaultCompressionState \
	(tifftclStubsPtr->_TIFFSetDefaultCompressionState) /* 137 */
#endif
#ifndef _TIFFDefaultStripSize
#define _TIFFDefaultStripSize \
	(tifftclStubsPtr->_TIFFDefaultStripSize) /* 138 */
#endif
#ifndef _TIFFDefaultTileSize
#define _TIFFDefaultTileSize \
	(tifftclStubsPtr->_TIFFDefaultTileSize) /* 139 */
#endif
#ifndef _TIFFsetByteArray
#define _TIFFsetByteArray \
	(tifftclStubsPtr->_TIFFsetByteArray) /* 140 */
#endif
#ifndef _TIFFsetString
#define _TIFFsetString \
	(tifftclStubsPtr->_TIFFsetString) /* 141 */
#endif
#ifndef _TIFFsetShortArray
#define _TIFFsetShortArray \
	(tifftclStubsPtr->_TIFFsetShortArray) /* 142 */
#endif
#ifndef _TIFFsetLongArray
#define _TIFFsetLongArray \
	(tifftclStubsPtr->_TIFFsetLongArray) /* 143 */
#endif
#ifndef _TIFFsetFloatArray
#define _TIFFsetFloatArray \
	(tifftclStubsPtr->_TIFFsetFloatArray) /* 144 */
#endif
#ifndef _TIFFsetDoubleArray
#define _TIFFsetDoubleArray \
	(tifftclStubsPtr->_TIFFsetDoubleArray) /* 145 */
#endif
#ifndef _TIFFprintAscii
#define _TIFFprintAscii \
	(tifftclStubsPtr->_TIFFprintAscii) /* 146 */
#endif
#ifndef _TIFFprintAsciiTag
#define _TIFFprintAsciiTag \
	(tifftclStubsPtr->_TIFFprintAsciiTag) /* 147 */
#endif
#ifndef TIFFInitDumpMode
#define TIFFInitDumpMode \
	(tifftclStubsPtr->tIFFInitDumpMode) /* 148 */
#endif
#ifndef TIFFInitPackBits
#define TIFFInitPackBits \
	(tifftclStubsPtr->tIFFInitPackBits) /* 149 */
#endif
#ifndef TIFFInitCCITTRLE
#define TIFFInitCCITTRLE \
	(tifftclStubsPtr->tIFFInitCCITTRLE) /* 150 */
#endif
#ifndef TIFFInitCCITTRLEW
#define TIFFInitCCITTRLEW \
	(tifftclStubsPtr->tIFFInitCCITTRLEW) /* 151 */
#endif
#ifndef TIFFInitCCITTFax3
#define TIFFInitCCITTFax3 \
	(tifftclStubsPtr->tIFFInitCCITTFax3) /* 152 */
#endif
#ifndef TIFFInitCCITTFax4
#define TIFFInitCCITTFax4 \
	(tifftclStubsPtr->tIFFInitCCITTFax4) /* 153 */
#endif
#ifndef TIFFInitThunderScan
#define TIFFInitThunderScan \
	(tifftclStubsPtr->tIFFInitThunderScan) /* 154 */
#endif
#ifndef TIFFInitNeXT
#define TIFFInitNeXT \
	(tifftclStubsPtr->tIFFInitNeXT) /* 155 */
#endif
#ifndef TIFFInitLZW
#define TIFFInitLZW \
	(tifftclStubsPtr->tIFFInitLZW) /* 156 */
#endif
#ifndef TIFFInitOJPEG
#define TIFFInitOJPEG \
	(tifftclStubsPtr->tIFFInitOJPEG) /* 157 */
#endif
#ifndef TIFFInitJPEG
#define TIFFInitJPEG \
	(tifftclStubsPtr->tIFFInitJPEG) /* 158 */
#endif
#ifndef TIFFInitJBIG
#define TIFFInitJBIG \
	(tifftclStubsPtr->tIFFInitJBIG) /* 159 */
#endif
#ifndef TIFFInitZIP
#define TIFFInitZIP \
	(tifftclStubsPtr->tIFFInitZIP) /* 160 */
#endif
#ifndef TIFFInitPixarLog
#define TIFFInitPixarLog \
	(tifftclStubsPtr->tIFFInitPixarLog) /* 161 */
#endif
#ifndef TIFFInitSGILog
#define TIFFInitSGILog \
	(tifftclStubsPtr->tIFFInitSGILog) /* 162 */
#endif

#endif /* defined(USE_TIFFTCL_STUBS) && !defined(USE_TIFFTCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TIFFTCLDECLS */

