/*  ti_link - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_REGFILE__
#define __TIFFEP_REGFILE__

#include <glib.h>

#include "tiffep.h"

/*
 * The registry variable contain the whole linked list of the
 * registry entries.
 */
typedef GList TiffepRegistry;
extern TiffepRegistry *registry;

/*********/
/* Types */
/*********/

/* Describe a registry entry */
struct registry_entry
{
  GString *name;
  GString *description;
  GString *path;
  GString *type;
  GString *calc;
  GString *var;
  GString *status;
};
//typedef struct registry_entry TiffepRegistryEntry;
typedef struct registry_entry TiffepRegistryEntry;

/*************/
/* Functions */
/*************/

TIEXPORT
int registry_get_pointer(GList **registry_pointer);
#define tiffep_registry_get_pointer registry_get_pointer

TIEXPORT
int registry_read_file();
#define tiffep_registry_read_file registry_read_file
TIEXPORT
int registry_write_file();
#define tiffep_registry_write_file registry_write_file
TIEXPORT
int registry_is_file_exist();

TIEXPORT
int registry_add_entry(TiffepRegistryEntry *entry);
#define tiffep_registry_add_entry registry_add_entry
TIEXPORT
int registry_remove_entry(gchar *name);
#define tiffep_registry_remove_entry registry_remove_entry

TIEXPORT
int registry_search_entry_by_name(gchar *name, TiffepRegistry *main_registry, 
				  TiffepRegistry **sub_registry);
#define tiffep_registry_search_entry_by_name registry_search_entry_by_name
TIEXPORT
int registry_search_entry_by_type(gchar *type, TiffepRegistry *main_registry, 
				  TiffepRegistry **sub_registry);
#define tiffep_registry_search_entry_by_type registry_search_entry_by_type
TIEXPORT
int registry_search_entry_by_calc(gchar *calc, TiffepRegistry *main_registry, 
				  TiffepRegistry **sub_registry);
#define tiffep_registry_search_entry_by_calc registry_search_entry_by_calc
TIEXPORT
int registry_search_entry_by_var (gchar *var , TiffepRegistry *main_registry, 
				  TiffepRegistry **sub_registry);
#define tiffep_registry_search_entry_by_var registry_search_entry_by_var

TIEXPORT
int registry_enable_entry(TiffepRegistryEntry *entry);
#define tiffep_registry_enable_entry registry_enable_entry
TIEXPORT
int registry_disable_entry(TiffepRegistryEntry *entry);
#define tiffep_registry_disable_entry registry_disable_entry
TIEXPORT 
int registry_entry_is_enabled(TiffepRegistryEntry *entry);
#define tiffep_registry_entry_is_enabled registry_entry_is_enabled


#endif

