/*  ti_link - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_INTERFACE__
#define __TIFFEP_INTERFACE__

/* Functions */
/*
  Returns the library version number
  - const char* [out]: the version number such as "X.X.X"
*/
TIEXPORT
const char *tiffep_get_version();

/*
 * Load a plugin for the specified file
 * - filename [in]: the filename (with full path) of the file to use
 * - app_path [out]: location of the plugin to execute (must be freed when no longer used !)
 * - int [out]: the result of the operation
 */
TIEXPORT
int tiffep_load_plugin(gchar *filename, gchar **app_path);


TIEXPORT
int tiffep_server_is_running();
TIEXPORT
int tiffep_connect(TiffepShm *s);

#endif

