/*  tilp - link program for TI calculators
 *  Copyright (C) 1999,2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_DEFS85__
#define __TIFFEP_DEFS85__

// Devicetype

#define PC_TI85 0x05
#define TI85_PC 0x85

// Commands

#define CMD85_VAR_HEADER  0x06
#define CMD85_WAIT_DATA   0x09
#define CMD85_DATA_PART   0x15
#define CMD85_REFUSED     0x36
#define CMD85_TI_OK       0x56
#define CMD85_PC_OK       0x56
#define CMD85_CHK_ERROR   0x5A
#define CMD85_SCREEN_DUMP 0x6D
#define CMD85_CONTINUE    0x78
#define CMD85_EOT         0x92

// Types of variable

#define TI85_REAL  0x00
#define TI85_CPLX  0x01
#define TI85_VECTR 0x02
#define TI85_LIST  0x04
#define TI85_MATRX 0x06
#define TI85_CONS  0x08
#define TI85_EQU   0x0A
#define TI85_STRNG 0x0C
#define TI85_GDB   0x0D
#define TI85_PIC   0x11
#define TI85_RANGE 0x17

// Screen coordinates of the TI85

#define TI85_ROWS  64
#define TI85_COLS  128

#endif
