./cproto: Generate C++ prototypes from an Ada spec

Processing: common-cpp.ads
// C++ header file partially generated from Ada using cproto.adb

extern "C" {

//----------------------------------------------------------------------------
// COMMON (C++ Interface)                                                   --
//                                                                          --
// Part of TextTools                                                        --
// Designed and Programmed by Ken O. Burtch                                 --
//                                                                          --
//----------------------------------------------------------------------------
//                                                                          --
//                 Copyright (C) 1999-2002 Ken O. Burtch                    --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------
//with Gen_List;
//  pragma Elaborate( Gen_List ); -- remind Ada to elaborate generics first
//with Ada; use Ada;
//with Ada.Strings; use Ada.Strings; -- overrides our "strings" package
//with Ada.Strings.Bounded;
//with Ada.Strings.Maps;
//
//with Interfaces.C;
//use  Interfaces.C;
// C language support


//type C_String is new char_array(0..255 );
// C-style string for C language support

// Str255 Bounded String: C++ wrapper functions

typedef struct _str255_list_list {
  void *first;
  void *last;
  long count;
  void *freecache;
  long lastrec;
  void *lastptr;
} str255_list_list;

typedef long str255list_a_list_index;

extern void str255list_get_allocation( str255list_a_list_index *allocation );

extern unsigned char str255list_memory_leak( str255list_a_list_index allocation );

extern void str255list_compact( str255list_list *the_list );

extern void str255list_clear( str255list_list *the_list );

extern void str255list_copy( str255list_list *from_list, str255list_list *to_list );

extern void str255list_copy2( str255list_list *from_list, str255list_list *to_list1, str255list_list *to_list2 );

extern void str255list_move( str255list_list *from_list, str255list_list_list *to_list );

extern void str255list_swap( str255list_list *list1, str255list_list *list2 );

extern void str255list_push( str255list_list *the_list, str255 new_data );

extern void str255list_queue( str255list_list *the_list, str255 data );

extern void str255list_insert( str255list_list *the_list, str255 data );

extern void str255list_insert2( str255list_list *the_list, str255list_a_list_index at_index, str255 data );

extern void str255list_pull( str255list_list *the_list, str255 *data );

extern void str255list_discard( str255list_list *the_list );

extern void str255list_cut( str255list_list *the_list, str255list_a_list_index at_index, str255 *data );

extern void str255list_clear_item( str255list_list *the_list, str255list_a_list_index at_index );

extern void str255list_replace( str255list_list *the_list, str255list_a_list_index at_index, str255 data );

extern void str255list_find( str255list_list *the_list, str255list_a_list_index at_index, str255 *data );

extern void str255list_lookup( str255list_list *the_list, str255 *data, str255list_a_list_index start, str255list_a_list_index *found_at );

extern str255list_a_list_index str255list_length( str255list_list *the_list );

extern unsigned char str255list_is_empty( str255list_list *the_list );

extern void str255list_sublist( str255list_list *the_list, str255list_a_list_index index, str255list_a_list_index len, str255list_list *result );

extern void str255list_concat( str255list_list *list1, str255list_list *list2, str255_list_list *result );

//procedure Startup_Common( theProgramName, theShortProgramName : C_string );
//pragma export( C, Startup_Common, "startup_common" );


// Boolean List: C++ wrapper functions

typedef struct _boolean_list_list {
  void *first;
  void *last;
  long count;
  void *freecache;
  long lastrec;
  void *lastptr;
} boolean_list_list;

extern void boolean_list_get_allocation( boolean_list._alist_index *allocation );

extern unsigned char boolean_list_memory_leak( boolean_list._alist_index allocation );

extern void boolean_list_compact( boolean_list_list *the_list );

extern void boolean_list_clear( boolean_list_list *the_list );

extern void boolean_list_copy( boolean_list_list *from_list, [type] to_list );

extern void boolean_list_copy2( boolean_list_list *from_list, [type] to_list1, [type] to_list2 );

extern void boolean_list_move( boolean_list_list *from_list, [type] to_list );

extern void boolean_list_swap( boolean_list_list *list1, [type] list2 );

extern void boolean_list_push( boolean_list_list *the_list, unsigned char new_data );

extern void boolean_list_queue( boolean_list_list *the_list, unsigned char data );

extern void boolean_list_insert( boolean_list_list *the_list, unsigned char data );

extern void boolean_list_insert2( boolean_list_list *the_list, boolean_list._alist_index at_index, unsigned char data );

extern void boolean_list_pull( boolean_list_list *the_list, unsigned char *data );

extern void boolean_list_discard( boolean_list_list *the_list );

extern void boolean_list_cut( boolean_list_list *the_list, boolean_list._alist_index at_index, unsigned char *data );

extern void boolean_list_clear_item( boolean_list_list *the_list, boolean_list._alist_index at_index );

extern void boolean_list_replace( boolean_list_list *the_list, boolean_list._alist_index at_index, unsigned char data );

extern void boolean_list_find( boolean_list_list *the_list, boolean_list._alist_index at_index, unsigned char *data );

extern void boolean_list_lookup( boolean_list_list *the_list, unsigned char data, boolean_list._alist_index start, boolean_list._alist_index *found_at );

extern boolean_list._alist_index boolean_list_length( boolean_list_list the_list );

extern unsigned char boolean_list_is_empty( boolean_list_list the_list );

extern void boolean_list_sub_list( boolean_list_list *the_list, boolean_list._alist_index index, [type] len, boolean_list_list *result );

extern void boolean_list_concat( boolean_list_list list1, [type] list2, boolean_list_list *result );


}
