
// C++ header file partially generated from Ada using cproto.adb

#ifndef COMMON_H
#define COMMON_H

extern "C" {

//----------------------------------------------------------------------------
// COMMON                                                                   --
//                                                                          --
// Part of TextTools                                                        --
// Designed and Programmed by Ken O. Burtch                                 --
//                                                                          --
//----------------------------------------------------------------------------
//                                                                          --
//                 Copyright (C) 1999-2002 Ken O. Burtch                    --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------
// remind Ada to elaborate generics first
// overrides our "strings" package

// Gnat Run-Time System Startup

extern void adainit( void );
extern void adafinal( void );

// C language support


typedef char c_string[256]; // range 0..255
// C-style string for C language support

//- Compile Flags
//
// Differentiate between compiling the finder (ie. the server that first
// runs and establishes the environment and contains routines to answer
// all questions) from the normal applications running under it (ie. the
// clients which must negotiate with the finder for control of the screen.

// extern char is_finder = 1;
// true if compiling for a server

//-> Time types

typedef long long a_time_stamp;

//-> Standard Math functions
//
// There are standard Ada packages for some of these, but they're all
// built-in so who cares?

typedef int a_percent; // range 1..100
extern float CSin( float angle );
extern float CCos( float angle );
extern int Crnd( int limit );
extern int Cnormalrnd( int limit );
extern int COdds( a_percent percent );
extern void Csetrndseed( int seed );

//-> Basic Rectangles
//
// Rectangles are used all over.

typedef unsigned int points;

typedef struct _a_rect {
  int left, top, right, bottom;
} a_rect;

const a_rect null_rect = {0,0,-1,-1};

extern void set_rect( a_rect *r, int left, int top, int right, int bottom );

// extern void offset_rect( a_rect *r, int dx, int dy );
extern a_rect offset_rect( const a_rect *r, int dx, int dy );

// extern void inset_rect( a_rect *r, int dx, int dy );
extern a_rect inset_rect( const a_rect *r, int dx, int dy );

extern int inside_rect( const a_rect *inner, const a_rect *outer );

extern int in_rect( int x, int y, const a_rect *r );

extern unsigned char is_empty_rect( const a_rect *r );


//-> Bounded Strings
//
// 80 character limit

//package Strings80  is new Ada.Strings.Bounded.Generic_Bounded_Length
//                          ( Max =>  80 );
//subtype Str80 is Strings80.Bounded_String;
//NullStr80 : str80 renames Strings80.Null_Bounded_String;
//
//function To80( Source : in String;
//               Drop   : in Strings.Truncation := Strings.Error)
//               return Str80 renames Strings80.To_Bounded_String;
//function ToString( source : in str80 ) return String
//               renames Strings80.To_String;

//-> 255 character limit

typedef struct _str255 {
   long length;
   char chars[256];
} str255;

// skipping renaming of variable
extern str255 null_str255;

// renamed function omitted: 
// extern str255 to255( char * source, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern char * to_string( str255 source );

// Renamings here
//
// 1. Renaming these functions makes them automatically present with common.
// 2. Gnat 2.0 has some of these incomplete, so I'll provide my own
//    definitions

// renamed function omitted: 
// extern strings255._length_range length( str255 source );
// this one doesn't work in gnat 2.0
// extern str255 append( str255 left, [type] right, strings._truncation drop = strings._error );
// return Str255 renames Strings255.Append;
// renamed function omitted: 
// extern str255 append( str255 left, char * right, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 append( char * left, str255 right, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 append( str255 left, char right, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 append( char left, str255 right, strings._truncation drop = strings._error );
// this one doesn't work in gnat 2.0
// extern void append( str255 *source, str255 new_item, strings._truncation drop = strings._error );
//renames Strings255.Append;
// renamed procedure omitted: 
// extern void append( str255 *source, char * new_item, strings._truncation drop = strings._error );
// renamed procedure omitted: 
// extern void append( str255 *source, char new_item, strings._truncation drop = strings._error );
// this one doesn't work in gnat 2.0
// extern str255 "&"( str255 left, [type] right );
// renames Strings255."&";
// Adding this one because it's natural!
// renamed function omitted: 
// extern str255 "&"( str255 left, char * right );
// this one doesn't work in gnat 2.0
// extern str255 "&"( char * left, str255 right );
// renames Strings255."&";
// renamed function omitted: 
// extern str255 "&"( str255 left, char right );
// renamed function omitted: 
// extern str255 "&"( char left, str255 right );
// renamed function omitted: 
// extern char element( str255 source, unsigned int index );
// renamed procedure omitted: 
// extern void replace_element( str255 *source, unsigned int index, char by );
// renamed function omitted: 
// extern char * slice( str255 source, unsigned int low, unsigned int high );
// renamed function omitted: 
// extern int "="( str255 left, [type] right );
// renamed function omitted: 
// extern int "="( str255 left, char * right );
// renamed function omitted: 
// extern int "="( char * left, str255 right );
// renamed function omitted: 
// extern int "<"( str255 left, [type] right );
// renamed function omitted: 
// extern int "<"( str255 left, char * right );
// renamed function omitted: 
// extern int "<"( char * left, str255 right );
// renamed function omitted: 
// extern int "<="( str255 left, [type] right );
// renamed function omitted: 
// extern int "<="( str255 left, char * right );
// renamed function omitted: 
// extern int "<="( char * left, str255 right );
// renamed function omitted: 
// extern int ">"( str255 left, [type] right );
// renamed function omitted: 
// extern int ">"( str255 left, char * right );
// renamed function omitted: 
// extern int ">"( char * left, str255 right );
// renamed function omitted: 
// extern int ">="( str255 left, [type] right );
// renamed function omitted: 
// extern int ">="( str255 left, char * right );
// renamed function omitted: 
// extern int ">="( char * left, str255 right );
// renamed function omitted: 
// extern unsigned int index( str255 source, char * pattern, strings._direction going = strings._forward, maps._character_mapping mapping = maps._identity );
// renamed function omitted: 
// extern unsigned int index( str255 source, char * pattern, strings._direction going = strings._forward, maps._character_mapping_function mapping );
// renamed function omitted: 
// extern unsigned int index( str255 source, maps._character_set set, strings._membership test = strings._inside, strings._direction going = strings._forward );
// renamed function omitted: 
// extern unsigned int index_non_blank( str255 source, strings._direction going = strings._forward );
// renamed function omitted: 
// extern unsigned int count( str255 source, char * pattern, maps._character_mapping mapping = maps._identity );
// renamed function omitted: 
// extern unsigned int count( str255 source, char * pattern, maps._character_mapping_function mapping );
// renamed function omitted: 
// extern unsigned int count( str255 source, maps._character_set set );
// renamed procedure omitted: 
// extern void find_token( str255 source, maps._character_set set, strings._membership test, unsigned int *first, unsigned int *last );
// renamed function omitted: 
// extern str255 translate( str255 source, maps._character_mapping mapping );
// renamed procedure omitted: 
// extern void translate( str255 *source, maps._character_mapping mapping );
// renamed function omitted: 
// extern str255 translate( str255 source, maps._character_mapping_function mapping );
// renamed procedure omitted: 
// extern void translate( str255 *source, maps._character_mapping_function mapping );
// renamed function omitted: 
// extern str255 replace_slice( str255 source, unsigned int low, unsigned int high, char * by, strings._truncation drop = strings._error );
// renamed procedure omitted: 
// extern void replace_slice( str255 *source, unsigned int low, unsigned int high, char * by, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 insert( str255 source, unsigned int before, char * new_item, strings._truncation drop = strings._error );
// renamed procedure omitted: 
// extern void insert( str255 *source, unsigned int before, char * new_item, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 overwrite( str255 source, unsigned int position, char * new_item, strings._truncation drop = strings._error );
// renamed procedure omitted: 
// extern void overwrite( str255 *source, unsigned int position, char * new_item, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 delete( str255 source, unsigned int from, unsigned int through );
// renamed procedure omitted: 
// extern void delete( str255 *source, unsigned int from, unsigned int through );
// renamed function omitted: 
// extern str255 trim( str255 source, strings._trim_end side );
// renamed procedure omitted: 
// extern void trim( str255 *source, strings._trim_end side );
// renamed function omitted: 
// extern str255 trim( str255 source, maps._character_set left, maps._character_set right );
// renamed procedure omitted: 
// extern void trim( str255 *source, maps._character_set left, maps._character_set right );
// This can also error with core dump
// my version ignores Drop
// extern str255 head( str255 source, unsigned int count, char pad = strings._space, strings._truncation drop = strings._error );
//renames Strings255.Head;
// renamed procedure omitted: 
// extern void head( str255 *source, unsigned int count, char pad = strings._space, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 tail( str255 source, unsigned int count, char pad = strings._space, strings._truncation drop = strings._error );
// renamed procedure omitted: 
// extern void tail( str255 *source, unsigned int count, char pad = strings._space, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 "*"( unsigned int left, char right );
// renamed function omitted: 
// extern str255 "*"( unsigned int left, char * right );
// renamed function omitted: 
// extern str255 "*"( unsigned int left, str255 right );
// renamed function omitted: 
// extern str255 replicate( unsigned int count, char item, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 replicate( unsigned int count, char * item, strings._truncation drop = strings._error );
// renamed function omitted: 
// extern str255 replicate( unsigned int count, str255 item, strings._truncation drop = strings._error );

//function To255( s : in str80 ) return str255;
//function To80( s : in str255 ) return str80;
// extern int to_integer( str255 s );
// extern int to_integer( char * s );
// extern long to_long_integer( str255 s );
// extern long to_long_integer( char * s );

// Lists of Bounded Strings


//-> Lists of Booleans


//-> Lists of Rectangles

extern int rect_order( a_rect left, a_rect right );

//-> Various Pointer Types
//
// These are listed for convenience.

typedef int *boolean_ptr;
typedef int *integer_ptr;
typedef short *short_integer_ptr;
typedef long *long_integer_ptr;
//type Str80Ptr         is access all Str80;
typedef str255 *str255_ptr;
typedef float *float_ptr;
typedef a_rect *rect_ptr;

//-> Error Handling
//-
//- To get the best of all worlds, I'm providing the following vars/
//- procs.  If RaiseErrors is used, all calls to Error will result
//- in a GeneralError being raised (the error code is in LastError).
//- If TrapErrors (default) is used, all calls to Error will save the
//- error code in LastError and return and it's up to the program to
//- check to see if an error occurred.  If you need to save the error
//- handling method of the caller, save the value of RaisingErrors. 
//- (I was going to create a stack, but that's slower and more work.
//- This is better when memory is low, and often the flag doesn't need
//- saving.)  If your subprogram uses these routines, call NoError first
//- to clear any outstanding error codes.
//-
//- Core Error Codes
//-
//- Listed here for convenience and to ensure they are unique
//-
//- Core System Errors

typedef short an_error_code; // range -1..short_integer'last
typedef an_error_code a_core_error_code; // range -1..499
typedef an_error_code an_user_error_code; // range 500.._an_error_code'last

const a_core_error_code TT_not_yet_written = -1; // routine not yet written
const a_core_error_code TT_ok = 0;               // no error
const a_core_error_code TT_memory_leak = 10;     // memory not deallocated
const a_core_error_code TT_low_memory = 11;      // low on memory


//- Core System and related

const a_core_error_code TT_system_error = 100;   // command failed
const a_core_error_code TT_param_error = 101;    // param too long
const a_core_error_code TT_file_existance = 110; // file found/not found
const a_core_error_code TT_path_existance = 111; // path found/not found
const a_core_error_code TT_vol_existance = 112;  // volume found/not found
const a_core_error_code TT_dev_existance = 113;  // device found/not found
const a_core_error_code TT_file_status = 114;    // open / not open
const a_core_error_code TT_file_locking = 115;   // file is locked/unlocked
const a_core_error_code TT_file_access = 116;    // file is un/accessible
const a_core_error_code TT_vol_locking = 117;    // volume readonly or not
const a_core_error_code TT_vol_access = 118;     // volume is un/accessible
const a_core_error_code TT_vol_full = 119;       // no space on disk
const a_core_error_code TT_dev_sequential = 120; // tape device
const a_core_error_code TT_ioerror = 121;        // hardware or media error
const a_core_error_code TT_path_error = 122;     // bad path for file sys
const a_core_error_code TT_file_bounds = 123;    // position out of bounds

const a_core_error_code TT_osold = 130;          // UNIX too old
const a_core_error_code TT_osservice = 131;      // UNIX service missing

const a_core_error_code TT_integrity = 140;      // integrity test failure
const a_core_error_code TT_test_data = 141;      // test data in operation


//-> Interpreter Errors
// (not used)

const a_core_error_code TT_unexp_err = 200;      // unexpected character
const a_core_error_code TT_paran_err = 201;      // Bad paranthesis
const a_core_error_code TT_operand_err = 202;    // missing operand
const a_core_error_code TT_syntax_err = 203;     // bad syntax
const a_core_error_code TT_too_comp_err = 204;   // formula too complex
const a_core_error_code TT_clash_err = 205;      // type clash
const a_core_error_code TT_not_decl_err = 206;   // ident not declared
const a_core_error_code TT_eoprog_err = 207;     // end of prog encountered
const a_core_error_code TT_quote_err = 208;      // bad quote marks
const a_core_error_code TT_div_zero_err = 209;   // divide by zero

//-> Core Userio Errors

//-> Core Control Errors

//-> Core Window Errors

const a_core_error_code TT_window_existance = 160;  // window found/not
const a_core_error_code TT_no_controls = 161;       // no controls in window
const a_core_error_code TT_control_existance = 162;
const a_core_error_code TT_no_dialog_task_cb = 163; //no manual handler


//-> Error Variables/Functions

// exception general_error;
// exception raised by Error();
an_error_code last_error;
// last Error error code
//LastErrorDetails : Str255List.List; -- details of last error (if any)
int raising_errors;
// TRUE if GeneralError will be raised

extern void no_error( void );
// clear LastError
extern void error( an_error_code error_code );
// log an error
// extern void raise_errors( void );
// cause Error to raise a GeneralError
// extern void trap_errors( void );
// cause Error to return normally
// extern int raise_errors( void );
// extern int trap_errors( void );
// extern void restore_raising( int oldflag );

//- Housekeeping
//
// These are set by StartupCommon.

extern str255 program_name = null_str255;
extern str255 short_program_name = null_str255;

// Short program name is used for $SYS directory in os package.
// and (when I get to it) temp file name prefix.

// extern void startup_common( char * the_program_name, char * the_short_program_name );

extern void startup_common( c_string the_program_name, c_string the_short_program_name );

extern void idle_common( a_time_stamp idle_period );

extern void shutdown_common( void );


// Str255 Bounded String: C++ wrapper functions

typedef struct _str255list_list {
  void *first;
  void *last;
  long count;
  void *freecache;
  long lastrec;
  void *lastptr;
} str255list_list;

str255list_list str255list_null = { 0, 0, 0, 0, 0, 0 };

typedef long str255list_a_list_index;

extern void str255list_init( str255list_list *the_list );

extern void str255list_get_allocation( str255list_a_list_index *allocation );

extern unsigned char str255list_memory_leak( str255list_a_list_index allocation );

extern void str255list_compact( str255list_list *the_list );

extern void str255list_clear( str255list_list *the_list );

extern void str255list_copy( str255list_list *from_list, str255list_list *to_list );

extern void str255list_copy2( str255list_list *from_list, str255list_list *to_list1, str255list_list *to_list2 );

extern void str255list_move( str255list_list *from_list, str255list_list *to_list );

extern void str255list_swap( str255list_list *list1, str255list_list *list2 );

extern void str255list_push( str255list_list *the_list, str255 new_data );

extern void str255list_queue( str255list_list *the_list, str255 data );

extern void str255list_insert( str255list_list *the_list, str255 data );

extern void str255list_insert2( str255list_list *the_list, str255list_a_list_index at_index, str255 data );

extern void str255list_pull( str255list_list *the_list, str255 *data );

extern void str255list_discard( str255list_list *the_list );

extern void str255list_cut( str255list_list *the_list, str255list_a_list_index at_index, str255 *data );

extern void str255list_clear_item( str255list_list *the_list, str255list_a_list_index at_index );

extern void str255list_replace( str255list_list *the_list, str255list_a_list_index at_index, str255 data );

extern void str255list_find( str255list_list *the_list, str255list_a_list_index at_index, str255 *data );

extern void str255list_lookup( str255list_list *the_list, str255 *data, str255list_a_list_index start, str255list_a_list_index *found_at );

extern str255list_a_list_index str255list_length( str255list_list *the_list );

extern unsigned char str255list_is_empty( str255list_list *the_list );

extern void str255list_sublist( str255list_list *the_list, str255list_a_list_index index, str255list_a_list_index len, str255list_list *result );

extern void str255list_concat( str255list_list *list1, str255list_list *list2, str255list_list *result );


// Boolean List: C++ wrapper functions

typedef struct _booleanlist_list {
  void *first;
  void *last;
  long count;
  void *freecache;
  long lastrec;
  void *lastptr;
} booleanlist_list;

booleanlist_list booleanlist_null = { 0, 0, 0, 0, 0, 0 };

typedef long booleanlist_a_list_index;

extern void booleanlist_get_allocation( booleanlist_a_list_index *allocation );

extern unsigned char booleanlist_memory_leak( booleanlist_a_list_index allocation );

extern void booleanlist_compact( booleanlist_list *the_list );

extern void booleanlist_clear( booleanlist_list *the_list );

extern void booleanlist_copy( booleanlist_list *from_list, booleanlist_list *to_list );

extern void booleanlist_copy2( booleanlist_list *from_list, booleanlist_list *to_list1, booleanlist_list *to_list2 );

extern void booleanlist_move( booleanlist_list *from_list, booleanlist_list *to_list );

extern void booleanlist_swap( booleanlist_list *list1, booleanlist_list *list2 );

extern void booleanlist_push( booleanlist_list *the_list, unsigned char new_data );

extern void booleanlist_queue( booleanlist_list *the_list, unsigned char data );

extern void booleanlist_insert( booleanlist_list *the_list, unsigned char data );

extern void booleanlist_insert2( booleanlist_list *the_list, booleanlist_a_list_index at_index, unsigned char data );

extern void booleanlist_pull( booleanlist_list *the_list, unsigned char *data );

extern void booleanlist_discard( booleanlist_list *the_list );

extern void booleanlist_cut( booleanlist_list *the_list, booleanlist_a_list_index at_index, unsigned char *data );

extern void booleanlist_clear_item( booleanlist_list *the_list, booleanlist_a_list_index at_index );

extern void booleanlist_replace( booleanlist_list *the_list, booleanlist_a_list_index at_index, unsigned char data );

extern void booleanlist_find( booleanlist_list *the_list, booleanlist_a_list_index at_index, unsigned char *data );

extern void booleanlist_lookup( booleanlist_list *the_list, unsigned char data, booleanlist_a_list_index start, booleanlist_a_list_index *found_at );

extern booleanlist_a_list_index booleanlist_length( booleanlist_list *the_list );

extern unsigned char booleanlist_is_empty( booleanlist_list *the_list );

extern void booleanlist_sublist( booleanlist_list *the_list, booleanlist_a_list_index index, booleanlist_a_list_index len, booleanlist_list *result );

extern void boolean_list_concat( booleanlist_list list1, booleanlist_list *list2, booleanlist_list *result );


}

#endif

