#include "TeSpatialStatistics.h"
#include "TeLayer.h"
#include "TeGeneralizedProxMatrix.h"
#include "TeSTEvent.h"
#include "TeSTElementSet.h"
#include "TeStatistics.h"
#include "TeProgress.h"


bool 
TeLocalMean (TeSTEventSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{
	
	TeSTEventSet::iterator itObjs = elemSet->begin();
	double numberNeighbors;

	while (itObjs != elemSet->end())
	{
		double sum = 0.;
		double localMean = 0.;

		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();
		numberNeighbors = neighbors.size();
		
		while(itNeigs != neighbors.end())
		{
			//retrieve the neighbor attribute value
			double val;
			if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
				return false;
						
			// find the weight associated with the neighbor (attribute of index 0)
			double weight = (*itNeigs).second.Weight();

			sum +=  weight * val;  
			++itNeigs;
		}

		localMean = sum;
		
		TeAttributeRep rep;
		rep.name_ = "LocalMean";
		rep.type_ = TeREAL;
		(*itObjs).addProperty(localMean, rep, false);
		
		rep.name_  = "NumNeighbors";
		rep.type_ = TeINT;
		(*itObjs).addProperty((double)numberNeighbors, rep, false);
		
		++itObjs;
	}

	return true;
}

double
TeMoranIndex2 (TeSTEventSet* elemSet, const double& mean, const double& var, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{
	double moran = 0;
	TeSTEventSet::iterator itObjs = elemSet->begin();
	int numberObjs = elemSet->numSTInstance();

	while ( itObjs != elemSet->end())
	{
		double normObjVal = (*itObjs)[indexAttr] - mean;
		double li = 0.;
		double weightSum = 0.;

		
		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();

		while(itNeigs != neighbors.end())
		{
			//retrieve the neighbor attribute value
			double val;
			if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
				return 0.;
									
			 // normalize the property
			double normNeighVal =  val - mean;

			// find the weight associated with the neighbor (attribute of index 0)
			double weight = (*itNeigs).second.Weight();
			li +=  weight * ( normNeighVal )  * ( normObjVal );  // se dividir pela varincia  o ndice local de moran
			weightSum += weight;
			++itNeigs;
		}

		if (weightSum != 0.)
			li /= weightSum;
		

		moran += li;

		++itObjs;
	}

	if ( numberObjs > 1 )
		return moran /  ( var * ( numberObjs - 1 ) );
	else 
		return moran / var;
}

double
TeMoranIndex (TeSTEventSet* elemSet, int indexZ, int indexWZ)
{
	double variance = 0.;
	double sum = 0;
	int number = 0;

	variance = TeSecondMoment (elemSet->begin(), elemSet->end(), 0, indexZ);  
	TeSTEventSet::iterator it = elemSet->begin();
	
	while (it != elemSet->end())
	{
		double z = (*it)[indexZ];
		double wz = (*it)[indexWZ];
		double ZxWZ;
		if(variance==0)
			ZxWZ = 0.;
		else
			ZxWZ = (z*wz)/variance; 

		//keep 
		TeAttributeRep rep;
		rep.name_ = "MoranIndex"; 
		rep.type_ = TeREAL;
		(*it).addProperty(ZxWZ, rep, false); 
		
		sum += ZxWZ;
		number++; 
		++it; 
	}
	
	return sum /= number;
}

double
TeGlobalMoranSignificance (TeSTEventSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr,
						   unsigned int permutationsNumber, double moranIndex)
{
	
	vector<double> permutationsResults(permutationsNumber);
	double significance;
	
	unsigned int objectsNumber = elemSet->numSTInstance();
	
	//progress bar
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(permutationsNumber);
		
	vector<double> deviations(objectsNumber);
	vector<double>::iterator itDev = deviations.begin();
	TeSTEventSet::iterator itObjs = elemSet->begin();
	while(itObjs != elemSet->end())
	{
		(*itDev) = (*itObjs)[indexAttr]; //attribute value
		++itObjs;
		++itDev;
	}

	TeStatisticValMap stat;
	if(!TeCalculateStatistics(elemSet->begin(), elemSet->end(), stat, 0))
		return 0.;

	double mean = stat[TeMEAN];
	double var = stat[TeVARIANCE];
	
	srand(time(0));
	unsigned int i;
	for (i = 0; i < permutationsNumber; i++)
	{
		TeSTEventSet changedObjects;

		itObjs = elemSet->begin();

		// chande values 
		while(itObjs != elemSet->end())
		{
			TeSTEvent stoChange; 
			stoChange.objectId((*itObjs).objectId());
			
			double ranaux = rand();
			int randon = (int) ((ranaux * (objectsNumber-1))/RAND_MAX );
			double value = deviations[randon];
						
			stoChange.addProperty(value);
			
			changedObjects.insertSTInstance (stoChange);
			++itObjs;
		}
		
		permutationsResults[i] = TeMoranIndex2 (&changedObjects, mean, var, proxMatrix, 0);

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return 0.;
			}
			else
				TeProgress::instance()->setProgress(i);
		}
	}

	// verify the significance
	int position = 0;
	significance = 0;
	unsigned int k;
	for (k = 0; k < permutationsNumber; k++)
	{
		if (moranIndex < permutationsResults[k]) //>
			position++;
	}
	if ( moranIndex >= 0)
		significance = (double) (position+1) / (permutationsNumber+1);
	else
		significance = (double) (permutationsNumber-position)/(permutationsNumber+1);
		
	
	if (TeProgress::instance())
		TeProgress::instance()->reset();
		
	return significance;
}


void
TeMoranMap (TeSTEventSet* elemSet, int indexLISAMap, int indexBoxMap)
{
	TeSTEventSet::iterator it = elemSet->begin();
	while ( it != elemSet->end())
	{
		double result = 0.0;
		int lisaMap = (int)((*it)[indexLISAMap]);

		if (lisaMap != 0)
			result = (*it)[indexBoxMap];
				
		//keep
		TeAttributeRep rep;
		rep.name_ = "MoranMap"; 
		rep.type_ = TeREAL;
		(*it).addProperty(result, rep, false); 

		++it;
	}
}

bool 
TeGStatistics (TeSTEventSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{

	TeSTEventSet::iterator itObjs = elemSet->begin();
	double totalSum = 0.;
	double excludSum = 0.;

	totalSum = TeSum(itObjs, elemSet->end(), indexAttr);
	
	itObjs = elemSet->begin();

	//progress bar
	int step = 0;
	int numSteps = elemSet->numSTInstance();
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(numSteps);

	while ( itObjs != elemSet->end() )
	{
		double valObj = (*itObjs)[indexAttr];
		excludSum = totalSum - valObj;
		
		double G = 0;
		double GStar = valObj;
	
		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();
		int neigNumber = neighbors.size();

		if(itNeigs != neighbors.end())
		{
			while(itNeigs != neighbors.end())
			{
				// retrieve the property value associated to this neighbor 
				double val;
				if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
					return false;

				G +=  val;
				GStar +=  val;
				
				++itNeigs;
			}

			G /= neigNumber;
			GStar /= (neigNumber+1);
				
			G /= excludSum; 
			GStar /= totalSum;
		}
	
		//insert the indexes in the sET
		TeAttributeRep rep;
		rep.name_ = "G"; 
		rep.type_ = TeREAL;
		(*itObjs).addProperty(G, rep, false); 

		rep.name_ = "GStar";
		(*itObjs).addProperty(GStar, rep, false); 

		++itObjs;

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return false;
			}
			else
				TeProgress::instance()->setProgress(step);
		}	
		++step;
	}
	

	if (TeProgress::instance())
		TeProgress::instance()->reset();
	return true;
}

void
TeBoxMap (TeSTEventSet* elemSet, int indexZ, int indexWZ, double mean)
{
	
	TeSTEventSet::iterator it_begin = elemSet->begin(); 
	while ( it_begin != elemSet->end())
	{
		int result=0;

		if ( ((*it_begin)[indexZ] >= mean) &&  ((*it_begin)[indexWZ] >= mean))   
			result = 1;
		else if ( ((*it_begin)[indexZ] < mean)  &&  ((*it_begin)[indexWZ] >= mean))	
			result = 4;	
		else if ( ((*it_begin)[indexZ] < mean)  &&  ((*it_begin)[indexWZ] < mean))
			result = 2;		
		else if ( ((*it_begin)[indexZ] >= mean) &&  ((*it_begin)[indexWZ] < mean))
			result = 3;

		//keep
		TeAttributeRep rep;
		rep.name_ = "BoxMap"; 
		rep.type_ = TeINT;
		(*it_begin).addProperty((double)result, rep, false); 

		++it_begin;
	}	
}

bool TeLisaStatisticalSignificance ( TeSTEventSet* elemSet, int indexZ, int indexLISA, 
									 int indexNeighNum, int permutationsNumber) 
 {
	double sum;
	double WZperm;
	double significance;

	TeSTEventSet::iterator it = elemSet->begin();

	double variance = TeSecondMoment (it, elemSet->end(), 0, indexZ);

	int index = 0;
	it = elemSet->begin();
	int objectsNumber = elemSet->numSTInstance();

	//progress bar
	int step = 0;
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(objectsNumber);

	vector<double> deviations(objectsNumber);
	vector<double>::iterator it_dev = deviations.begin();
	while(it != elemSet->end())
	{
		(*it_dev) = (*it)[indexZ];
		++it;
		++it_dev;
	}
	
	srand(time(0));
	it = elemSet->begin();
	

	while ( it != elemSet->end())
	{
		int neighborsNumber = (int)((*it)[indexNeighNum]);

		vector<double> permut(permutationsNumber);
		for (int j = 0; j < permutationsNumber; j++)
		{
			int randon = 0;
			sum = 0;
			set<int> setNeigh;
			for (int k = 0; k < neighborsNumber; k++)
			{
				double ranaux = rand();
				randon = (int)((ranaux * (objectsNumber-1))/RAND_MAX);
				if (index == randon || (setNeigh.find(randon) != setNeigh.end()) )
					k--;	// raffle annulled	
				else
				{		
					setNeigh.insert(randon);
					sum += deviations[randon];
				}
			}

			if(neighborsNumber==0)
				WZperm = 0.;
			else
				WZperm = sum/neighborsNumber;

			if(variance==0)
				permut[j] = 0.;
			else
				permut[j] = deviations[index] * WZperm / variance;
		}	

		int position = 0;
		for (int k = 0; k < permutationsNumber; k++)
		{
			if (((*it)[indexLISA]) > permut[k])
				position++;
		}
 		if ( ((*it)[indexLISA]) >= 0)
			significance = (double) (permutationsNumber-position)/(permutationsNumber+1);
		else
			significance = (double) position/( permutationsNumber + 1 );
			
		//keep
		TeAttributeRep rep;
		rep.name_ = "LISASig"; 
		rep.type_ = TeREAL;
		(*it).addProperty(significance, rep, false); 

		++it;
		++index;

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return false;
			}
			else
				TeProgress::instance()->setProgress(step);
		}	
		++step;
	}

	if (TeProgress::instance())
		TeProgress::instance()->reset();

	return true;
}


void
TeLisaMap (TeSTEventSet* elemSet, int indexSignifLISA, int /* permutationNumber */)
{
	TeSTEventSet::iterator begin = elemSet->begin();
	while (begin != elemSet->end())
	{
		int significanceClass = 0;
		if ( ( (*begin)[indexSignifLISA] <= 0.001 ))  /*&& (permutationNumber >= 999)*/ 
			significanceClass = 3;
		else if ( ((*begin)[indexSignifLISA] <= 0.01) && ((*begin)[indexSignifLISA] > 0.001 )) /*&& (permutationNumber >= 99)*/ 
			significanceClass = 2;
		else if ( ((*begin)[indexSignifLISA] <= 0.05) && ((*begin)[indexSignifLISA] > 0.01))
			significanceClass = 1;

		//keep
		TeAttributeRep rep;
		rep.name_ = "LISAMap"; 
		rep.type_ = TeINT;
		(*begin).addProperty((double)significanceClass, rep, false); 

		++begin;
	}
}

//-------------------- using TeSTElementSet
//-------------------- not templated because Visual C++ 6.0

bool 
TeLocalMean (TeSTElementSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{
	
	TeSTElementSet::iterator itObjs = elemSet->begin();
	double numberNeighbors;

	while (itObjs != elemSet->end())
	{
		double sum = 0.;
		double localMean = 0.;

		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();
		numberNeighbors = neighbors.size();
		
		while(itNeigs != neighbors.end())
		{
			//retrieve the neighbor attribute value
			double val;
			if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
				return false;
						
			// find the weight associated with the neighbor (attribute of index 0)
			double weight = (*itNeigs).second.Weight();

			sum +=  weight * val;  
			++itNeigs;
		}

		localMean = sum;
		
		TeAttributeRep rep;
		rep.name_ = "LocalMean";
		rep.type_ = TeREAL;
		(*itObjs).addProperty(localMean, rep, false);
		
		rep.name_  = "NumNeighbors";
		rep.type_ = TeINT;
		(*itObjs).addProperty((double)numberNeighbors, rep, false);
		
		++itObjs;
	}

	return true;
}

double
TeMoranIndex2 (TeSTElementSet* elemSet, const double& mean, const double& var, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{
	double moran = 0;
	TeSTElementSet::iterator itObjs = elemSet->begin();
	int numberObjs = elemSet->numSTInstance();

	while ( itObjs != elemSet->end())
	{
		double normObjVal = (*itObjs)[indexAttr] - mean;
		double li = 0.;
		double weightSum = 0.;

		
		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();

		while(itNeigs != neighbors.end())
		{
			//retrieve the neighbor attribute value
			double val;
			if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
				return 0.;
									
			 // normalize the property
			double normNeighVal =  val - mean;

			// find the weight associated with the neighbor (attribute of index 0)
			double weight = (*itNeigs).second.Weight();
			li +=  weight * ( normNeighVal )  * ( normObjVal );  // se dividir pela varincia  o ndice local de moran
			weightSum += weight;
			++itNeigs;
		}

		if (weightSum != 0.)
			li /= weightSum;
		

		moran += li;

		++itObjs;
	}

	if ( numberObjs > 1 )
		return moran /  ( var * ( numberObjs - 1 ) );
	else 
		return moran / var;
}

double
TeMoranIndex (TeSTElementSet* elemSet, int indexZ, int indexWZ)
{
	double variance = 0.;
	double sum = 0;
	int number = 0;

	variance = TeSecondMoment (elemSet->begin(), elemSet->end(), 0, indexZ);  
	TeSTElementSet::iterator it = elemSet->begin();
	
	while (it != elemSet->end())
	{
		double z = (*it)[indexZ];
		double wz = (*it)[indexWZ];
		double ZxWZ;
		if(variance==0)
			ZxWZ = 0.;
		else
			ZxWZ = (z*wz)/variance; 

		//keep 
		TeAttributeRep rep;
		rep.name_ = "MoranIndex"; 
		rep.type_ = TeREAL;
		(*it).addProperty(ZxWZ, rep, false); 
		
		sum += ZxWZ;
		number++; 
		++it; 
	}
	
	return sum /= number;
}

double
TeGlobalMoranSignificance (TeSTElementSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr,
						   unsigned int permutationsNumber, double moranIndex)
{
	
	vector<double> permutationsResults(permutationsNumber);
	double significance;
	
	unsigned int objectsNumber = elemSet->numSTInstance();
	
	//progress bar
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(permutationsNumber);
		
	vector<double> deviations(objectsNumber);
	vector<double>::iterator itDev = deviations.begin();
	TeSTElementSet::iterator itObjs = elemSet->begin();
	while(itObjs != elemSet->end())
	{
		(*itDev) = (*itObjs)[indexAttr]; //attribute value
		++itObjs;
		++itDev;
	}

	TeStatisticValMap stat;
	if(!TeCalculateStatistics(elemSet->begin(), elemSet->end(), stat, 0))
		return 0.;

	double mean = stat[TeMEAN];
	double var = stat[TeVARIANCE];

	srand(time(0));	
	unsigned int i;
	for (i = 0; i < permutationsNumber; i++)
	{
		TeSTElementSet changedObjects;

		itObjs = elemSet->begin();

		// chande values 
		while(itObjs != elemSet->end())
		{
			TeSTInstance stoChange; 
			stoChange.objectId((*itObjs).objectId());

			double ranaux = rand();
			int randon = (int) ((ranaux * (objectsNumber-1))/RAND_MAX);
			double value = deviations[randon];
						
			stoChange.addProperty(value);
			
			changedObjects.insertSTInstance (stoChange);
			++itObjs;
		}
		
		permutationsResults[i] = TeMoranIndex2 (&changedObjects, mean, var, proxMatrix, 0);

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return 0.;
			}
			else
				TeProgress::instance()->setProgress(i);
		}
	}

	// verify the significance
	int position = 0;
	significance = 0;
	unsigned int k;
	for (k = 0; k < permutationsNumber; k++)
	{
		if (moranIndex < permutationsResults[k]) //>
			position++;
	}
	if ( moranIndex >= 0)
		significance = (double) (position+1) / (permutationsNumber+1);
	else
		significance = (double) (permutationsNumber-position)/(permutationsNumber+1);
		
	
	if (TeProgress::instance())
		TeProgress::instance()->reset();
		
	return significance;
}


void
TeMoranMap (TeSTElementSet* elemSet, int indexLISAMap, int indexBoxMap)
{
	TeSTElementSet::iterator it = elemSet->begin();
	while ( it != elemSet->end())
	{
		double result = 0.0;
		int lisaMap = (int)((*it)[indexLISAMap]);

		if (lisaMap != 0)
			result = (*it)[indexBoxMap];
				
		//keep
		TeAttributeRep rep;
		rep.name_ = "MoranMap"; 
		rep.type_ = TeREAL;
		(*it).addProperty(result, rep, false); 

		++it;
	}
}

bool 
TeGStatistics (TeSTElementSet* elemSet, TeGeneralizedProxMatrix* proxMatrix, int indexAttr)
{

	TeSTElementSet::iterator itObjs = elemSet->begin();
	double totalSum = 0.;
	double excludSum = 0.;

	totalSum = TeSum(itObjs, elemSet->end(), indexAttr);
	
	itObjs = elemSet->begin();

	//progress bar
	int step = 0;
	int numSteps = elemSet->numSTInstance();
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(numSteps);

	while ( itObjs != elemSet->end() )
	{
		double valObj = (*itObjs)[indexAttr];
		excludSum = totalSum - valObj;
		
		double G = 0;
		double GStar = valObj;
	
		TeNeighboursMap neighbors = proxMatrix->getMapNeighbours((*itObjs).objectId());
		TeNeighboursMap::iterator itNeigs = neighbors.begin();
		int neigNumber = neighbors.size();

		if(itNeigs != neighbors.end())
		{
			while(itNeigs != neighbors.end())
			{
				// retrieve the property value associated to this neighbor 
				double val;
				if(!elemSet->getAttributeValue ((*itNeigs).first, indexAttr, val))
					return false;

				G +=  val;
				GStar +=  val;
				
				++itNeigs;
			}

			G /= neigNumber;
			GStar /= (neigNumber+1);
				
			G /= excludSum; 
			GStar /= totalSum;
		}
	
		//insert the indexes in the sET
		TeAttributeRep rep;
		rep.name_ = "G"; 
		rep.type_ = TeREAL;
		(*itObjs).addProperty(G, rep, false); 

		rep.name_ = "GStar";
		(*itObjs).addProperty(GStar, rep, false); 

		++itObjs;

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return false;
			}
			else
				TeProgress::instance()->setProgress(step);
		}	
		++step;
	}
	

	if (TeProgress::instance())
		TeProgress::instance()->reset();
	return true;
}

void
TeBoxMap (TeSTElementSet* elemSet, int indexZ, int indexWZ, double mean)
{
	
	TeSTElementSet::iterator it_begin = elemSet->begin(); 
	while ( it_begin != elemSet->end())
	{
		int result=0;

		if ( ((*it_begin)[indexZ] >= mean) &&  ((*it_begin)[indexWZ] >= mean))   
			result = 1;
		else if ( ((*it_begin)[indexZ] < mean)  &&  ((*it_begin)[indexWZ] >= mean))	
			result = 4;	
		else if ( ((*it_begin)[indexZ] < mean)  &&  ((*it_begin)[indexWZ] < mean))
			result = 2;		
		else if ( ((*it_begin)[indexZ] >= mean) &&  ((*it_begin)[indexWZ] < mean))
			result = 3;

		//keep
		TeAttributeRep rep;
		rep.name_ = "BoxMap"; 
		rep.type_ = TeINT;
		(*it_begin).addProperty((double)result, rep, false); 

		++it_begin;
	}	
}

bool TeLisaStatisticalSignificance ( TeSTElementSet* elemSet, int indexZ, int indexLISA, 
									 int indexNeighNum, int permutationsNumber) 
 {
	double sum;
	double WZperm;
	double significance;

	TeSTElementSet::iterator it = elemSet->begin();

	double variance = TeSecondMoment (it, elemSet->end(), 0, indexZ);

	int index = 0;
	it = elemSet->begin();
	int objectsNumber = elemSet->numSTInstance();

	//progress bar
	int step = 0;
	if(TeProgress::instance())
		TeProgress::instance()->setTotalSteps(objectsNumber);

	vector<double> deviations(objectsNumber);
	vector<double>::iterator it_dev = deviations.begin();
	while(it != elemSet->end())
	{
		(*it_dev) = (*it)[indexZ];
		++it;
		++it_dev;
	}

	it = elemSet->begin();
	srand(time(0));
	while ( it != elemSet->end())
	{
		int neighborsNumber = (int)((*it)[indexNeighNum]);

		vector<double> permut(permutationsNumber);
		
		for (int j = 0; j < permutationsNumber; j++)
		{
			int randon = 0;
			sum = 0;
			set<int> setNeigh;
			for (int k = 0; k < neighborsNumber; k++)
			{
				double ranaux = rand();
				randon = (int)((ranaux * (objectsNumber-1))/RAND_MAX);
				if (index == randon || (setNeigh.find(randon) != setNeigh.end()) )
					k--;	// raffle annulled	
				else
				{		
					setNeigh.insert(randon);
					sum += deviations[randon];
				}
			}

			if(neighborsNumber==0)
				WZperm = 0.;
			else
				WZperm = sum/neighborsNumber;

			if(variance==0)
				permut[j] = 0.;
			else
				permut[j] = deviations[index] * WZperm / variance;
		}	

		int position = 0;
		for (int k = 0; k < permutationsNumber; k++)
		{
			if (((*it)[indexLISA]) > permut[k])
				position++;
		}
 		if ( ((*it)[indexLISA]) >= 0)
			significance = (double) (permutationsNumber-position)/(permutationsNumber+1);
		else
			significance = (double) position/( permutationsNumber + 1 );
			
		//keep
		TeAttributeRep rep;
		rep.name_ = "LISASig"; 
		rep.type_ = TeREAL;
		(*it).addProperty(significance, rep, false); 

		++it;
		++index;

		if(TeProgress::instance())
		{
			if (TeProgress::instance()->wasCancelled())
			{
				TeProgress::instance()->reset();
				return false;
			}
			else
				TeProgress::instance()->setProgress(step);
		}	
		++step;
	}

	if (TeProgress::instance())
		TeProgress::instance()->reset();

	return true;
}


void
TeLisaMap (TeSTElementSet* elemSet, int indexSignifLISA, int /* permutationNumber */)
{
	TeSTElementSet::iterator begin = elemSet->begin();
	while (begin != elemSet->end())
	{
		int significanceClass = 0;
		if ( ( (*begin)[indexSignifLISA] <= 0.001 ))  /*&& (permutationNumber >= 999)*/ 
			significanceClass = 3;
		else if ( ((*begin)[indexSignifLISA] <= 0.01) && ((*begin)[indexSignifLISA] > 0.001 )) /*&& (permutationNumber >= 99)*/ 
			significanceClass = 2;
		else if ( ((*begin)[indexSignifLISA] <= 0.05) && ((*begin)[indexSignifLISA] > 0.01))
			significanceClass = 1;

		//keep
		TeAttributeRep rep;
		rep.name_ = "LISAMap"; 
		rep.type_ = TeINT;
		(*begin).addProperty((double)significanceClass, rep, false); 

		++begin;
	}
}









