/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#include "TeProxMatrixImplementation.h"

#include <stdio.h>

TeProxMatrixGraphBreymann:: TeProxMatrixGraphBreymann (TeProxMatrixGraphBreymann&  other) : TeProxMatrixImplementation(), graph_(false)
{
	type_ = other.type_;
//	graph_ = other.graph_;
	map_ = other.map_;
}

	

TeProxMatrixGraphBreymann&
TeProxMatrixGraphBreymann:: operator= (TeProxMatrixGraphBreymann& other)
{
	type_ = other.type_;
//	graph_ = other.graph_;  
	map_ = other.map_;
	return (*this);
}
 

void 
TeProxMatrixGraphBreymann::connectObjects (const string& object_id1, const string& object_id2, const TeProxMatrixAttributes& attr)
{
	int pos1 = graph_.insert (object_id1);
	int pos2 = graph_.insert (object_id2);

	graph_.connectVertices (pos1, pos2, attr);

	map_[object_id1] = pos1;
	map_[object_id2] = pos2;
}


bool 
TeProxMatrixGraphBreymann::setConnectionAttributes (const string& object_id1, const string& object_id2, const TeProxMatrixAttributes& attr)
{
	return(graph_.setEdgeValue (object_id1, object_id2, attr));
}

bool 
TeProxMatrixGraphBreymann::getConnectionAttributes (const string& object_id1, const string&object_id2, TeProxMatrixAttributes& attr)
{
	map_iterator pos1, pos2;

	if ((pos1 = map_.find(object_id1)) == map_.end()) 
		return false; // object_id1 not in the graph

	if ((pos2 = map_.find(object_id2)) == map_.end()) 
		return false; // object_id2 not in the graph

	// Object_id1 neighbours iterator
	br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
			start	= graph_[(*pos1).second].second.begin(),
			end		= graph_[(*pos1).second].second.end();

	while (start != end) 
	{	
		if ((*start).first == (*pos2).second) {
				attr = (*start).second;
				return true;
		}
		++start;
	}
	return false;		
}

bool 
TeProxMatrixGraphBreymann::getNeighboursNeighbours (const string& object_id, TeNeighbours& neigh, int max_order )
{
	bool ret_value = getNeighboursNeighbours (object_id, neigh, max_order, 1);
	neigh.Remove (object_id);
	return ret_value;
}

bool 
TeProxMatrixGraphBreymann::getNeighboursNeighbours (const string& object_id, TeNeighbours& neigh, int max_order, int current_order)
{

	map_iterator pos;

	if ((pos = map_.find(object_id)) == map_.end()) 
		return false; // object_id not in the graph

	// Object_id1 neighbours iterator
	br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
			start	= graph_[(*pos).second].second.begin(),
			end		= graph_[(*pos).second].second.end();

	// Insert all neighbours
	while (start != end) 
	{	
		TeProxMatrixAttributes attr = (*start).second;
		attr.Order (current_order); //Update attr attribute for that specific object
		if (neigh.Insert (graph_[(*start).first].first, attr)) 
		{
				// Get neighbours of neighbours that were not inserted before
			for (int recursive_loop = max_order - 1; recursive_loop > 0; --recursive_loop)
				getNeighboursNeighbours (graph_[(*start).first].first, neigh, recursive_loop, ++current_order);
	
		}
		++start;
	}
	return true;

}


bool
TeProxMatrixGraphBreymann::getNeighbours (const string& object_id, TeNeighbours& neigh)
{
	map_iterator pos;

	if ((pos = map_.find(object_id)) == map_.end()) 
		return false; // object_id not in the graph

	br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
			start	= graph_[(*pos).second].second.begin(),
			end		= graph_[(*pos).second].second.end();

	while (start != end) 
	{
		neigh.Insert (graph_[(*start).first].first, (*start).second);
		++start;
	}

	return true;
	
}

bool
TeProxMatrixGraphBreymann::getNeighbours (int i, string& object_id, TeNeighbours& neigh)
{

	if (i > (int) graph_.size())
		return false;

	// find object_id
	map_iterator pos = map_.begin();
	while (pos != map_.end())
	{
		if ((*pos).second == i)
		{
			object_id = (*pos).first;
			pos = map_.end();
		}
		else pos++;
	}

	br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
			start	= graph_[i].second.begin(),
			end		= graph_[i].second.end();


	while (start != end) 
	{
		neigh.Insert (graph_[(*start).first].first, (*start).second);
		start++;
	}

	return true;
	
}



TeProxMatrixImplementation* 
TeProxMatrixGraphBreymann:: CreateCopy ()
{
	TeProxMatrixGraphBreymann* imp = new TeProxMatrixGraphBreymann (*this);
	return imp;

}

void
TeProxMatrixGraphBreymann:: List ()
{

	cout << "objetos proximos " << endl;
	for (unsigned int j = 0; j < graph_.size(); j++)
		cout << "objeto " << j << " id " << graph_[j].first << endl;


	for (unsigned int i = 0; i < graph_.size(); i++)
	{
		if ((graph_[i].first == "13") || (graph_[i].first == "20") || 
			(graph_[i].first == "36") ) /*|| (graph_[i].first == "C09L12") || 
				(graph_[i].first == "C10L15") || (graph_[i].first == "C27L14") || 
					(graph_[i].first == "C15L05"))*/

		{
			cout << "object: " << i << " id: " << graph_[i].first << endl;
			cout << "vizinhos: " << endl;

			br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
				start	= graph_[i].second.begin(),
				end		= graph_[i].second.end();

			while (start != end) 
			{
//				cout << "    " << graph_[(*start).first].first  << endl;
				cout << "    " << graph_[(*start).first].first << " w " << (*start).second.Weight() << " d1 " << (*start).second.CentroidDistance()  << " d2 " << (*start).second.NetworkObjectsDistance()  << " d3 " << (*start).second.NetworkMinimumPath() << endl;
				start++;
			}
			cout << endl;
		}
	}

}


bool
TeProxMatrixGraphBreymann:: SaveTextFile (string& name)
{
	string complete_name = name + ".txt";

	FILE*	fp = fopen(complete_name.c_str(),"w");
	if (fp)
	{
		fprintf (fp, "Objetos conectados: %d\n", graph_.size() );
	//	for (int j = 0; j < graph_.size(); j++)
	//		fprintf (fp, "  %s%\n", graph_[j].first.c_str());
		

		for (unsigned int i = 0; i < graph_.size(); i++)
		{

			fprintf (fp, "%d --------------- object_id:  %s\n", i, graph_[i].first.c_str());
			fprintf (fp,"  vizinhos:\n");

			br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
				start	= graph_[i].second.begin(),
				end		= graph_[i].second.end();
			double sum = 0.0;
			while (start != end) 
			{
				fprintf (fp, "%s S %d  W: %3.7f  D1:  %3.7f   D2: %3.7f   D3: %3.7f \n", graph_[(*start).first].first.c_str(), (*start).second.Slice(), (*start).second.Weight(),(*start).second.CentroidDistance() , (*start).second.NetworkObjectsDistance(),(*start).second.NetworkMinimumPath() );
				sum += (*start).second.Weight();
				start++;
			}

			fprintf (fp, "Weights sum: %3.7f\n", sum);
			fprintf (fp, "end --------------- object_id:  %s\n\n", graph_[i].first.c_str());

	
		}
		fclose (fp);
		return true;
	}
	else return false;
	
	/*
	FILE*	fp = fopen(name.c_str(),"w");
	if (fp)
	{
		for (int i = 0; i < graph_.size(); i++)
		{


    		cout << "***********************" << graph_[i].first << endl;
			br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
				start	= graph_[i].second.begin(),
				end		= graph_[i].second.end();
			double sum = 0.0;
			while (start != end) 
			{
				cout << graph_[(*start).first].first << endl;
				fprintf (fp, "%3.7f ",  (*start).second.CentroidDistance());
				sum += (*start).second.Weight();
				start++;
			}

			fprintf (fp, "\n");
	
		}
		fclose (fp);
		return true;
	}
	else return false;
	*/
}


bool
TeProxMatrixGraphBreymann:: SaveGALFile (string& name)
{

	string complete_name = name + ".gal";
	FILE*	fp = fopen(complete_name.c_str(),"w");
	if (fp)
	{
		fprintf (fp, "%d\n", graph_.size() ); // first line: number of elements in matrix
		for (unsigned int i = 0; i < graph_.size(); i++)
		{

			fprintf (fp, "%s %d\n", graph_[i].first.c_str(), graph_[i].second.size());
			br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
				start	= graph_[i].second.begin(),
				end		= graph_[i].second.end();
			while (start != end) 
			{
				fprintf (fp, "%s   %3.7f\n", graph_[(*start).first].first.c_str(), (*start).second.Weight() );
				start++;
			}
			fprintf (fp, "\n");
		}
		fclose (fp);
		return true;
	}
	else return false;
	
}


bool
TeProxMatrixGraphBreymann:: SaveGWTFile (string& name)
{

	string complete_name = name + ".gwt";
	FILE*	fp = fopen(complete_name.c_str(),"w");
	if (fp)
	{
		fprintf (fp, "%d\n", graph_.size() ); // first line: number of elements in matrix
		for (unsigned int i = 0; i < graph_.size(); i++)
		{
			br_stl::Graph<string, TeProxMatrixAttributes>::Successor::iterator 
				start	= graph_[i].second.begin(),
				end		= graph_[i].second.end();
			while (start != end) 
			{
				fprintf (fp, "%s %s\n", graph_[i].first.c_str(), graph_[(*start).first].first.c_str());
				start++;
			}
		}
		fclose (fp);
		return true;
	}
	else return false;
	
}
