/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/*! \file TeGeoProcessingFunctions.h
    This file contains functions to generate new layers from 
	spatial operations among themes 
*/

#ifndef __TERRALIB_INTERNAL_GEOPROCESSING_H
#define __TERRALIB_INTERNAL_GEOPROCESSING_H

#include "TeDatabase.h" 

class TeAsciiFile;

bool TeGeoOpAggregation(TeLayer* newLayer, TeTheme* theme, vector<string> agregAttrVec, TeGroupingAttr& attrMM, TeSelectedObjects selOb, TeAsciiFile* logFile=0);		

bool TeGeoOpAdd(TeLayer* newLayer, TeTheme* theme, TeThemeVector themeVec, TeSelectedObjects selObj = TeAll, TeAsciiFile* logFile=0);

bool TeGeoOpOverlayIntersection(TeLayer* newLayer, TeTheme* theme, TeTheme* themeTrim, TeSelectedObjects selOb, TeSelectedObjects selObTrim, bool attrTrim, TeAsciiFile* logFile=0);

bool TeGeoOpOverlayUnion(TeLayer* newLayer, TeTheme* theme, TeTheme* themeOverlay, TeSelectedObjects selOb, TeSelectedObjects selObOverlay, TeAsciiFile* logFile=0);

bool TeGeoOpAssignDataLocationDistribute(TeTheme* themeMod, TeTheme* theme, const string& tableName, const int& spatialRelation);

bool TeGeoOpAssignByLocationCollect(TeTheme* restrTheme, TeTheme* srcTheme, const string& newTableName, TeGroupingAttr& measuresColl, const int& spatialRelation);

bool TeGeoOpOverlayDifference(TeLayer* newLayer, TeTheme* theme1, TeTheme* theme2, TeSelectedObjects selOb1, TeSelectedObjects selOb2, TeAsciiFile* logFile=0);

#endif

