/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QTCANVAS_H
#define  __TERRALIB_INTERNAL_QTCANVAS_H

#include "TeQtBasicCanvas.h"
#include "TeThemeApplication.h"
//#include <qscrollview.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

/**
  *@author R Cartaxo
  */

//class TeQtCanvas : public QScrollView ,public TeQtBasicCanvas {
class TeQtCanvas : public TeQtBasicCanvas {
   Q_OBJECT
public:
    enum CursorMode { Pointer, Area, Pan, Hand, SizeVer, SizeBDiag, UpArrow, Edit, Distance, Information, ZoomIn, ZoomOut };

// Initialization
	TeQtCanvas(QWidget *parent=0, const char *name=0);
	~TeQtCanvas();

	void setMode (CursorMode);
	void initCursorArea (QPoint p);
	TeBox getCursorBox (){ return TeBox (xul_,ylr_,xlr_,yul_); }

	void copyPixmapToWindow();

	void setView(int w = 0, int h = 0, QPaintDevice *pd = 0);
	void clear();
	void clear(TeBox box);
	void clearAll();
	void clearAll(TeBox box);
	CursorMode getCursorMode() { return cursorMode_;}
//	void drawTextTT (int x, int y, string &str, double angle = 0.);
	double mapVtoData (int);
	int mapDatatoV (double);
	TeBox  getPieBarBox(TeThemeApplication* theme);
	QPopupMenu* popupCanvas() { return popupCanvas_; }
// scrollbar offset
	QPoint offset () {return QPoint(contentsX(), contentsY());}

signals:
	void mousePressed (TeCoord2D&, int, QPoint&);
	void mouseDoublePressed (TeCoord2D&, int, QPoint&);
	void mouseRightButtonPressed (TeCoord2D&, int, QPoint&);
	void mouseMoved (TeCoord2D&, int, QPoint&);
	void mouseReleased (TeCoord2D&, int, QPoint&);
	void mouseLeave ();
	void paintEvent ();
	void windowClear();
	void popupCanvasSignal(QMouseEvent*);
	void keyPressed(QKeyEvent*);
	void keyReleased(QKeyEvent*);

protected:

// Mouse events
	void contentsMousePressEvent( QMouseEvent* );
	void contentsMouseMoveEvent ( QMouseEvent* );
	void contentsMouseReleaseEvent ( QMouseEvent* );
	void contentsMouseDoubleClickEvent ( QMouseEvent* );
	void contentsContextMenuEvent( QContextMenuEvent* );

// leave Event
	void leaveEvent ( QEvent * );

// Key events
	void keyPressEvent ( QKeyEvent*);
	void keyReleaseEvent ( QKeyEvent*);

// Area Cursor section
	CursorMode cursorMode_;
	bool		down_;
	double 		xul_, // cursor world coordinates
				xlr_,
				yul_,
				ylr_;
	int 		ixul_, // cursor screen coordinates
				ixlr_,
				iyul_,
				iylr_;

// Other events
	void viewportPaintEvent (QPaintEvent* e);
	void resizeEvent ( QResizeEvent * );

// Mapping correction when scrollbars have been used
	void correctScrolling (QPoint &p);

// Menu de popup
	QPopupMenu *popupCanvas_;

};

#endif
