/*
 * Tag expressions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#if __GNUC__ < 3
#define _GNU_SOURCE
#endif

#include "Tagexpr.h"

using namespace std;
using namespace Tagcoll;

bool TagexprContext::eval(const string& tag) const throw ()
{
	std::map<std::string, Tagexpr*>::const_iterator i = derivedTags.find(tag);
	if (i == derivedTags.end())
		return tags.contains(tag);
	else if (!seen.contains(tag))
	{
		seen += tag;
		bool res = i->second->eval(*this);
		seen -= tag;
		return res;
	}
	else
		// If we got here, we have a circular dependency between derived tags
		// FIXME: find a better way to handle it: throw an exception, maybe?
		return false;
}

bool TagexprTag::eval(const OpSet<std::string>& tags) const throw ()
{
	if (_tag[0] == '*')
	{
		string match = _tag.substr(1);
		for (OpSet<string>::const_iterator i = tags.begin();
				i != tags.end(); i++)
			if (i->substr(i->size() - match.size()) == match)
				return true;
		return false;
	}
	else if (_tag[_tag.size() - 1] == '*')
	{
		string match = _tag.substr(0, _tag.size() - 1);
		for (OpSet<string>::const_iterator i = tags.begin();
				i != tags.end(); i++)
			if (i->substr(0, match.size()) == match)
				return true;
		return false;
	}
	else
		return tags.find(_tag) != tags.end();
}


// vim:set ts=4 sw=4:
