#ifndef TAGCOLL_UNFACETED_REMOVER_H
#define TAGCOLL_UNFACETED_REMOVER_H

/*
 * System tag database
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollFilter.h>

namespace Tagcoll
{

// TagcollFilter that removes that which are not faceted
template<class ITEM>
class UnfacetedRemover : public TagcollFilter<ITEM, std::string>
{
public:
	virtual void consume(const ITEM& item) throw ();
	virtual void consume(const ITEM& item, const OpSet<std::string>& tags) throw ();
	virtual void consume(const OpSet<ITEM>& items) throw ();
	virtual void consume(const OpSet<ITEM>& items, const OpSet<std::string>& tags) throw ();
};

};

// vim:set ts=4 sw=4:
#endif
