#ifndef TAGCOLL_TAGCOLLSERIALIZER_H
#define TAGCOLL_TAGCOLLSERIALIZER_H

/*
 * Serialize a tagged collection to a text file
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>

#include <stdio.h>

namespace Tagcoll
{

// TagcollConsumer that serializes its input to an output stream
class TagcollSerializer : public TagcollConsumer<std::string>
{
protected:
	FILE* out;

	void printTagset(const OpSet<std::string>& ts) throw ();
	
public:
	TagcollSerializer(FILE* out) throw () : out(out) {}

	virtual void consume(const std::string& item) throw ();
	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ();
	virtual void consume(const OpSet<std::string>& items) throw ();
	virtual void consume(const OpSet<std::string>& items, const OpSet<std::string>& tags) throw ();
};

};

// vim:set ts=4 sw=4:
#endif
