#ifndef TAGCOLL_TAGCOLLCONSUMER_H
#define TAGCOLL_TAGCOLLCONSUMER_H

/*
 * Consumer interface for a stream of tagged items
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/OpSet.h>

#include <string>

namespace Tagcoll
{

// Interface for classes interested in being fed the results of the tagged
// collection file parser
template<class ITEM = std::string, class TAG = std::string>
class TagcollConsumer
{
public:
	// Process an untagged item
	virtual void consume(const ITEM& item) throw () = 0;

	// Process a tagged item, with its tags
	virtual void consume(const ITEM& item, const OpSet<TAG>& tags) throw () = 0;

	// Process a set of items, all with no tags
	virtual void consume(const OpSet<ITEM>& items) throw ()
	{
		// Default implementation for consumer that have no special handling of
		// item groups
		for (typename OpSet<ITEM>::const_iterator i = items.begin();
				i != items.end(); i++)
			consume(*i);
	}

	// Process a set of items identically tagged, with their tags
	virtual void consume(const OpSet<ITEM>& items, const OpSet<TAG>& tags) throw ()
	{
		// Default implementation for consumer that have no special handling of
		// item groups
		for (typename OpSet<ITEM>::const_iterator i = items.begin();
				i != items.end(); i++)
			consume(*i, tags);
	}
};

};

// vim:set ts=4 sw=4:
#endif
