#ifndef TAGCOLL_PATCHES_H
#define TAGCOLL_PATCHES_H

/*
 * Classes handling tag patches
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/TagcollFilter.h>
#include <tagcoll/InputMerger.h>

#include <map>
#include <string>

namespace Tagcoll
{

// List of explicit implications that can be used to expand a tagged collection
// while it's being parsed
template <class ITEM>
class PatchList : public TagcollConsumer<ITEM, std::string>
{
protected:
	typedef std::map< ITEM, OpSet<std::string> > patch_t;
	patch_t patches;

	void addAllEquals(const ITEM& item, char prefix, const OpSet<std::string>& tags) throw ();

public:
	virtual ~PatchList() throw () {}

	void generate(const InputMerger<ITEM, std::string>& im1, const InputMerger<ITEM, std::string>& im2) throw ();

	virtual void consume(const ITEM& item) throw () {}
	virtual void consume(const ITEM& item, const OpSet<std::string>& tags) throw ();
	
	// Patch a tagged item: return the new set of tags
	OpSet<std::string> patch(const ITEM& item, const OpSet<std::string>& tagset) const throw ();

	// Output the patch list to a TagcollConsumer
	void output(TagcollConsumer<ITEM, std::string>& consumer) const throw ();
};

template <class ITEM>
class ApplyPatches : public TagcollFilter<ITEM, std::string>
{
protected:
	PatchList<ITEM>& patches;
	
public:
	ApplyPatches(PatchList<ITEM>& patches) throw ()
		: patches(patches) {}

	virtual void consume(const ITEM& item) throw ();
	virtual void consume(const ITEM& item, const OpSet<std::string>& tags) throw ();
};

};

// vim:set ts=4 sw=4:
#endif
