#ifndef TAGCOLL_BASIC_TAG_FILTER_H
#define TAGCOLL_BASIC_TAG_FILTER_H

#pragma interface

#include <tagcoll/TagConsumer.h>
#include <string>

namespace Tagcoll
{

class Tag;
class Facet;

class BasicFacetMatcher : public FacetMatcher
{
protected:
	std::string name;
	std::string str;

public:
	BasicFacetMatcher() throw () {}
	virtual ~BasicFacetMatcher() throw () {}

	void setName(const std::string _name) throw () { name = _name; }
	void setString(const std::string _str) throw () { str = _str; }

	bool hasName() const throw () { return !name.empty(); }
	bool hasString() const throw () { return !str.empty(); }

	bool matchName(const std::string& text) const throw ();
	bool matchString(const std::string& text) const throw ();

	bool match(const Facet& facet) const throw ();
};

class BasicTagMatcher : public TagMatcher
{
protected:
	std::string name;
	std::string str;

public:
	BasicTagMatcher() throw () {}
	virtual ~BasicTagMatcher() throw () {}

	void setName(const std::string _name) throw () { name = _name; }
	void setString(const std::string _str) throw () { str = _str; }

	bool hasName() const throw () { return !name.empty(); }
	bool hasString() const throw () { return !str.empty(); }

	bool matchName(const std::string& text) const throw ();
	bool matchString(const std::string& text) const throw ();

	virtual bool match(const Tag& tag) const throw ();
};

};

// vim:set ts=3 sw=3:
#endif
