/* tape_accessors.c: accessor functions for libspectrum_tape_block
   Copyright (c) 2003 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* NB: this file is autogenerated from ../tape_accessors.txt by ../tape_accessors.pl */

#include <config.h>

#include "internals.h"
#include "tape_block.h"

libspectrum_dword
libspectrum_tape_block_bit_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.bit_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_bit0_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bit0_length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bit0_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_bit1_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bit1_length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bit1_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_bits_in_last_byte( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.bits_in_last_byte;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.bits_in_last_byte;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.bits_in_last_byte;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_bits_per_data_symbol( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return block->types.generalised_data.bits_per_data_symbol;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_count( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: return block->types.pure_tone.pulses;
    case LIBSPECTRUM_TAPE_BLOCK_PULSES: return block->types.pulses.count;
    case LIBSPECTRUM_TAPE_BLOCK_LOOP_START: return block->types.loop_start.count;
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.count;
    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.count;
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.count;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_byte*
libspectrum_tape_block_data( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.data;
    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return block->types.generalised_data.data;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.data;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.data;
    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: return block->types.rle_pulse.data;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.data;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.data;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return NULL;
  }
}

size_t
libspectrum_tape_block_data_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.length;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.length;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.length;
    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: return block->types.rle_pulse.length;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.length;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_tape_generalised_data_symbol_table*
libspectrum_tape_block_data_table( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return &block->types.generalised_data.data_table;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return NULL;
  }
}

int
libspectrum_tape_block_ids( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.ids[ index ];
    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.ids[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

int
libspectrum_tape_block_offset( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_JUMP: return block->types.jump.offset;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return 0;
  }
}

int
libspectrum_tape_block_offsets( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.offsets[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return 0;
  }
}

libspectrum_dword
libspectrum_tape_block_pause( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return block->types.generalised_data.pause;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: return block->types.message.time;
    case LIBSPECTRUM_TAPE_BLOCK_PAUSE: return block->types.pause.length;
    case LIBSPECTRUM_TAPE_BLOCK_PURE_DATA: return block->types.pure_data.pause;
    case LIBSPECTRUM_TAPE_BLOCK_RAW_DATA: return block->types.raw_data.pause;
    case LIBSPECTRUM_TAPE_BLOCK_ROM: return block->types.rom.pause;
    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pause;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_pilot_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pilot_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

size_t
libspectrum_tape_block_pilot_pulses( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.pilot_pulses;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_word
libspectrum_tape_block_pilot_repeats( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return block->types.generalised_data.pilot_repeats[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_byte
libspectrum_tape_block_pilot_symbols( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return block->types.generalised_data.pilot_symbols[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_tape_generalised_data_symbol_table*
libspectrum_tape_block_pilot_table( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GENERALISED_DATA: return &block->types.generalised_data.pilot_table;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return NULL;
  }
}

libspectrum_dword
libspectrum_tape_block_pulse_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PURE_TONE: return block->types.pure_tone.length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_scale( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_RLE_PULSE: return block->types.rle_pulse.scale;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_pulse_lengths( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_PULSES: return block->types.pulses.lengths[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_sync1_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.sync1_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

libspectrum_dword
libspectrum_tape_block_sync2_length( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_TURBO: return block->types.turbo.sync2_length;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

char*
libspectrum_tape_block_text( libspectrum_tape_block *block )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_GROUP_START: return block->types.group_start.name;
    case LIBSPECTRUM_TAPE_BLOCK_COMMENT: return block->types.comment.text;
    case LIBSPECTRUM_TAPE_BLOCK_MESSAGE: return block->types.message.text;
    case LIBSPECTRUM_TAPE_BLOCK_CUSTOM: return block->types.custom.description;

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return NULL;
  }
}

char*
libspectrum_tape_block_texts( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_ARCHIVE_INFO: return block->types.archive_info.strings[ index ];
    case LIBSPECTRUM_TAPE_BLOCK_SELECT: return block->types.select.descriptions[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return NULL;
  }
}

int
libspectrum_tape_block_types( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.types[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

int
libspectrum_tape_block_values( libspectrum_tape_block *block, size_t index )
{
  switch( block->type ) {

    case LIBSPECTRUM_TAPE_BLOCK_HARDWARE: return block->types.hardware.values[ index ];

    default:
      libspectrum_print_error(
        LIBSPECTRUM_ERROR_INVALID,
        "invalid block type 0x%02x given to %s", block->type, __func__
      );
      return -1;
  }
}

