/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: linkedlist.c,v 1.4 2001/09/29 14:18:50 michael Exp $ */

#include <stdio.h>
#include "linkedlist.h"

linked_list_t *
linked_list_alloc ()
{
  linked_list_t *linkedlist =
    (linked_list_t *) malloc (sizeof (linked_list_t));

  if (!linkedlist) return NULL;

  linkedlist->data = NULL;
  linkedlist->prev = NULL;
  linkedlist->next = NULL;

  return linkedlist;
}

linked_list_t *
linked_list_free (linked_list_t ** linkedlist)
{
  linked_list_t *first, *next;

  if (!(linkedlist) || !(*linkedlist)) return NULL;
  
  first = linked_list_first (*linkedlist);

  while (first != NULL) {
    next = first->next;
    free (first);
    first = next;
  }

  *linkedlist = NULL;
  return NULL;
}

linked_list_t *
linked_list_next (linked_list_t ** linkedlist)
{
  if (((linkedlist != NULL) && (*linkedlist != NULL)) && 
      ((*linkedlist)->next != NULL))
    *linkedlist = (*linkedlist)->next;
  else
    return NULL;

  return *linkedlist;
}

linked_list_t *
linked_list_prev (linked_list_t ** linkedlist)
{
  if (((linkedlist != NULL) || (*linkedlist != NULL)) && 
      ((*linkedlist)->prev != NULL))
    *linkedlist = (*linkedlist)->prev;
  else
    return NULL;

  return *linkedlist;
}

linked_list_t *
linked_list_first (linked_list_t *linkedlist)
{
  linked_list_t *first = NULL;

  while (linkedlist != NULL) {
      first = linkedlist;
      linkedlist = linkedlist->prev;
  }

  return first;
}

linked_list_t *
linked_list_last (linked_list_t * linkedlist)
{
  linked_list_t *last = NULL;

  while (linkedlist != NULL) {
      last = linkedlist;
      linkedlist = linkedlist->next;
  }

  return last;
}

linked_list_t *
linked_list_add (linked_list_t * linkedlist, void *data, int len)
{
  linked_list_t *new;

  if (linkedlist == NULL || data == NULL || len <= 0 )
    return NULL;
  
  if (linkedlist->data != NULL) {
    if ((new = linked_list_alloc ()) == NULL)
	    return NULL;
  } else {
    new = linkedlist;
  }

  if ((new->data = (void *) malloc (len)) == NULL)
    return NULL;
  memcpy (new->data, data, len);
  
  if (linkedlist != new) {
      new->next = linkedlist->next;
      new->prev = linkedlist;

      if (linkedlist->next)
        linkedlist->next->prev = new;

      linkedlist->next = new;
  }

  return new; // XXX
}

linked_list_t *
linked_list_del (linked_list_t ** linkedlist)
{
  linked_list_t *tmp = NULL;
        
  if (linkedlist == NULL || *linkedlist == NULL)
    return NULL;

  if ((*linkedlist)->next)
    (*linkedlist)->next->prev = (*linkedlist)->prev;
  if ((*linkedlist)->prev)
    (*linkedlist)->prev->next = (*linkedlist)->next;

  tmp = *linkedlist;
  
  if ((*linkedlist)->prev) 
    *linkedlist = (*linkedlist)->prev;
   else 
    *linkedlist = (*linkedlist)->next;

  if (tmp) free (tmp); // XXX

  return *linkedlist;
}

linked_list_t *
linked_list_push (linked_list_t * linkedlist, void *data, int len)
{
  linkedlist = linked_list_last (linkedlist);

  return linked_list_add (linkedlist, data, len);
}

void *
linked_list_pop (linked_list_t ** linkedlist)
{
  void *data = NULL;

  if (!linkedlist) return NULL;
  
  if (*linkedlist = linked_list_last (*linkedlist))
    data = (*linkedlist)->data;

  linked_list_del (linkedlist);

  return data;
}

linked_list_t *
linked_list_fpush (linked_list_t * linkedlist, void *data, int len)
{
  linkedlist = linked_list_first (linkedlist);

  return linked_list_add (linkedlist, data, len);
}

void *
linked_list_fpop (linked_list_t ** linkedlist)
{
  void *data = NULL;

  if (!linkedlist) return NULL;

  if (*linkedlist = linked_list_first (*linkedlist))
    data = (*linkedlist)->data;

  linked_list_del (linkedlist);

  return data;
}

int
linked_list_len (linked_list_t * linkedlist)
{
  int count = 0;

  linkedlist = linked_list_first (linkedlist);

  if (!linkedlist)
    return 0;
  
  do {
    if (linkedlist->data)
      count++;
  } while ( linked_list_next (&linkedlist) );

  return count;
}
