// data_node.h
// License: Public Domain
// Author: stephan@s11n.net


// EVERYTHING IN THIS FILE IS EXPERIMENTAL.
// EVERYTHING IN THIS FILE IS EXPERIMENTAL.
// EVERYTHING IN THIS FILE IS EXPERIMENTAL.
// EVERYTHING IN THIS FILE IS EXPERIMENTAL.
// EVERYTHING IN THIS FILE IS EXPERIMENTAL.
// EVERYTHING IN THIS FILE IS EXPERIMENTAL.

#ifndef S11N_NS_DATA_NODE_H_INCLUDED
#define S11N_NS_DATA_NODE_H_INCLUDED

#include <string>
#include <map>

#define CHILDREN_USE_LIST 0
#if CHILDREN_USE_LIST
#  include <list>
#else
#  include <vector>
#endif // CHILDREN_USE_LIST

#include <cassert>
#include <typeinfo>

// #include <functional> // equal_to
// #include <algorithm> // for_each() and friends


#include <S11N_NS/to_string.h> // to/from_string()
#include <S11N_NS/functor.h> // some helpful functors

namespace S11N_NS {

// //         template <typename P, typename L> struct basic_data_node;
//         template <
//                 typename PropMapType = std::map<std::string,std::string>,
//                 typename ChildListType = std::list< basic_data_node<PropMapType,ChildListType> *>
//         >
//         class basic_data_node
//         {
//         public:

//                 /**
//                    The map type this object uses to store items
//                    internally.
//                  */
// 		typedef PropMapType map_type;

//                 /**
//                    The pair type used to store key/value properties
//                    internally.
//                 */
// 		typedef typename map_type::value_type property_type;

//                 /** For compatibility with std::map */
//                 typedef typename map_type::key_type key_type;

//                 /** For compatibility with std::map */
//                 typedef typename map_type::mapped_type mapped_type; 

//                 typedef typename map_type::iterator iterator; 
//                 typedef typename map_type::const_iterator const_iterator; 

//                 typedef basic_data_node<map_type> this_type;

//                 typedef this_type child_type;

//                 typedef ChildListType child_list_type;

//                 basic_data_node() : m_name("s11nnode") {}
//                 basic_data_node( const std::string & name ) : m_name(name) {}
//                 ~basic_data_node() { this->clear(); }

//                 data_node( const data_node & rhs )
//                 {
//                 	this->copy( rhs );
//                 }
//                 data_node & operator=( const data_node & rhs )
//                 {
// 	                if( &rhs == this ) return *this;
//                         this->copy( rhs );
//                         return *this;
//                 }

//                 child_list_type & children()
//                 {
//                 	return this->m_children;
//                 }

//                 const child_list_type & children() const
//                 {
//                 	return this->m_children;
//                 }

//                 /**
//                    Removes all properties and deletes all child objects.
//                 */
//                 void clear()
//                 {
// 	                this->m_map.clear();
//                         free_list_entries( this->children().begin() );
//                         this->children().clear();
//                 }
//                 /** Copies rhs's properties and deep-copies rhs's child pointers. */
//                 void copy( const data_node & rhs )
//                 {
// 			if ( &rhs == this ) return;
//                         this->clear();
//                         this->name( rhs.name() );
//                         this->impl_class( rhs.impl_class() );
//                         std::copy( rhs.begin(), rhs.end(),
//                                    std::insert_iterator<map_type>( this->m_map, this->m_map.begin() )
//                                    );
//                         std::for_each( rhs.children().begin(),
//                                        rhs.children().end(),
//                                        child_pointer_deep_copier<child_list_type>( this->children() )
//                                        );
//                 }

// 		void impl_class( const std::string & n )
//                 {
//                         this->m_implclass = n;
//                 }
//                 std::string impl_class() const
//                 {
//                         return this->m_implclass;
//                 }

// 		void name( const std::string & n )
//                 {
// 	                this->m_name = n;
//                 }

// 		std::string name() const
//                 {
// 	                return this->m_name;
//                 }


                
//                 void insert( iterator propit )
//                 {
//                         this->m_map.insert( propit );
//                 }
//                 void insert( child_type * child )
//                 {
//                         if( ! child ) return;
//                         this->children().push_back( child );
//                 }
//                 void insert( child_list_type::iterator childit )
//                 {
//                         if( ! (*childit) ) return;
//                         this->children().insert( childit );
//                 }


// // 		std::string get_string( const key_type & key, const mapped_type & defaultVal = mapped_type() ) const;
// // 		void set_string( const key_type & key, const std::string & val );
                
//                 void set( const key_type & key, const mapped_type & val )
// 		{
//                         this->m_map[key] = val;
// 		}
//                 template < typename T > void set( const key_type & key, const T & val )
// 		{
//                         this->set( key, from_string( to_string( val ), val );
// 		}

// 		mapped_type get( const key_type & key, const mapped_type & defaultval ) const
//                 {
//                 	const_iterator mit = this->m_map.find( key );
//                         const_iterator met = this->m_map.end();
//                         if( met == mit ) return defaultval;
//                         return (*mit).second;
// 		}

// 		template < typename T > T get( const key_type & key, const T & defaultval ) const
//                 {
//                         return this->get( key, from_string( to_string( defaultval ), defaultval );
// 		}

//         private:
//                 map_type m_map;
//                 child_list_type m_children;
//                 std::string m_implclass;
//                 std::string m_name;
//         }; // basic_data_node


	/**

           data_node is the next generation of
           S11N_NS::s11n_node.  It is a pure container, without
           and de/serialization-related methods. It is
           non-polymorphic, in contrast to s11n_node.

           It is purely experimental at this point.

           This type is a reference implementation for the
           functionality required of data nodes by the s11n core
           framework. Any type which conforms to this class'
           interface/conventions should be usable by
           S11N_NS::serialize() and related functions.

           Common conventions for types "convetionally compatible"
           with data_node are listed below. 

           - Should not throw exceptions, especially in the
           ctors/dtor.

           - Each node must have a name, accessible via name(), which
           "should" conform to common element naming conventions
           (alphanumeric/underscore).

           - Must be default constructable via new() and it must be
           safely deletable via delete().

           - Must support deep copy operations, though specific
           optimizations (e.g. copy-on-write) are not excluded as long
           as their operation is transparent to client code.

           - Owns all of it's child pointers, or at least does not require
           client code to delete them.

           - Structured like a DOM element, with an arbitrary number
           of unique key/value pairs and an arbitrary number of child
           data_node objects (of the same base type as the parent
           node).

           - Property key and value types must be i/ostreamable, so as
           to inherently support easy conversion between strings and
           arbitrary types such as PODs and std::string, as well
           as user-defined streamable types.

           - Each node must have a proper impl_class() (documented at
           length elsewhere).

           - Should follow common std::map-style conventions for getting/setting
           properties, in addition to any other (convenience) interface.
           The type should provide begin()/end() iterator accessors for
           the properties.

           - Should support common std::list-style conventions for
           traversing child nodes. The conventional function for
           accessing the children list is named children().

           - Need not be polymorphic, but it may be so.

           - Data nodes are not, by their nature, also Serializable
           (as such).  Indeed, their whole purpose is store data for
           Serializable types. They ARE "serializable" in the sense
           that their key/value sets must be eventually convertable to
           some "external representation" (i.e., strings).

           - Should not be implemented as template types, for
           usability and maintenance reasons. One exception might be
           to go STL-style, and define it as a class template, but
           provide a typedef or subclass/specialization for the
           "standard" variant (as is the case for std::string).  The
           first prototype of this library thought it would be clever
           to use s11n_node&lt;SerializableType&gt;, but i can promise
           you that causes Coding Hell down the road in client code if
           you ever try to mix different SerializableTypes in the same
           code.)


           More specific conventions will be detailed later in the
           library manual.

        */
        class data_node
        {
        public:

                /**
                   The map type this object uses to store items
                   internally.
                 */
		typedef std::map < std::string, std::string > map_type;

                /**
                   A pair type used to store key/value properties
                   internally.
                */
		typedef map_type::value_type value_type;

                /** For compatibility with std::map */
                typedef map_type::key_type key_type; 

                /** For compatibility with std::map */
                typedef map_type::mapped_type mapped_type; 

                /**
                   The container type used to store this object's children.
                   It contains (data_node *).

                   While the exact type is not guaranteed, it is
                   guaranteed to obey the most-commonly-used
                   std::list/vector conventions: push_back(), erase(),
                   etc.
                */
		typedef std::vector<data_node *> child_list_type;

                /**
                   For iterating over properties using STL
                   conventions.

                   Dereferences to a value_type object.
                 */
		typedef map_type::iterator iterator;

                /**
                   For iterating over properties using STL
                   conventions.

                   Dereferences to a value_type object.
                 */
		typedef map_type::const_iterator const_iterator;


                /**
                   Creates a new node with an empty name() and an
                   impl_class() of "S11N_NS::data_node". This
                   node is functionally useless until it's name is
                   set, as nodes with empty names are not supported by
                   any current i/o parsers.
                */
                data_node();

                /**
                   Creates a new node with the given name() and an
                   impl_class() of "S11N_NS::data_node".
                */
		explicit data_node( const std::string & name );

                /**
                   Creates a new node with the given name() and and impl_class().

                   Does not throw.
                */
                data_node( const std::string & name, const std::string implclass );

                /**
                   Destroys all child objects owned by this object, freeing up
                   their resources.

                   Does not throw.
                */
                ~data_node();

                /**
                   See copy().

                   Does not throw.
                */
                data_node & operator=( const data_node & rhs );

                /**
                   See copy().

                   Does not throw.
                */
                data_node( const data_node & rhs );

		/**
                   Returns a list of the data_node children of this
                   object. The caller should not delete any pointers
                   from this list unless he also removes the pointers
                   from the list, or else they will get double-deleted
                   later. In practice it is (almost) never necessary
                   for client code to manipulate this list directly.

                   See node_child_simple_formatter<> for a funcfor designed
                   to quickly serialize lists such as this one.
                */
                child_list_type & children();

                /**
                   The const form of children().
                 */
                const child_list_type & children() const;


                /**
                   Removes all properties and deletes all children from
                   this object, freeing up their resources.
                   
                   Any pointers to children of this object become
                   invalided by a call to this function (they get
                   deleted). Since client code doesn't normally hold
                   pointers to data_node children this should not be
                   a practical problem. This is normally only used
                   in test code, not client code.
                */
                void clear();
                /**  older name for clear(). Deprecated. */
                void reset() { this->clear(); }



		/**
                   Returns all children() with a name() matching the
                   given string by inserting them into the given
                   container, which must support:

                   push_back( const data_node *  )

                   The caller does NOT own the child pointers: they
                   are still owned by this object.

                   This method is known to work with std::list and
                   std::vector.

                   Complexity: basically linear, based on the number
                   of children in this object and how many have the
                   name nodename (more matches requires more
                   insertions into the target container).

                   Note that constness will prohibit clients from modifying
                   an established tree of data_nodes. This is in line with
                   common usage of this class. If you want to modify nodes,
                   do so before inserting them into a tree.

                */
// 		template < typename ContainerType >
//                 size_t children( const std::string & nodename, ContainerType & ctr ) const
// 		{
// //                         // todo: re-implement using copy_if()
// 			data_node *ch = 0;
//                         typedef data_node::child_list_type::const_iterator CIT;
//                         CIT cit = this->children().begin();
//                         CIT cet = this->children().end();
// 			size_t count = 0;
// 			for ( ; cit != cet; ++cit )
// 			{
// 				ch = ( *cit );
// 				if ( ch->name() == nodename )
// 				{
// 					++count;
// 					ctr.push_back( ch );
// 				}
// 			}
// 			return count;
// 		}


//                 /**
//                    Returns the first child node with the given node
//                    name, or NULL. The caller does not own the pointer.
//                 */
//                 const data_node * child( const std::string & nodename ) const;


		/**
                   Defines the class name which should be used as the
                   implementation for the node when it is
                   deserialize()d.

                   Client Serializable types should call this one time
                   from their serialize() method, <em>after</em> calling
                   the parent class' serialize() method (if indeed that
                   is called at all), passing it the name of their class,
                   <em>as it will be used by the classloader</em>. By convention
                   the class name is the same as it's C++ name, thus Serializable
                   class foo::FooBar should call:

<pre>
node.impl_class( "foo::FooBar" );
</pre>
		  from it's serialize() function.


                   Historical note: the above call <em>should</em> be
                   handled 100% transparently by this library. There
                   are, however, legitimate use-cases which the
                   template/macro-based solution cannot catch, so
                   users are encouraged to set it manually, as
                   described above. If you don't then you your
                   serialized data will all have the same impl_class:
                   probably that of the base-most Serializable
                   class. That *will* break deserialization.
                */
		void impl_class( const std::string & n );


                /**
                   Returns the implementation class name set via impl_class().
                */
                std::string impl_class() const;

		/**
                   The name which should be used as the key for
                   storing the node. This is normally translated to
                   something like an XML element name (e.g., &lt;name&gt;),
                   and should not contain spaces or other characters
                   which may not be usable as key names. To be safe,
                   stick to alphanumeric and underscores, starting
                   with a letter or underscore. (This class does no
                   enforce any naming conventions, but your data file
                   parsers certainly will.)
                */
		void name( const std::string & n );

		/**
                   Returns this node's name, as set via name(string).
                */
		std::string name() const;

		/**
                   std::string propval = node["bar"] is functionally
                   identical to node.get_string("bar").

                   Unlike std::map and the like, calling this operator
                   with a key which is not in the object does not
                   create a new entry - it simply returns an empty
                   string in that case. This behaviour is not a
                   specific of the interface for purposes of data_node
                   conventions.
                */
		const mapped_type operator[] ( const key_type & key ) const;

                /**
                   Untested.

                   Returns a non-const reference to a property with
                   the given key. If key does not exist a new entry is
                   created.
                */
		mapped_type & operator[] ( const key_type & key );


                /**
                   For compatibility with std::map. Inserts a
                   value_type (i.e., pair) into this object.
                 */
                void insert( const value_type & );


		/**
                 * Returns the value for key, or defaultVal if the key
                 * is not set.
                 *
                 * Maintenance note: this is the "master"
                 * getter. Almost all other getXXX() functions call
                 * this one, so do not call them from inside this
                 * function.
                 *
                 */
		std::string get_string( const std::string & key, const std::string & defaultVal = std::string() )const;

		/**
                   Sets the given key to the given value.
                   See get_string(): same notes apply here.
                */
		void set_string( const std::string & key, const std::string & val );

		/**
                   See set_string(). This function is identical except
                   that it converts val to string before saving it. If
                   this type conversion is not possible it will fail
                   at compile time. A value-conversion failure, on the
                   other hand, is not caught at compile time.
                 */
                template < typename T > void set( const std::string & key, const T & val )
		{
			this->set_string( key, S11N_NS::to_string( val ) );
		}

//                 /**
//                    Returns true if this object has no properties and
//                    no children, else false.
//                 */
//                 bool empty() const;

		/**
                   The <const char *> variants of get() and set() are
                   to help the developer avoid having to cast so much
                   and to help out compilers which have mediocre
                   template support. :/
                */
		void set( const char *key, const char *val )
		{
			this->set_string( key, val );
		}
                /**
                   Overloaded for strings-via-streams reaons.
                 */
		void set( const std::string & key, const char *val )
		{
			this->set_string( key, val );
		}
                /**
                   Overloaded for strings-via-streams reaons.
                 */
		void set( const char *key, const std::string & val )
		{
			this->set_string( key, val );
		}

		/**
                   See get_string(). This function is identical except
                   that the returned string is converted to type T. If
                   this type is not possible it will fail at compile
                   time. A value-conversion failure, on the other
                   hand, is not caught at compile time. If value
                   conversion fails then defaultval is returned. This
                   can be interpretted as an error value if the client
                   so chooses, and it is often helpful to pass a
                   known-invalid value here for that purpose.
                 */
		template < typename T > T
                get( const std::string & key, const T & defaultval ) const
		{
			std::string foo = this->get_string( key, S11N_NS::to_string( defaultval ) );
			return S11N_NS::from_string( foo, defaultval );
		}

                /**
                   get(): see <code>set( const char *, const char * )</code>. Same notes apply.
                */
		std::string get( const char *key, const char *val ) const
		{
			return this->get_string( key, val );
		}
                /**
                   Overloaded for strings-via-streams reasons.
                 */
		std::string get( const std::string & key, const char *val ) const
		{
			return this->get_string( key, val );
		}
                /**
                   Overloaded for strings-via-streams reasons.
                 */
		std::string get( const char *key, const std::string & val ) const
		{
			return this->get_string( key, val );
		}


                /**
                   Returns true if this object contains the given
                   property, else false.
                */
		bool is_set( const std::string & key ) const;

                /**
                   Removes the given property from this object.
                */
		void unset( const std::string & key );

		/**
                   set_bool() is provided to work around a potential
                   compiler warning:
                   
<pre>
props.set( "foo", false );
// ambiguous: may be bool, const char *, char, or even int :/
</pre>
                */
		void set_bool( const std::string & key, bool val );

		/**
                   get_bool(key) returns true if key's value is true, as
                   evaluated by the static function bool_val().
                */
		bool get_bool( const std::string & key, bool defaultVal ) const;



		/**
                 * Returns the bool value of the passed string.
                 * The following string values are considered equal to true:
                 *
                 *     true, TRUE, True
                 *     yes, YES, Yes, y, Y
                 *     1
                 *
                 * Anything else evaluates to false.
                 *
                 * Case IS significant!
                 */
		static bool bool_val( const std::string & key );


		/**
                 * Returns end() if the key is not in our map, otherise it returns
                 * that iterator. Use the iterator's 'first' member to get the key
                 * and 'second' to get at it's value.
                 */
		iterator find( const std::string & key );


		/**
                 * Returns the first item in the data map.
                 * You can use this to iterate, STL-style:
                 * <pre>
                 *   data_node::iterator it = node.begin();
                 *   for( ; node.end() != it; ++it ) { ... }
                 * </pre>
                 *
                 * Note that the iterator represents a
                 * value_type (std::pair), so use (*it).first to get
                 * the key and (*it).second to get the value.
                 */
		iterator begin();

                /**
                   Returns a const_iterator pointing at this object's
                   first property.
                */
		const_iterator begin() const;

		/**
                 * The after-the-end iterator for the data map.
                 */
		iterator end();

		/**
                 * The after-the-end iterator for the data map.
                 */
		const_iterator end() const;


		/**
                 * Returns the internally-used map_type (see the typedefs).
                 * It is safe to modify this directly.
                 */
		map_type & map();

		/**
                 * Returns the internally-used map_type (see the typedefs).
                 */
		const map_type & map() const;

                /**
                   Returns the number of properties in this object.
                */
                size_t size() const;


        private:
		map_type m_map; // stores key/value properties.
		std::string m_name; // name of this node
		std::string m_iname; // impl_class name of this node
		child_list_type m_children; // holds child pointers

                /**
                   Copies all properties and child data_nodes from
                   rhs into this object, as well as any other details
                   which need to be copied.

                   This can be a very expensive operation, and is rarely
                   necessary.
                */
                void copy( const data_node & rhs );

        private:
		/**
                   Removes all property entries from this object.
                 */
		void clear_properties();

		/**
                   Removes all children from this object, deleting all
                   child pointers.
                 */
                void clear_children();




	}; // class data_node




}; // namespace S11N_NS

#include <S11N_NS/class_loader.h> // CL registration macros
S11N_NS_CLASSLOADER_REGISTER1(S11N_NS::data_node);



#endif // S11N_NS_DATA_NODE_H_INCLUDED
