#! /usr/bin/env ruby

require 'getoptlong'
require 'rbconfig'
require 'ftools'
require 'find'

SRC = 'rexml'


INSTDIR = File.join Config::CONFIG['sitedir'], 
	"#{Config::CONFIG['MAJOR']}.#{Config::CONFIG['MINOR']}"
DESTDIR = File.join INSTDIR, SRC

opts = GetoptLong.new( [ "--uninstall",	"-u",		GetoptLong::NO_ARGUMENT ] )

def install
	begin
		File.makedirs( DESTDIR )
		Find.find(SRC) { |file|
			dst = File.join( INSTDIR, file )
			File.makedirs(File.dirname(dst))
			File.install(file, dst, 0644, true) if file =~ /\.rb$/ and not /\.svn/
		}
	rescue
		puts $!
	end
end

def uninstall
	begin
		puts "Deleting:"
		Find.find(DESTDIR) { |file| File.rm_f file,true }
		puts DESTDIR
		Dir.delete DESTDIR
	rescue
	end
end

if (opt = opts.get) and opt[0] =~ /^-?-u/
	uninstall
else
	install
end
