-- MySQL dump 10.11
--
-- Host: localhost    Database: Canzeley
-- ------------------------------------------------------
-- Server version	5.0.51a-24+lenny2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

CREATE DATABASE IF NOT EXISTS Canzeley;
USE Canzeley;

--
-- Table structure for table `Adressen`
--

DROP TABLE IF EXISTS `Adressen`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Adressen` (
  `ID` int(11) NOT NULL auto_increment,
  `PersonengruppenNr` int(11) NOT NULL default '1',
  `Firmennamen` varchar(50) collate latin1_german1_ci default NULL,
  `Anrede` varchar(50) collate latin1_german1_ci default NULL,
  `BriefAnrede` varchar(100) collate latin1_german1_ci default NULL,
  `Vorname` varchar(50) collate latin1_german1_ci default NULL,
  `Nachname` varchar(50) collate latin1_german1_ci NOT NULL default '',
  `EhepartnerName` varchar(50) collate latin1_german1_ci default NULL,
  `Strasse` varchar(70) collate latin1_german1_ci default NULL,
  `Ort` varchar(70) collate latin1_german1_ci default NULL,
  `PLZ` varchar(20) collate latin1_german1_ci default NULL,
  `EMailAdresse` varchar(70) collate latin1_german1_ci default NULL,
  `TelefonPrivat` varchar(30) collate latin1_german1_ci default NULL,
  `TelefonBeruflich` varchar(30) collate latin1_german1_ci default NULL,
  `DurchwahlBuero` varchar(30) collate latin1_german1_ci default NULL,
  `MobilesTelefon` varchar(30) collate latin1_german1_ci default NULL,
  `Faxnummer` varchar(30) collate latin1_german1_ci default NULL,
  `Geburtsdatum` date default NULL,
  `Anmerkungen` varchar(255) collate latin1_german1_ci default NULL,
  `Kontonummer` varchar(15) collate latin1_german1_ci default NULL,
  `BLZ` int(10) default NULL,
  `Bankname` varchar(30) collate latin1_german1_ci default NULL,
  `Homepage` varchar(50) collate latin1_german1_ci default NULL,
  `Anlagedatum` date NOT NULL,
  `Aenderungsdatum` date NOT NULL,
  `Name2` varchar(50) collate latin1_german1_ci default NULL,
  `Land` varchar(40) collate latin1_german1_ci default NULL,
  `Postfach` varchar(30) collate latin1_german1_ci default NULL,
  `Zeichen` varchar(30) collate latin1_german1_ci default NULL,
  `Umsatzsteuerberechnung` varchar(5) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Adressen`
--

LOCK TABLES `Adressen` WRITE;
/*!40000 ALTER TABLE `Adressen` DISABLE KEYS */;
/*!40000 ALTER TABLE `Adressen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Akten`
--

DROP TABLE IF EXISTS `Akten`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Akten` (
  `ID` int(11) NOT NULL auto_increment,
  `RegisterNr` varchar(15) collate latin1_german1_ci NOT NULL,
  `Anlagedatum` date NOT NULL,
  `ReferatNr` int(11) default NULL,
  `Sachbearbeiter` int(11) default NULL,
  `Kurzrubrum` varchar(50) collate latin1_german1_ci NOT NULL,
  `Wegen` varchar(50) collate latin1_german1_ci default NULL,
  `Aktenzeichen` varchar(7) collate latin1_german1_ci default NULL,
  `Anmerkung` varchar(255) collate latin1_german1_ci default NULL,
  `LetzteAenderung` date NOT NULL,
  `Akteabgelegt` char(3) collate latin1_german1_ci default NULL,
  `Ablagedatum` date default NULL,
  `AblageNr` varchar(7) collate latin1_german1_ci default NULL,
  `AblageNotizen` varchar(255) collate latin1_german1_ci default NULL,
  `Herkunft` varchar(50) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Akten`
--

LOCK TABLES `Akten` WRITE;
/*!40000 ALTER TABLE `Akten` DISABLE KEYS */;
/*!40000 ALTER TABLE `Akten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AktenAdressen`
--

DROP TABLE IF EXISTS `AktenAdressen`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `AktenAdressen` (
  `ID` int(9) NOT NULL auto_increment,
  `AktenNr` int(9) NOT NULL,
  `AdressenNr` int(9) NOT NULL,
  `PersonengruppenNr` int(10) NOT NULL default '1',
  `Zeichen` varchar(50) collate latin1_german1_ci default NULL,
  `Ansprechperson` varchar(55) collate latin1_german1_ci default NULL,
  `TelefonAP` varchar(20) collate latin1_german1_ci default NULL,
  `TelefaxAP` varchar(20) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `AktenAdressen`
--

LOCK TABLES `AktenAdressen` WRITE;
/*!40000 ALTER TABLE `AktenAdressen` DISABLE KEYS */;
/*!40000 ALTER TABLE `AktenAdressen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AktenGerichte`
--

DROP TABLE IF EXISTS `AktenGerichte`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `AktenGerichte` (
  `ID` int(11) NOT NULL auto_increment,
  `AktenNr` int(11) NOT NULL,
  `GerichteNr` int(11) NOT NULL,
  `Aktenzeichen` varchar(50) collate latin1_german1_ci default NULL,
  `Kurzrubrum` varchar(100) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `AktenGerichte`
--

LOCK TABLES `AktenGerichte` WRITE;
/*!40000 ALTER TABLE `AktenGerichte` DISABLE KEYS */;
/*!40000 ALTER TABLE `AktenGerichte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AnredeBriefanrede`
--

DROP TABLE IF EXISTS `AnredeBriefanrede`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `AnredeBriefanrede` (
  `ID` int(11) NOT NULL auto_increment,
  `Anrede` varchar(100) collate latin1_german1_ci default NULL,
  `Briefanrede` varchar(100) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `AnredeBriefanrede`
--

LOCK TABLES `AnredeBriefanrede` WRITE;
/*!40000 ALTER TABLE `AnredeBriefanrede` DISABLE KEYS */;
INSERT INTO `AnredeBriefanrede` VALUES (1,'Herr','Sehr geehrter Herr'),(2,'Firma','Sehr geehrte Damen und Herren');
/*!40000 ALTER TABLE `AnredeBriefanrede` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Gerichte`
--

DROP TABLE IF EXISTS `Gerichte`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Gerichte` (
  `ID` int(11) NOT NULL auto_increment,
  `GerichtsartNr` int(11) NOT NULL,
  `Gericht` varchar(60) collate latin1_german1_ci NOT NULL,
  `OrtNr` int(6) default NULL,
  `PLZ` varchar(10) collate latin1_german1_ci default NULL,
  `Strasse` varchar(30) collate latin1_german1_ci default NULL,
  `Telefon` varchar(30) collate latin1_german1_ci default NULL,
  `Telefax` varchar(30) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Gerichte`
--

LOCK TABLES `Gerichte` WRITE;
/*!40000 ALTER TABLE `Gerichte` DISABLE KEYS */;
INSERT INTO `Gerichte` VALUES (1,1,'AG Düsseldorf',1,'40213','Mühlenstr. 34','0211-8306-0','0211-8306-161'),(2,2,'LG Düsseldorf',1,'40213','Neubrückstr. 3','0211-8306-0','0211-8306-160');
/*!40000 ALTER TABLE `Gerichte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Gerichtsart`
--

DROP TABLE IF EXISTS `Gerichtsart`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Gerichtsart` (
  `GerichtsartNr` int(11) NOT NULL auto_increment,
  `Gerichtsart` varchar(30) collate latin1_german1_ci NOT NULL default '',
  `AbKuerzung` varchar(10) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`GerichtsartNr`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Gerichtsart`
--

LOCK TABLES `Gerichtsart` WRITE;
/*!40000 ALTER TABLE `Gerichtsart` DISABLE KEYS */;
INSERT INTO `Gerichtsart` VALUES (1,'Amtsgericht','AG'),(2,'Landgericht','LG');
/*!40000 ALTER TABLE `Gerichtsart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Herkunft`
--

DROP TABLE IF EXISTS `Herkunft`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Herkunft` (
  `ID` int(11) NOT NULL auto_increment,
  `Herkunft` varchar(50) collate latin1_german1_ci NOT NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Herkunft`
--

LOCK TABLES `Herkunft` WRITE;
/*!40000 ALTER TABLE `Herkunft` DISABLE KEYS */;
INSERT INTO `Herkunft` VALUES (1,'frühere Tätigkeit');
/*!40000 ALTER TABLE `Herkunft` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `KontenIBAN`
--

DROP TABLE IF EXISTS `KontenIBAN`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `KontenIBAN` (
  `ID` int(11) NOT NULL auto_increment,
  `Kontoinhaber` varchar(50) collate latin1_german1_ci NULL,
  `Bank` varchar(50) collate latin1_german1_ci default NULL,
  `IBAN` varchar(34) collate latin1_german1_ci default NOT NULL,
  `BIC` varchar(11) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `KontenIBAN`--

LOCK TABLES `KontenIBAN` WRITE;
/*!40000 ALTER TABLE `KontenIBAN` DISABLE KEYS */;
/*!40000 ALTER TABLE `KontenIBAN` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OrtNr`
--

DROP TABLE IF EXISTS `OrtNr`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `OrtNr` (
  `OrtNr` bigint(3) NOT NULL auto_increment,
  `Ort` varchar(50) NOT NULL,
  PRIMARY KEY  (`OrtNr`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `OrtNr`
--

LOCK TABLES `OrtNr` WRITE;
/*!40000 ALTER TABLE `OrtNr` DISABLE KEYS */;
INSERT INTO `OrtNr` VALUES (1,'Düsseldorf');
/*!40000 ALTER TABLE `OrtNr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Personengruppe`
--

DROP TABLE IF EXISTS `Personengruppe`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Personengruppe` (
  `ID` int(11) NOT NULL auto_increment,
  `Personengruppe` varchar(50) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Personengruppe`
--

LOCK TABLES `Personengruppe` WRITE;
/*!40000 ALTER TABLE `Personengruppe` DISABLE KEYS */;
INSERT INTO `Personengruppe` VALUES (1,'Mandant'),(2,'Gegner');
/*!40000 ALTER TABLE `Personengruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PersonenKonten`
--

DROP TABLE IF EXISTS `PersonenKonten`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `PersonenKonten` (
  `ID` int(11) NOT NULL auto_increment,
  `AdressenID` int(11) NOT NULL,
  `KontenID` int(11) NOT NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `PersonenKonten`
--

LOCK TABLES `PersonenKonten` WRITE;
/*!40000 ALTER TABLE `PersonenKonten` DISABLE KEYS */;
/*!40000 ALTER TABLE `PersonenKonten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Referat`
--

DROP TABLE IF EXISTS `Referat`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Referat` (
  `ID` int(11) NOT NULL auto_increment,
  `Referat` varchar(50) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Referat`
--

LOCK TABLES `Referat` WRITE;
/*!40000 ALTER TABLE `Referat` DISABLE KEYS */;
INSERT INTO `Referat` VALUES (1,'Zivilsache (allgem.)');
/*!40000 ALTER TABLE `Referat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Sachbearbeiter`
--

DROP TABLE IF EXISTS `Sachbearbeiter`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Sachbearbeiter` (
  `Sachbearbeiter-Nr` int(4) NOT NULL auto_increment,
  `Sachbearbeiter` varchar(50) collate latin1_german1_ci NOT NULL,
  PRIMARY KEY  (`Sachbearbeiter-Nr`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Sachbearbeiter`
--

LOCK TABLES `Sachbearbeiter` WRITE;
/*!40000 ALTER TABLE `Sachbearbeiter` DISABLE KEYS */;
/*!40000 ALTER TABLE `Sachbearbeiter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Systemeigenschaften`
--

DROP TABLE IF EXISTS `Systemeigenschaften`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Systemeigenschaften` (
  `ID` int(10) NOT NULL auto_increment,
  `EigenschaftName` varchar(50) NOT NULL,
  `EigenschaftWert` varchar(50) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Systemeigenschaften`
--

LOCK TABLES `Systemeigenschaften` WRITE;
/*!40000 ALTER TABLE `Systemeigenschaften` DISABLE KEYS */;
INSERT INTO `Systemeigenschaften` VALUES (1,'Datenbankversion','50');
/*!40000 ALTER TABLE `Systemeigenschaften` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Vorlagen`
--

DROP TABLE IF EXISTS `Vorlagen`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Vorlagen` (
  `ID` int(10) NOT NULL auto_increment,
  `Vorlagenname` varchar(50) NOT NULL,
  `Beschreibung` varchar(200) default NULL,
  `Bezeichnung` varchar(20) default NULL,
  `Pfad` varchar(200) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Vorlagen`
--

LOCK TABLES `Vorlagen` WRITE;
/*!40000 ALTER TABLE `Vorlagen` DISABLE KEYS */;
/*!40000 ALTER TABLE `Vorlagen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Wiedervorlagen`
--

DROP TABLE IF EXISTS `Wiedervorlagen`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `Wiedervorlagen` (
  `ID` int(11) NOT NULL auto_increment,
  `AktenID` int(11) NOT NULL,
  `Datum` date default NULL,
  `WvlGrund` varchar(50) character set latin1 collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `Wiedervorlagen`
--

LOCK TABLES `Wiedervorlagen` WRITE;
/*!40000 ALTER TABLE `Wiedervorlagen` DISABLE KEYS */;
/*!40000 ALTER TABLE `Wiedervorlagen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `WvlGrund`
--

DROP TABLE IF EXISTS `WvlGrund`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `WvlGrund` (
  `ID` int(11) NOT NULL auto_increment,
  `WvlGrund` varchar(50) collate latin1_german1_ci default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_german1_ci;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `WvlGrund`
--

LOCK TABLES `WvlGrund` WRITE;
/*!40000 ALTER TABLE `WvlGrund` DISABLE KEYS */;
INSERT INTO `WvlGrund` VALUES (1,'allg. Kontrolle');
/*!40000 ALTER TABLE `WvlGrund` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2010-06-23  7:34:41
