/* position.cc
 */
#include "osl/position.h"
#include <boost/static_assert.hpp>
#include <iostream>

BOOST_STATIC_ASSERT(sizeof(osl::Position) == 4);

bool osl::Position::isOnBoardSlow() const 
{
    return (1<=x() && x() <=9 
	    && 1<=y() && y() <=9);
}

bool osl::Position::isValid() const
{
  return isPieceStand() || isOnBoard();
}

const osl::Position osl::
Position::positionForBlackSlow(Player player) const
{
  if (player == BLACK) 
    return *this;
  return Position(reverseX(x()),reverseY(y()));
}

std::ostream& osl::operator<<(std::ostream& os, Position position)
{
  if (position.isPieceStand())
    return os << "OFF";
  return os << "Position(" << position.x() << position.y() << ")";
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
