/**
 * attackKing.h
 */
#ifndef EVAL_ENDGAME_ATTACKKING_H
#define EVAL_ENDGAME_ATTACKKING_H

#include "osl/eval/endgame/kingPieceTable.h"
#include "osl/state/simpleState.h"

namespace osl
{
  namespace eval
  {
    namespace endgame
    {
      /**
       * 玉の位置*攻撃駒の位置*ptype
       */
      class AttackKing
      {
	struct Table : public KingPieceTable
	{
	  Table();
	private:
	  void adhoc_edge_king_1(const Player player,
				 const Position king,
				 const Position attack);
	  void adhoc_edge_king_2(const Player player,
				 const Position king,
				 const Position attack);
	};
	static const Table table;
      public:
	static int valueOf(const Piece king, const Piece attacker)
	{
	  return valueOf(king, attacker.ptypeO(), attacker.position());
	}
	static int valueOf(Piece king, PtypeO ptypeo, Position position)
	{
	  assert(king.ptype() == KING);
	  if (getOwner(ptypeo) == king.owner())
	    return 0;
	  return table.valueOf(king.position(), king.owner(), 
			       position, getPtype(ptypeo));
	}
      };
    } // namespace endgame
  } // namespace endgame
} // namespace osl

#endif /* EVAL_ENDGAME_ATTACKKING_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
