#ifndef OSL_BETTER_TO_PROMOTE_MOVE_ACTION_H
#define OSL_BETTER_TO_PROMOTE_MOVE_ACTION_H
#include "osl/move_action/concept.h"
namespace osl
{
  namespace effect_action
  {
    /**
     * 成った方が良い駒は成る手のみ生成
     */
    template<class Action>
    class BetterToPromote
    {
      BOOST_CLASS_REQUIRE(Action,osl::move_action,Concept);
    private:
      const NumEffectState& state;
      Action & ac;
    public:
      BetterToPromote(const NumEffectState& s, Action& a) 
	: state(s), ac(a)
      {
      }
      template<Player P,Ptype Type>
      void doActionPtype(Piece p1,Position to){
	assert(Type == unpromote(p1.ptype()));
	Position from=p1.position(); 
	Piece target = state.getPieceAt(to);
	if (canPromote(Type) &&
	   !p1.isPromotedNotKingGold() &&
	   (to.canPromote<P>() || from.canPromote<P>())){
	  ac.unknownMove(from,to,target,promote(Type),true,P);
	}
	if (!canPromote(Type) ||
	   PtypePlayerTraits<Type,P>::canDropTo(to) ||
	   p1.isPromotedNotKingGold()){
	  if (! (to.canPromote<P>() || from.canPromote<P>())
	      || (! PtypeTraits<Type>::betterToPromote
		  && (p1.ptype() != LANCE
		      || PtypePlayerTraits<LANCE,P>::canDropTo(to + DirectionPlayerTraits<U,P>::offset()))))
	    ac.unknownMove(from,to,target,p1.ptype(),false,P);
	}
      }
      /**
       * Ptypeをtemplate引数にできない場合
       */
      template<Player P>
      void doAction(Piece p1,Position to)
      {
	Position from=p1.position(); 
	Ptype ptype=p1.ptype();
	Piece target = state.getPieceAt(to);
	if(canPromote(ptype))
	{
	  if (to.canPromote<P>())
	  {
	    ac.unknownMove(from,to,target,promote(ptype),true,P);
	    if(Ptype_Table.canDropTo(P, ptype,to)
	       && ! Ptype_Table.isBetterToPromote(ptype)
	       && (ptype != LANCE
		   || PtypePlayerTraits<LANCE,P>::canDropTo(to + DirectionPlayerTraits<U,P>::offset())))

	    {
	      ac.unknownMove(from,to,target,ptype,false,P);
	    }
	    return;
	  }
	  if (from.canPromote<P>())
	  {
	    ac.unknownMove(from,to,target,promote(ptype),true,P);
	    if(! Ptype_Table.isBetterToPromote(ptype)
	       && (ptype != LANCE
		   || PtypePlayerTraits<LANCE,P>::canDropTo(to + DirectionPlayerTraits<U,P>::offset())))
	      ac.unknownMove(from,to,target,ptype,false,P);
	    return;
	  }
	  // fall through
	}
	ac.unknownMove(from,to,target,ptype,false,P);
      }
    };
  } // namespace effect_action
} // namespace osl
#endif // OSL_BETTER_TO_PROMOTE_MOVE_ACTION_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
