/***************************************************************************
 $RCSfile: error.cpp,v $
                             -------------------
    cvs         : $Id: error.cpp,v 1.7 2003/04/25 01:45:54 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "assert.h"
#include "hbcistring.h"
#include "error.h"

namespace HBCI {

Error::Error(string where,
	     string message,
	     int code)
    :_where(where)
    ,_level(ERROR_LEVEL_NORMAL)
    ,_code(code)
    ,_advise(ERROR_ADVISE_DONTKNOW)
    ,_message(message)
{
}



Error::Error()
:_level(ERROR_LEVEL_NONE)
,_code(0)
,_advise(ERROR_ADVISE_DONTKNOW)
{
}


Error::Error(string where,
	     ErrorLevel level,
	     int code,
	     ErrorAdvise advise,
	     string message,
	     string info)
:_where(where)
,_level(level)
,_code(code)
,_advise(advise)
,_message(message)
,_info(info)
{
}


Error::Error(const string &where,
	     const Error &err)
{
    *this=err;
    if (_reportedFrom.empty())
	_reportedFrom=where;
    else
	_reportedFrom=where+"/"+_reportedFrom;
}


Error::~Error(){
}


string Error::errorString() const {
    string result;

    if (_level==ERROR_LEVEL_NONE)
        result="NONE";
    else {
        result+=_message;
        result+=" (";
        result+=String::num2string(_code);
        result+=") at ";
        result+=_where;
        if (!_info.empty()) {
            result+=" Info: ";
            result+=_info;
        }
	if (!_reportedFrom.empty()) {
	    result+=" reported from ";
	    result+=_reportedFrom;
	}
    }
    return result;
}


} // namespace HBCI

HBCI_Error* 
HBCI_Error_new(const char* where,
	       ErrorLevel level,
	       int code,
	       ErrorAdvise advise,
	       const char* error,
	       const char* info)
{
    return new HBCI_Error(string(where),
			  level,
			  code,
			  advise,
			  string(error),
			  string(info));
}

void 
HBCI_Error_delete(HBCI_Error* e) 
{
    delete(e);
}

int HBCI_Error_isOk(const HBCI_Error * e) {
    assert(e);
    return e->isOk();
}

const char * HBCI_Error_where(const HBCI_Error * e) {
    assert(e);
    return e->where().c_str();
}

int HBCI_Error_code(const HBCI_Error * e) {
    assert(e);
    return e->code();
}

ErrorLevel HBCI_Error_level(const HBCI_Error * e) {
    assert(e);
    return e->level();
}

ErrorAdvise HBCI_Error_advise(const HBCI_Error * e) {
    assert(e);
    return e->advise();
}

const char * HBCI_Error_message(const HBCI_Error * e) {
    assert(e);
    return e->message().c_str();
}

const char * HBCI_Error_info(const HBCI_Error * e) {
    assert(e);
    return e->info().c_str();
}

char * HBCI_Error_errorString(const HBCI_Error * e) {
    assert(e);
    return hbci_strdup( e->errorString() );
}
