(*
    Generated parser for VisualOberon preferences.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE VO:Prefs:Parser;

IMPORT
       U   := VO:Base:Util,

       I   := IntStr,
       str := Strings,
       T   := TextRider;

TYPE
  Item*      = POINTER TO ItemDesc;
  ItemDesc*  = RECORD
                 next*,last* : Item;

                 itemList*,
                 itemLast*,
                 parent*     : Item;

                 name*       : U.Text;
               END;

  BlockItem*     = POINTER TO BlockItemDesc;
  BlockItemDesc* = RECORD (ItemDesc);
                   END;

  ValueItem*     = POINTER TO ValueItemDesc;
  ValueItemDesc* = RECORD (ItemDesc)
                     value* : U.Text;
                   END;

  PROCEDURE (i : Item) Init*;

  BEGIN
    i.next:=NIL;
    i.last:=NIL;

    i.itemList:=NIL;
    i.itemLast:=NIL;
  END Init;

  PROCEDURE (i : Item) AddItem*(item : Item);

  BEGIN
    item.parent:=i;
    IF i.itemList=NIL THEN
      i.itemList:=item;
    ELSE
      i.itemLast.next:=item;
      item.last:=i.itemLast;
    END;
    i.itemLast:=item;
  END AddItem;

  PROCEDURE (i : Item) GetEntry*(path : ARRAY OF CHAR):Item;

  VAR
    rest    : U.Text;
    pos,len : INTEGER;
    item    : Item;

    PROCEDURE FindSlash():INTEGER;

    VAR
      pos : INTEGER;

    BEGIN
      pos:=0;
      WHILE pos<LEN(path) DO
        IF path[pos]="/" THEN
          RETURN pos;
        END;
        INC(pos);
      END;
      RETURN -1;
    END FindSlash;

  BEGIN
    pos:=FindSlash();
    IF pos>0 THEN
      path[pos]:=0X;
      item:=i.itemList;
      WHILE item#NIL DO
        IF (item.name#NIL) & (item.name^=path) THEN
          path[pos]:="/";
          len:=str.Length(path)-pos;
          NEW(rest,len+1);
          str.Extract(path,pos+1,len,rest^);
          RETURN item.GetEntry(rest^);
        END;
        item:=item.next;
      END;
      RETURN NIL;
    ELSE
      item:=i.itemList;
      WHILE item#NIL DO
        IF (item.name#NIL) & (item.name^=path) THEN
          RETURN item;
        END;
        item:=item.next;
      END;
      RETURN NIL;
    END;
  END GetEntry;

  PROCEDURE (i : Item) GetStringEntry*(name : ARRAY OF CHAR; VAR text : ARRAY OF CHAR):BOOLEAN;

  VAR
    value : Item;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      COPY(value(ValueItem).value^,text);
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END GetStringEntry;

  PROCEDURE (i : Item) GetIntEntry*(name : ARRAY OF CHAR; default : LONGINT):LONGINT;

  VAR
    value : Item;
    number : LONGINT;
    res    : I.ConvResults;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      I.StrToInt(value(ValueItem).value^,number,res);
      IF res=I.strAllRight THEN
        RETURN number;
      END;
    END;
    RETURN default;
  END GetIntEntry;

  PROCEDURE (i : Item) GetBoolEntry*(name : ARRAY OF CHAR; default : BOOLEAN):BOOLEAN;

  VAR
    value : Item;

  BEGIN
    value:=i.GetEntry(name);
    IF (value#NIL) & (value IS ValueItem) & (value(ValueItem).value#NIL) THEN
      str.Capitalize(value(ValueItem).value^);
      RETURN value(ValueItem).value^="TRUE";
    ELSE
      RETURN default;
    END;
  END GetBoolEntry;

  PROCEDURE (i : Item) PrintXML*(writer : T.Writer; indent : LONGINT);

  BEGIN
  END PrintXML;

  PROCEDURE (v : BlockItem) SetName*(name : ARRAY OF CHAR);

  BEGIN
    NEW(v.name,str.Length(name)+1);
    COPY(name,v.name^);
  END SetName;

  PROCEDURE (b : BlockItem) PrintXML*(writer : T.Writer; indent : LONGINT);

  VAR
    x    : LONGINT;
    help : Item;

  BEGIN
    FOR x:=1 TO indent DO
      writer.WriteChar(" ");
    END;
    writer.WriteString("<");
    writer.WriteString(b.name^);

    x:=0;
    help:=b.itemList;
    WHILE help#NIL DO
      IF help IS ValueItem THEN
        writer.WriteString(" ");
        help.PrintXML(writer,indent);
        INC(x);
      END;
      help:=help.next;
    END;

    x:=0;
    help:=b.itemList;
    WHILE help#NIL DO
      IF help IS BlockItem THEN
        INC(x);
      END;
      help:=help.next;
    END;

    IF x=0 THEN
      writer.WriteString(" />");
    ELSE
      writer.WriteString(">");
      writer.WriteLn;

      help:=b.itemList;
      WHILE help#NIL DO
        IF help IS BlockItem THEN
           help.PrintXML(writer,indent+2);
           writer.WriteLn;
        END;
        help:=help.next;
      END;

      FOR x:=1 TO indent DO
        writer.WriteChar(" ");
      END;
      writer.WriteString("</");
      writer.WriteString(b.name^);
      writer.WriteString(">");
    END;
  END PrintXML;

  PROCEDURE (v : ValueItem) SetValue*(name,value : ARRAY OF CHAR);

  BEGIN
    NEW(v.name,str.Length(name)+1);
    COPY(name,v.name^);
    NEW(v.value,str.Length(value)+1);
    COPY(value,v.value^);
  END SetValue;

  PROCEDURE (v : ValueItem) SetBool*(name : ARRAY OF CHAR; value : BOOLEAN);

  BEGIN
    IF value THEN
      v.SetValue(name,"TRUE");
    ELSE
      v.SetValue(name,"FALSE");
    END;
  END SetBool;

  PROCEDURE (v : ValueItem) SetInt*(name : ARRAY OF CHAR; value : LONGINT);

  VAR
    string : ARRAY 12 OF CHAR;

  BEGIN
    I.IntToStr(value,string);
    v.SetValue(name,string);
  END SetInt;

  PROCEDURE (i : Item) AddItemValue*(name,value : ARRAY OF CHAR);

  VAR
    item : ValueItem;

  BEGIN
    NEW(item);
    item.Init;
    item.SetValue(name,value);
    i.AddItem(item);
  END AddItemValue;

  PROCEDURE (i : Item) AddItemBool*(name : ARRAY OF CHAR; value : BOOLEAN);

  VAR
    item : ValueItem;

  BEGIN
    NEW(item);
    item.Init;
    item.SetBool(name,value);
    i.AddItem(item);
  END AddItemBool;

  PROCEDURE (i : Item) AddItemInt*(name : ARRAY OF CHAR; value : LONGINT);

  VAR
    item : ValueItem;

  BEGIN
    NEW(item);
    item.Init;
    item.SetInt(name,value);
    i.AddItem(item);
  END AddItemInt;

  PROCEDURE (v : ValueItem) PrintXML*(writer : T.Writer; indent : LONGINT);

  BEGIN
    writer.WriteString(v.name^);
    writer.WriteString("=");
    writer.WriteChar('"');
    writer.WriteString(v.value^);
    writer.WriteChar('"');
  END PrintXML;
END VO:Prefs:Parser.