(**
   Simply draws vertical or horizontal lines. Usefull for visually
   seperating groups of objects.
**)

MODULE VO:Line;

(*
    Implemnets a line.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VO:Base:Display,

       G := VO:Object,
       V := VO:VecImage;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
               END;

  Line*      = POINTER TO LineDesc;
  LineDesc*  = RECORD (G.ObjectDesc)
                 vert  : BOOLEAN;
                 image : V.VecImage;
                 size  : SHORTINT;
               END;

VAR
  prefs : Prefs;

  PROCEDURE (l : Line) Init*;

  BEGIN
    l.Init^;

    l.vert:=FALSE;
    l.size:=100;
    l.image:=NIL;
  END Init;

  (**
    Spezify direction (vertical or horizontal) and the size of the line.
    Size spezifies the size of the line within its bounds in procent. E.g.,
    if you spezify the line will always have half the size of its bounds and
    will be displayed centered.
  **)

  PROCEDURE ( l : Line) Set*(vert : BOOLEAN; size : SHORTINT);

  BEGIN
    l.vert:=vert;
    IF (l.size<=0) OR (l.size>100) THEN
      l.size:=100;
    ELSE
      l.size:=size;
    END;
  END Set;

  PROCEDURE (l : Line) CalcSize*;

  BEGIN
    l.image:=V.CreateVecImage();
    l.image.SetParent(l);
    l.image.SetFlags({G.horizontalFlex,G.verticalFlex});
    IF l.vert THEN
      l.image.Set(V.vLineIn3D);
    ELSE
      l.image.Set(V.hLineIn3D);
    END;
    l.image.CalcSize;
    l.minWidth:=l.image.oWidth;
    l.minHeight:=l.image.oHeight;

    l.CalcSize^;
  END CalcSize;

  PROCEDURE (l : Line) Layout*;

  BEGIN
    IF l.vert THEN
      l.image.Resize(l.width,(l.height*l.size) DIV 100);
    ELSE
      l.image.Resize((l.width*l.size) DIV 100,l.height);
    END;
    l.image.Move(l.x+(l.width-l.image.oWidth) DIV 2,
                 l.y+(l.height-l.image.oHeight) DIV 2);

    l.Layout^;
  END Layout;

  PROCEDURE (l : Line) Draw*(x,y,w,h : LONGINT);

  BEGIN
    l.Draw^(x,y,w,h);

    IF ~l.Intersect(x,y,w,h) THEN
      RETURN;
    END;

    l.image.Draw(x,y,w,h);
  END Draw;

  PROCEDURE (l : Line) Hide*;

  BEGIN
    IF l.visible THEN
      l.image.Hide;
      l.DrawHide;
      l.Hide^;
    END;
  END Hide;

  PROCEDURE CreateLine*():Line;

  VAR
    line : Line;

  BEGIN
    NEW(line);
    line.Init;

    RETURN line;
  END CreateLine;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:Line.