# MySQL dump 8.9
#
# Host: localhost    Database: nss-mysql
#

# 
# This sample SQL dump shows the table structure used by nss-mysql 
# 
# We have defined 2 groups : mail and nss-mysql
#                 4 users : guillaume, linus, alan and delancie.
# guillaume is member of both groups, delancie is a member of nss-mysql.
# All users have the same password: pass
#
# The where clause is user.status = 'A' so Alan s account is not activated.
# This feature is optionnal.
#
# NOTE: that shadow extensions like lastchange,min,max,warn,inact or expire are
# not in that database. It is perfectly legal, look at nss-mysql-root.conf 
# to see how/why.
#
# Table structure for table 'groups'
#

DROP TABLE IF EXISTS groups;

CREATE TABLE groups (
  group_id int(11) NOT NULL auto_increment primary key,
  group_name varchar(30) DEFAULT '' NOT NULL,
  status	char(1) DEFAULT 'A',
  group_password varchar(64) DEFAULT 'x' NOT NULL,
  gid int(11) NOT NULL
);

#
# Dumping data for table 'groups'
#

INSERT INTO groups VALUES (1,'nssmysql','A','x',2001);
INSERT INTO groups VALUES (2,'mail','A','x',2002);
INSERT INTO groups VALUES (3,'users','A','x',500);

#
# Table structure for table 'user'
#
DROP TABLE IF EXISTS user;

CREATE TABLE user (
  user_id int(11) NOT NULL auto_increment primary key,
  user_name varchar(50) DEFAULT '' NOT NULL,
  realname varchar(32) DEFAULT '' NOT NULL,
  shell varchar(20) DEFAULT '/bin/sh' NOT NULL,
  password varchar(40) DEFAULT '' NOT NULL,
  status char(1) DEFAULT 'N' NOT NULL,
  uid int(11) NOT NULL,
  gid int(11) DEFAULT '65534' NOT NULL,
  homedir varchar(32) DEFAULT '/bin/sh' NOT NULL
 );

#
# Dumping data for table 'user'
#

INSERT INTO user VALUES (101,'guillaume','Guillaume Morin','/bin/bash','$1$pp$FiHzni87Pc3CeOaG24jZV/','A',1001,3,'/home/guillaume');
INSERT INTO user VALUES (102,'linus','Linus Torvalds','/bin/bash','$1$pp$FiHzni87Pc3CeOaG24jZV/','A',1002,3,'/home/linus');
INSERT INTO user VALUES (103,'alan','Alan Cox','/usr/bin/tcsh','$1$pp$FiHzni87Pc3CeOaG24jZV/','N',0,3,'/tmp');
INSERT INTO user VALUES (104,'delancie','Steve Brown','/usr/bin/zsh','$1$pp$FiHzni87Pc3CeOaG24jZV/','A',1501,3,'/delancie');


#
# Table structure for table 'user_group'
#
DROP TABLE IF EXISTS user_group;

CREATE TABLE user_group (
  user_id int(11) DEFAULT '0' NOT NULL,
  group_id int(11) DEFAULT '0' NOT NULL
  );

#
# Dumping data for table 'user_group'
#

INSERT INTO user_group VALUES (101,1);
INSERT INTO user_group VALUES (101,2);
INSERT INTO user_group VALUES (104,1);


