#include <sys/stat.h>
#include <string.h>
#include <libnjb.h>
#include <getopt.h>

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data);
void usage(void);

int main(int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	int n, opt, debug;
	extern int optind;
	extern char *optarg;
	char *path;
	int fileid;
	char *lang;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			usage();
		}
	}
	argc-= optind;
	argv+= optind;

	if ( argc != 1 ) usage();

	if ( debug ) NJB_Set_Debug(debug);

	/*
	 * Check environment variables $LANG and $LC_CTYPE
	 * to see if we want to support UTF-8 unicode
	 * $LANG = "xx_XX.UTF-8" or $LC_CTYPE = "?"
	 * trigger unicode support.
	 */
	lang = getenv("LANG");
	if (lang != NULL) {
	  if (strlen(lang) > 5) {
	    if (!strcmp(&lang[strlen(lang)-5], "UTF-8")) {
	       NJB_Set_Unicode(NJB_UC_UTF8);
	    }
	  }
	}

	path= argv[0];

	printf("Sending file:\n");
	printf("Filename:     %s\n", path);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
	}
	if ( n == 0 ) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	NJB_Capture(njb);

	if ( NJB_Send_File(njb, path, NULL, progress, NULL, &fileid) == -1 ) {
		njb_error_dump(stderr);
	} else {
		printf("\nNJB ID:    %u\n", fileid);
	}
	printf("\n");

	NJB_Release(njb);

	NJB_Close (njb);

	return 0;
}

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data)
{
	int percent = (sent*100)/total;
#ifdef __WIN32__
	printf("Progress: %I64u of %I64u (%d%%)\r", sent, total, percent);
#else
	printf("Progress: %llu of %llu (%d%%)\r", sent, total, percent);
#endif
	fflush(stdout);
	return 0;
}

void usage (void)
{
	fprintf(stderr, "usage: sendfile [ -D debuglvl ] <path>\n");
	exit(1);
}
