#!/usr/bin/env python

import sys
import musicbrainz
import pprint

def getbitprint(file): 
    t = musicbrainz.mb()
    return t.CalculateBitprint(file)

def main():
    files = sys.argv[1:]
    pp = pprint.PrettyPrinter(indent=4)
    for file in files:
        pp.pprint(getbitprint(file))

if __name__ == '__main__':
    main()

