package Locales::DB::Language::cs;

# Auto generated from CLDR

$Locales::DB::Language::cs::VERSION = '0.06';

$Locales::DB::Language::cs::cldr_version = '1.7.2';

%Locales::DB::Language::cs::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => undef,
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Jazyk\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "ano\:a"
    },
);

%Locales::DB::Language::cs::code_to_name = (
    'aa'    => 'afarština',
    'ab'    => 'abcházština',
    'ace'   => 'acehština',
    'ach'   => 'ačoli',
    'ada'   => 'adangme',
    'ady'   => 'adygejština',
    'ae'    => "avestský\ jazyk",
    'af'    => 'afrikánština',
    'afa'   => "afroasijské\ jazyky",
    'afh'   => 'afrihili',
    'ain'   => 'ainština',
    'ak'    => 'akan',
    'akk'   => 'akkadština',
    'ale'   => 'aleutština',
    'alg'   => "algonkinské\ jazyky",
    'alt'   => "Southern\ Altai",
    'am'    => 'amharština',
    'an'    => 'aragonština',
    'ang'   => 'staroangličtina',
    'anp'   => 'angika',
    'apa'   => "apačské\ jazyky",
    'ar'    => 'arabština',
    'arc'   => 'aramejština',
    'arn'   => 'araukánština',
    'arp'   => 'arapaho',
    'art'   => "umělé\ jazyky",
    'arw'   => "arawacké\ jazyky",
    'as'    => 'ásámština',
    'ast'   => 'Asturian',
    'ath'   => "athapaskánské\ jazyky",
    'aus'   => "australské\ jazyky",
    'av'    => 'avarština',
    'awa'   => 'awadhština',
    'ay'    => 'ajmarština',
    'az'    => 'ázerbájdžánština',
    'ba'    => 'baskirština',
    'bad'   => 'banda',
    'bai'   => 'bamilek',
    'bal'   => 'balúčština',
    'ban'   => 'balijština',
    'bas'   => 'basa',
    'bat'   => "baltské\ jazyky",
    'be'    => 'běloruština',
    'bej'   => 'bedža',
    'bem'   => 'bembštiva',
    'ber'   => "berberské\ jazyky",
    'bg'    => 'bulharština',
    'bh'    => 'bihárština',
    'bho'   => 'bhódžupurí',
    'bi'    => 'bislama',
    'bik'   => 'bikolština',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambarština',
    'bn'    => 'bengálština',
    'bnt'   => "bantuské\ jazyky",
    'bo'    => 'tibetština',
    'br'    => 'bretonština',
    'bra'   => 'bradžština',
    'bs'    => 'bosenština',
    'btk'   => 'batačtina',
    'bua'   => 'burjatština',
    'bug'   => 'bugiština',
    'byn'   => 'Blin',
    'ca'    => 'katalánština',
    'cad'   => 'caddo',
    'cai'   => "středoamerické\ indiánské\ jazyky",
    'car'   => 'karibština',
    'cau'   => "kavkazské\ jazyky",
    'cch'   => 'Atsam',
    'ce'    => 'čečenština',
    'ceb'   => 'cebuánština',
    'cel'   => "keltské\ jazyky",
    'ch'    => 'čamoro',
    'chb'   => 'čibča',
    'chg'   => 'čagatajština',
    'chk'   => 'čukština',
    'chm'   => 'marijština',
    'chn'   => "činuk\ pidžin",
    'cho'   => 'choctawština',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'čejenština',
    'cmc'   => 'čamština',
    'co'    => 'korsičtina',
    'cop'   => 'koptština',
    'cpe'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ angličtiny",
    'cpf'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ francouzštiny",
    'cpp'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ portugalštiny",
    'cr'    => 'krí',
    'crh'   => "krymská\ tatarština",
    'crp'   => "kreolština\ a\ jiné\ pidginy",
    'cs'    => 'čeština',
    'csb'   => 'Kashubian',
    'cu'    => 'staroslověnština',
    'cus'   => "kúšitské\ jazyky",
    'cv'    => 'čuvašština',
    'cy'    => 'velština',
    'da'    => 'dánština',
    'dak'   => 'dakotština',
    'dar'   => 'Dargwa',
    'day'   => 'dajáčtina',
    'de'    => 'němčina',
    'de_at' => "německy\ \(Rakousko\)",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinkština',
    'doi'   => 'dórgí',
    'dra'   => "drávidské\ jazyky",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'dualština',
    'dum'   => 'středoholandština',
    'dv'    => 'divehi',
    'dyu'   => 'djula',
    'dz'    => 'dzongkä',
    'ee'    => 'eweština',
    'efi'   => 'efik',
    'egy'   => "egyptština\ stará",
    'eka'   => 'ekajuk',
    'el'    => 'řečtina',
    'elx'   => 'elamitština',
    'en'    => 'angličtina',
    'en_au' => "Australian\ English",
    'en_ca' => "anglicky\ \(Kanada\)",
    'en_gb' => "British\ English",
    'en_us' => "angličtina\ \(USA\)",
    'enm'   => 'středoangličtina',
    'eo'    => 'esperanto',
    'es'    => 'španělština',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estonština',
    'eu'    => 'baskičtina',
    'ewo'   => 'ewondo',
    'fa'    => 'perština',
    'fan'   => 'fang',
    'fat'   => 'fantština',
    'ff'    => 'fulahština',
    'fi'    => 'finština',
    'fil'   => 'tagalogština',
    'fiu'   => "ugrofinské\ jazyky",
    'fj'    => 'fidžijština',
    'fo'    => 'faerština',
    'fon'   => 'Fon',
    'fr'    => 'francouzština',
    'fr_ca' => "francouzsky\ \(Kanada\)",
    'fr_ch' => "Swiss\ French",
    'frm'   => 'středofrancouzština',
    'fro'   => 'starofrancouzština',
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'furlandština',
    'fy'    => 'fríština',
    'ga'    => 'irština',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaja',
    'gd'    => "skotská\ gaelština",
    'gem'   => "germánské\ jazyky",
    'gez'   => 'geez',
    'gil'   => 'kiribatština',
    'gl'    => 'haličština',
    'gmh'   => "hornoněmčina\ stará",
    'gn'    => 'guaraní',
    'goh'   => "stará\ hornoněmčina",
    'gon'   => 'góndština',
    'gor'   => 'gorontalo',
    'got'   => 'gótština',
    'grb'   => 'grebo',
    'grc'   => 'starořečtina',
    'gsw'   => "Swiss\ German",
    'gu'    => 'gudžarátština',
    'gv'    => 'manština',
    'gwi'   => 'gwichʼin',
    'ha'    => 'hauština',
    'hai'   => 'haida',
    'haw'   => 'havajština',
    'he'    => 'hebrejština',
    'hi'    => 'hindština',
    'hil'   => 'hiligayonština',
    'him'   => 'himáčalština',
    'hit'   => 'chetitština',
    'hmn'   => 'hmongština',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorvatština',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'maďarština',
    'hup'   => 'hupa',
    'hy'    => 'arménština',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonéština',
    'ie'    => 'interlingue',
    'ig'    => 'igboština',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'idžo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilokánština',
    'inc'   => "indické\ jazyky",
    'ine'   => "indoevropské\ jazyky",
    'inh'   => 'inguština',
    'io'    => 'Ido',
    'ira'   => "íránské\ jazyky",
    'iro'   => "irokézské\ jazyky",
    'is'    => 'islandština',
    'it'    => 'italština',
    'iu'    => 'inuktitut',
    'ja'    => 'japonština',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'javánština',
    'ka'    => 'gruzínština',
    'kaa'   => 'karakalpačtina',
    'kab'   => 'kabylština',
    'kac'   => 'kačijština',
    'kaj'   => 'Jju',
    'kam'   => 'kambština',
    'kar'   => 'karenština',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardinština',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'konžština',
    'kha'   => 'khásí',
    'khi'   => "khoisanské\ jazyky",
    'kho'   => 'chotánština',
    'ki'    => 'kikujština',
    'kj'    => 'kuaňamština',
    'kk'    => 'kazaština',
    'kl'    => 'kalmyčtina',
    'km'    => 'khmerština',
    'kmb'   => 'kimbundština',
    'kn'    => 'kannadština',
    'ko'    => 'korejština',
    'kok'   => 'kónkánština',
    'kos'   => 'kosrajština',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'kru',
    'kru'   => 'krukukhština',
    'ks'    => 'kašmírština',
    'ku'    => 'kurdština',
    'kum'   => 'kumyčtina',
    'kut'   => 'kutenai',
    'kv'    => 'komijština',
    'kw'    => 'kornština',
    'ky'    => 'kyrgyzština',
    'la'    => 'latina',
    'lad'   => 'ladinština',
    'lah'   => 'lahndština',
    'lam'   => 'lambština',
    'lb'    => 'Lucemburština',
    'lez'   => 'lezginština',
    'lg'    => 'ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingalština',
    'lo'    => 'laoština',
    'lol'   => 'mongština',
    'loz'   => 'lozština',
    'lt'    => 'litevština',
    'lu'    => "lubu\-katanžština",
    'lua'   => "luba\-luluaština",
    'lui'   => 'luiseňo',
    'lun'   => 'lundština',
    'luo'   => 'luoština',
    'lus'   => 'lišáí',
    'lv'    => 'lotyština',
    'mad'   => 'madurština',
    'mag'   => 'magahština',
    'mai'   => 'maithilština',
    'mak'   => 'makasarština',
    'man'   => 'mandingština',
    'map'   => "austronéské\ jazyky",
    'mas'   => 'masajština',
    'mdf'   => 'Moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaština',
    'mga'   => 'středoirština',
    'mh'    => 'maršálština',
    'mi'    => 'maorština',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "různé\ jazyky",
    'mk'    => 'makedonština',
    'mkh'   => "mon\-khmerské\ jazyky",
    'ml'    => 'malajálamština',
    'mn'    => 'mongolština',
    'mnc'   => 'mandžuština',
    'mni'   => 'manipurština',
    'mno'   => "manobo\ jazyky",
    'mo'    => 'moldavština',
    'moh'   => 'mohawk',
    'mos'   => 'mosi',
    'mr'    => 'maráthština',
    'ms'    => 'malajština',
    'mt'    => 'maltština',
    'mul'   => "složené\ \(víceřádkové\)\ jazyky",
    'mun'   => "mundské\ jazyky",
    'mus'   => "muskogee\ \(creek\)",
    'mwl'   => 'Mirandese',
    'mwr'   => 'márvárština',
    'my'    => 'barmština',
    'myn'   => "mayské\ jazyky",
    'myv'   => 'Erzya',
    'na'    => 'naurština',
    'nah'   => 'nahuatl',
    'nai'   => "severoamerické\ indiánské\ jazyky",
    'nap'   => 'neapolština',
    'nb'    => "norština\ \(Bokmål\)",
    'nd'    => "ndebele\ \(Zimbabwe\)",
    'nds'   => 'dolnoněmčina',
    'ne'    => 'nepálština',
    'new'   => 'névárština',
    'ng'    => 'ndondština',
    'nia'   => 'nias',
    'nic'   => "nigero\-kordofánské\ jazyky",
    'niu'   => 'niue',
    'nl'    => 'nizozemština',
    'nl_be' => 'Flemish',
    'nn'    => "norština\ \(Nynorsk\)",
    'no'    => 'norština',
    'nog'   => 'Nogai',
    'non'   => "norština\ historická",
    'nqo'   => "N\â\\Ko",
    'nr'    => "ndebele\ \(Jižní\ Afrika\)",
    'nso'   => "severní\ sotho",
    'nub'   => "núbijské\ jazyky",
    'nv'    => 'navažština',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'ňandžština',
    'nym'   => 'ňamwežština',
    'nyn'   => 'nyakolština',
    'nyo'   => 'nyorština',
    'nzi'   => 'nzima',
    'oc'    => 'okcitánština',
    'oj'    => 'odžibvejština',
    'om'    => "oromština\ \(Afan\)",
    'or'    => 'urijština',
    'os'    => 'osetština',
    'osa'   => 'osage',
    'ota'   => "osmanská\ turečtina",
    'oto'   => "otomijské\ jazyky",
    'pa'    => 'paňdžábština',
    'paa'   => "papuánské\ jazyky",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlaví',
    'pam'   => 'papangau',
    'pap'   => 'papiamento',
    'pau'   => 'palauština',
    'peo'   => 'staroperština',
    'phi'   => "filipínské\ jazyky",
    'phn'   => 'féničtina',
    'pi'    => 'pálí',
    'pl'    => 'polština',
    'pon'   => 'pohnpeiština',
    'pra'   => 'prákrty',
    'pro'   => 'provensálština',
    'ps'    => 'paštština',
    'pt'    => 'portugalština',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'kečuánština',
    'raj'   => 'rádžastánština',
    'rap'   => 'rapanuiština',
    'rar'   => 'rarotongaština',
    'rm'    => 'rétorománština',
    'rn'    => 'rundština',
    'ro'    => 'rumunština',
    'roa'   => "románské\ jazyky",
    'rom'   => 'romština',
    'ru'    => 'ruština',
    'rup'   => 'Aromanian',
    'rw'    => 'rwandština',
    'sa'    => 'sanskrt',
    'sad'   => 'sandawština',
    'sah'   => 'jakutština',
    'sai'   => "jihoamerické\ indiánské\ jazyky",
    'sal'   => "salishské\ jazyky",
    'sam'   => 'samarština',
    'sas'   => 'sasakština',
    'sat'   => 'santálí',
    'sc'    => 'sardština',
    'scn'   => 'Sicilian',
    'sco'   => 'skotština',
    'sd'    => 'sindhština',
    'se'    => "Northern\ Sami",
    'sel'   => 'selkupština',
    'sem'   => "semitské\ jazyky",
    'sg'    => 'sangho',
    'sga'   => 'staroirština',
    'sgn'   => "znakové\ jazyky",
    'sh'    => 'srbochorvatština',
    'shn'   => 'šanština',
    'si'    => 'sinhálština',
    'sid'   => 'sidamo',
    'sio'   => "siouxské\ jazyky",
    'sit'   => "tibetočínské\ jazyky",
    'sk'    => 'slovenština',
    'sl'    => 'slovinština',
    'sla'   => "slovanské\ jazyky",
    'sm'    => 'samojština',
    'sma'   => "Southern\ Sami",
    'smi'   => "sami\ jazyky",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'šonština',
    'snk'   => 'sonikština',
    'so'    => 'somálština',
    'sog'   => 'sogdština',
    'son'   => 'songhajština',
    'sq'    => 'albánština',
    'sr'    => 'srbština',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'serer',
    'ss'    => 'swatština',
    'ssa'   => "nilo\-saharské\ jazyky",
    'st'    => "sotho\ jižní",
    'su'    => 'sundština',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerština',
    'sv'    => 'švédština',
    'sw'    => 'svahilština',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'syrština',
    'ta'    => 'tamilština',
    'tai'   => "thajské\ jazyky",
    'te'    => 'telugština',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetumština',
    'tg'    => 'tádžičtina',
    'th'    => 'thajština',
    'ti'    => 'tigriňa',
    'tig'   => 'tigrejština',
    'tiv'   => 'tivština',
    'tk'    => 'turkmenština',
    'tkl'   => 'tokelauština',
    'tl'    => 'tagalština',
    'tlh'   => 'klingonština',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tswandština',
    'to'    => 'tongština',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turečtina',
    'trv'   => 'Taroko',
    'ts'    => 'tsongština',
    'tsi'   => "tsimshijské\ jazyky",
    'tt'    => 'tatarština',
    'tum'   => 'tumbukština',
    'tup'   => "Tupi\ Language",
    'tut'   => "altajské\ jazyky",
    'tvl'   => 'tuvalština',
    'tw'    => 'twi',
    'ty'    => 'tahitština',
    'tyv'   => 'tuvinština',
    'udm'   => 'udmurtština',
    'ug'    => 'ujgurština',
    'uga'   => 'ugaritština',
    'uk'    => 'ukrajinština',
    'umb'   => 'umbundu',
    'und'   => 'nevymezené',
    'ur'    => 'urdština',
    'uz'    => 'uzbečtina',
    'vai'   => 'vai',
    've'    => 'vendština',
    'vi'    => 'vietnamština',
    'vo'    => 'volapük',
    'vot'   => 'votiatština',
    'wa'    => 'valonština',
    'wak'   => "wakashské\ jazyky",
    'wal'   => 'walamština',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "lužickosrbské\ jazyky",
    'wo'    => 'wolofština',
    'xal'   => 'kalmyčtina',
    'xh'    => 'xhosština',
    'yao'   => 'jaoština',
    'yap'   => 'yapese',
    'yi'    => 'jidiš',
    'yo'    => 'jorubština',
    'ypk'   => 'yupik',
    'za'    => 'čuangština',
    'zap'   => 'zapotéčtina',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'čínština',
    'znd'   => 'zandština',
    'zu'    => 'zuluština',
    'zun'   => 'zunijština',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::cs::name_to_code = (
    'abcházština'                                     => 'ab',
    'acehština'                                        => 'ace',
    'adangme'                                           => 'ada',
    'adygejština'                                      => 'ady',
    'afarština'                                        => 'aa',
    'afrihili'                                          => 'afh',
    'afrikánština'                                    => 'af',
    'afroasijskéjazyky'                                => 'afa',
    'ainština'                                         => 'ain',
    'ajmarština'                                       => 'ay',
    'akan'                                              => 'ak',
    'akkadština'                                       => 'akk',
    'albánština'                                      => 'sq',
    'aleutština'                                       => 'ale',
    'algonkinskéjazyky'                                => 'alg',
    'altajskéjazyky'                                   => 'tut',
    'amharština'                                       => 'am',
    'angika'                                            => 'anp',
    'anglickykanada'                                    => 'en_ca',
    'angličtina'                                       => 'en',
    'angličtinausa'                                    => 'en_us',
    'apačskéjazyky'                                   => 'apa',
    'arabština'                                        => 'ar',
    'aragonština'                                      => 'an',
    'aramejština'                                      => 'arc',
    'arapaho'                                           => 'arp',
    'araukánština'                                    => 'arn',
    'arawackéjazyky'                                   => 'arw',
    'arménština'                                      => 'hy',
    'aromanian'                                         => 'rup',
    'asturian'                                          => 'ast',
    'athapaskánskéjazyky'                             => 'ath',
    'atsam'                                             => 'cch',
    'australianenglish'                                 => 'en_au',
    'australskéjazyky'                                 => 'aus',
    'austronéskéjazyky'                               => 'map',
    'avarština'                                        => 'av',
    'avestskýjazyk'                                    => 'ae',
    'awadhština'                                       => 'awa',
    'ačoli'                                            => 'ach',
    'balijština'                                       => 'ban',
    'baltskéjazyky'                                    => 'bat',
    'balúčština'                                     => 'bal',
    'bambarština'                                      => 'bm',
    'bamilek'                                           => 'bai',
    'banda'                                             => 'bad',
    'bantuskéjazyky'                                   => 'bnt',
    'barmština'                                        => 'my',
    'basa'                                              => 'bas',
    'baskirština'                                      => 'ba',
    'baskičtina'                                       => 'eu',
    'batačtina'                                        => 'btk',
    'bedža'                                            => 'bej',
    'bembštiva'                                        => 'bem',
    'bengálština'                                     => 'bn',
    'berberskéjazyky'                                  => 'ber',
    'bhódžupurí'                                     => 'bho',
    'bihárština'                                      => 'bh',
    'bikolština'                                       => 'bik',
    'bini'                                              => 'bin',
    'bislama'                                           => 'bi',
    'blin'                                              => 'byn',
    'blissymbols'                                       => 'zbl',
    'bosenština'                                       => 'bs',
    'bradžština'                                      => 'bra',
    'brazilianportuguese'                               => 'pt_br',
    'bretonština'                                      => 'br',
    'britishenglish'                                    => 'en_gb',
    'bugiština'                                        => 'bug',
    'bulharština'                                      => 'bg',
    'burjatština'                                      => 'bua',
    'běloruština'                                     => 'be',
    'caddo'                                             => 'cad',
    'cebuánština'                                     => 'ceb',
    'cherokee'                                          => 'chr',
    'chetitština'                                      => 'hit',
    'chipewyan'                                         => 'chp',
    'choctawština'                                     => 'cho',
    'chorvatština'                                     => 'hr',
    'chotánština'                                     => 'kho',
    'classicalnewari'                                   => 'nwc',
    'classicalsyriac'                                   => 'syc',
    'dajáčtina'                                       => 'day',
    'dakotština'                                       => 'dak',
    'dargwa'                                            => 'dar',
    'delaware'                                          => 'del',
    'dinkština'                                        => 'din',
    'divehi'                                            => 'dv',
    'djula'                                             => 'dyu',
    'dogrib'                                            => 'dgr',
    'dolnoněmčina'                                    => 'nds',
    'drávidskéjazyky'                                 => 'dra',
    'dualština'                                        => 'dua',
    'dzongkä'                                          => 'dz',
    'dánština'                                        => 'da',
    'dórgí'                                           => 'doi',
    'easternfrisian'                                    => 'frs',
    'efik'                                              => 'efi',
    'egyptštinastará'                                 => 'egy',
    'ekajuk'                                            => 'eka',
    'elamitština'                                      => 'elx',
    'erzya'                                             => 'myv',
    'esperanto'                                         => 'eo',
    'estonština'                                       => 'et',
    'eweština'                                         => 'ee',
    'ewondo'                                            => 'ewo',
    'faerština'                                        => 'fo',
    'fang'                                              => 'fan',
    'fantština'                                        => 'fat',
    'fidžijština'                                     => 'fj',
    'filipínskéjazyky'                                => 'phi',
    'finština'                                         => 'fi',
    'flemish'                                           => 'nl_be',
    'fon'                                               => 'fon',
    'francouzskykanada'                                 => 'fr_ca',
    'francouzština'                                    => 'fr',
    'fríština'                                        => 'fy',
    'fulahština'                                       => 'ff',
    'furlandština'                                     => 'fur',
    'féničtina'                                       => 'phn',
    'ga'                                                => 'gaa',
    'ganda'                                             => 'lg',
    'gayo'                                              => 'gay',
    'gbaja'                                             => 'gba',
    'geez'                                              => 'gez',
    'germánskéjazyky'                                 => 'gem',
    'gorontalo'                                         => 'gor',
    'grebo'                                             => 'grb',
    'gruzínština'                                     => 'ka',
    'guaraní'                                          => 'gn',
    'gudžarátština'                                  => 'gu',
    'gwichʼin'                                         => 'gwi',
    'góndština'                                       => 'gon',
    'gótština'                                        => 'got',
    'haida'                                             => 'hai',
    'haitian'                                           => 'ht',
    'haličština'                                      => 'gl',
    'hauština'                                         => 'ha',
    'havajština'                                       => 'haw',
    'hebrejština'                                      => 'he',
    'herero'                                            => 'hz',
    'hiligayonština'                                   => 'hil',
    'himáčalština'                                   => 'him',
    'hindština'                                        => 'hi',
    'hirimotu'                                          => 'ho',
    'hmongština'                                       => 'hmn',
    'hornoněmčinastará'                              => 'gmh',
    'hupa'                                              => 'hup',
    'iban'                                              => 'iba',
    'iberianportuguese'                                 => 'pt_pt',
    'iberianspanish'                                    => 'es_es',
    'ido'                                               => 'io',
    'idžo'                                             => 'ijo',
    'igboština'                                        => 'ig',
    'ilokánština'                                     => 'ilo',
    'inarisami'                                         => 'smn',
    'indickéjazyky'                                    => 'inc',
    'indoevropskéjazyky'                               => 'ine',
    'indonéština'                                     => 'id',
    'inguština'                                        => 'inh',
    'interlingua'                                       => 'ia',
    'interlingue'                                       => 'ie',
    'inuktitut'                                         => 'iu',
    'inupiaq'                                           => 'ik',
    'irokézskéjazyky'                                 => 'iro',
    'irština'                                          => 'ga',
    'islandština'                                      => 'is',
    'italština'                                        => 'it',
    'jakutština'                                       => 'sah',
    'jaoština'                                         => 'yao',
    'japonština'                                       => 'ja',
    'javánština'                                      => 'jv',
    'jidiš'                                            => 'yi',
    'jihoamerickéindiánskéjazyky'                    => 'sai',
    'jju'                                               => 'kaj',
    'jorubština'                                       => 'yo',
    'judeoarabic'                                       => 'jrb',
    'judeopersian'                                      => 'jpr',
    'kabardinština'                                    => 'kbd',
    'kabylština'                                       => 'kab',
    'kalmyčtina'                                       => 'xal',
    'kambština'                                        => 'kam',
    'kannadština'                                      => 'kn',
    'kanuri'                                            => 'kr',
    'karachaybalkar'                                    => 'krc',
    'karakalpačtina'                                   => 'kaa',
    'karelian'                                          => 'krl',
    'karenština'                                       => 'kar',
    'karibština'                                       => 'car',
    'kashubian'                                         => 'csb',
    'katalánština'                                    => 'ca',
    'kavkazskéjazyky'                                  => 'cau',
    'kawi'                                              => 'kaw',
    'kazaština'                                        => 'kk',
    'kačijština'                                      => 'kac',
    'kašmírština'                                    => 'ks',
    'keltskéjazyky'                                    => 'cel',
    'kečuánština'                                    => 'qu',
    'khmerština'                                       => 'km',
    'khoisanskéjazyky'                                 => 'khi',
    'khásí'                                           => 'kha',
    'kikujština'                                       => 'ki',
    'kimbundština'                                     => 'kmb',
    'kiribatština'                                     => 'gil',
    'klingonština'                                     => 'tlh',
    'komijština'                                       => 'kv',
    'konžština'                                       => 'kg',
    'koptština'                                        => 'cop',
    'korejština'                                       => 'ko',
    'kornština'                                        => 'kw',
    'koro'                                              => 'kfo',
    'korsičtina'                                       => 'co',
    'kosrajština'                                      => 'kos',
    'kpelle'                                            => 'kpe',
    'kreolštinaajinépidginy'                          => 'crp',
    'kreolštinaajinépidginynazákladěangličtiny'    => 'cpe',
    'kreolštinaajinépidginynazákladěfrancouzštiny' => 'cpf',
    'kreolštinaajinépidginynazákladěportugalštiny' => 'cpp',
    'kru'                                               => 'kro',
    'krukukhština'                                     => 'kru',
    'krymskátatarština'                               => 'crh',
    'krí'                                              => 'cr',
    'kuaňamština'                                     => 'kj',
    'kumyčtina'                                        => 'kum',
    'kurdština'                                        => 'ku',
    'kutenai'                                           => 'kut',
    'kyrgyzština'                                      => 'ky',
    'kónkánština'                                    => 'kok',
    'kúšitskéjazyky'                                 => 'cus',
    'ladinština'                                       => 'lad',
    'lahndština'                                       => 'lah',
    'lambština'                                        => 'lam',
    'laoština'                                         => 'lo',
    'latina'                                            => 'la',
    'lezginština'                                      => 'lez',
    'limburgish'                                        => 'li',
    'lingalština'                                      => 'ln',
    'litevština'                                       => 'lt',
    'lišáí'                                          => 'lus',
    'lojban'                                            => 'jbo',
    'lotyština'                                        => 'lv',
    'lowersorbian'                                      => 'dsb',
    'lozština'                                         => 'loz',
    'lubaluluaština'                                   => 'lua',
    'lubukatanžština'                                 => 'lu',
    'lucemburština'                                    => 'lb',
    'luiseňo'                                          => 'lui',
    'lulesami'                                          => 'smj',
    'lundština'                                        => 'lun',
    'luoština'                                         => 'luo',
    'lužickosrbskéjazyky'                             => 'wen',
    'madurština'                                       => 'mad',
    'magahština'                                       => 'mag',
    'maithilština'                                     => 'mai',
    'makasarština'                                     => 'mak',
    'makedonština'                                     => 'mk',
    'malajálamština'                                  => 'ml',
    'malajština'                                       => 'ms',
    'malgaština'                                       => 'mg',
    'maltština'                                        => 'mt',
    'mandar'                                            => 'mdr',
    'mandingština'                                     => 'man',
    'mandžuština'                                     => 'mnc',
    'manipurština'                                     => 'mni',
    'manobojazyky'                                      => 'mno',
    'manština'                                         => 'gv',
    'maorština'                                        => 'mi',
    'marijština'                                       => 'chm',
    'maráthština'                                     => 'mr',
    'maršálština'                                    => 'mh',
    'masajština'                                       => 'mas',
    'mayskéjazyky'                                     => 'myn',
    'maďarština'                                      => 'hu',
    'mende'                                             => 'men',
    'micmac'                                            => 'mic',
    'minangkabau'                                       => 'min',
    'mirandese'                                         => 'mwl',
    'mohawk'                                            => 'moh',
    'moksha'                                            => 'mdf',
    'moldavština'                                      => 'mo',
    'mongolština'                                      => 'mn',
    'mongština'                                        => 'lol',
    'monkhmerskéjazyky'                                => 'mkh',
    'morisyen'                                          => 'mfe',
    'mosi'                                              => 'mos',
    'mundskéjazyky'                                    => 'mun',
    'muskogeecreek'                                     => 'mus',
    'márvárština'                                    => 'mwr',
    'nahuatl'                                           => 'nah',
    'naurština'                                        => 'na',
    'navažština'                                      => 'nv',
    'ndebelejižníafrika'                              => 'nr',
    'ndebelezimbabwe'                                   => 'nd',
    'ndondština'                                       => 'ng',
    'neapolština'                                      => 'nap',
    'nepálština'                                      => 'ne',
    'nevymezené'                                       => 'und',
    'nias'                                              => 'nia',
    'nigerokordofánskéjazyky'                         => 'nic',
    'nilosaharskéjazyky'                               => 'ssa',
    'niue'                                              => 'niu',
    'nizozemština'                                     => 'nl',
    'nogai'                                             => 'nog',
    'nolinguisticcontent'                               => 'zxx',
    'northernfrisian'                                   => 'frr',
    'northernsami'                                      => 'se',
    'norština'                                         => 'no',
    'norštinabokmål'                                  => 'nb',
    'norštinahistorická'                              => 'non',
    'norštinanynorsk'                                  => 'nn',
    'nyakolština'                                      => 'nyn',
    'nyasatonga'                                        => 'tog',
    'nyorština'                                        => 'nyo',
    'nzima'                                             => 'nzi',
    "n\â\\ko"                                      => 'nqo',
    'névárština'                                     => 'new',
    'núbijskéjazyky'                                  => 'nub',
    'německyrakousko'                                  => 'de_at',
    'němčina'                                         => 'de',
    'odžibvejština'                                   => 'oj',
    'okcitánština'                                    => 'oc',
    'oromštinaafan'                                    => 'om',
    'osage'                                             => 'osa',
    'osetština'                                        => 'os',
    'osmanskáturečtina'                               => 'ota',
    'otomijskéjazyky'                                  => 'oto',
    'pahlaví'                                          => 'pal',
    'palauština'                                       => 'pau',
    'pangasinan'                                        => 'pag',
    'papangau'                                          => 'pam',
    'papiamento'                                        => 'pap',
    'papuánskéjazyky'                                 => 'paa',
    'paňdžábština'                                  => 'pa',
    'paštština'                                       => 'ps',
    'perština'                                         => 'fa',
    'pohnpeiština'                                     => 'pon',
    'polština'                                         => 'pl',
    'portugalština'                                    => 'pt',
    'provensálština'                                  => 'pro',
    'prákrty'                                          => 'pra',
    'pálí'                                            => 'pi',
    'rapanuiština'                                     => 'rap',
    'rarotongaština'                                   => 'rar',
    'románskéjazyky'                                  => 'roa',
    'romština'                                         => 'rom',
    'rumunština'                                       => 'ro',
    'rundština'                                        => 'rn',
    'ruština'                                          => 'ru',
    'rwandština'                                       => 'rw',
    'rádžastánština'                                => 'raj',
    'rétorománština'                                 => 'rm',
    'různéjazyky'                                     => 'mis',
    'salishskéjazyky'                                  => 'sal',
    'samarština'                                       => 'sam',
    'samijazyky'                                        => 'smi',
    'samojština'                                       => 'sm',
    'sandawština'                                      => 'sad',
    'sangho'                                            => 'sg',
    'sanskrt'                                           => 'sa',
    'santálí'                                         => 'sat',
    'sardština'                                        => 'sc',
    'sasakština'                                       => 'sas',
    'selkupština'                                      => 'sel',
    'semitskéjazyky'                                   => 'sem',
    'serer'                                             => 'srr',
    'severnísotho'                                     => 'nso',
    'severoamerickéindiánskéjazyky'                  => 'nai',
    'sichuanyi'                                         => 'ii',
    'sicilian'                                          => 'scn',
    'sidamo'                                            => 'sid',
    'siksika'                                           => 'bla',
    'sindhština'                                       => 'sd',
    'sinhálština'                                     => 'si',
    'siouxskéjazyky'                                   => 'sio',
    'skoltsami'                                         => 'sms',
    'skotskágaelština'                                => 'gd',
    'skotština'                                        => 'sco',
    'slave'                                             => 'den',
    'slovanskéjazyky'                                  => 'sla',
    'slovenština'                                      => 'sk',
    'slovinština'                                      => 'sl',
    'složenévíceřádkovéjazyky'                    => 'mul',
    'sogdština'                                        => 'sog',
    'somálština'                                      => 'so',
    'songhajština'                                     => 'son',
    'sonikština'                                       => 'snk',
    'sothojižní'                                      => 'st',
    'southernaltai'                                     => 'alt',
    'southernsami'                                      => 'sma',
    'sranantongo'                                       => 'srn',
    'srbochorvatština'                                 => 'sh',
    'srbština'                                         => 'sr',
    'staroangličtina'                                  => 'ang',
    'starofrancouzština'                               => 'fro',
    'staroirština'                                     => 'sga',
    'staroperština'                                    => 'peo',
    'staroslověnština'                                => 'cu',
    'starořečtina'                                    => 'grc',
    'staráhornoněmčina'                              => 'goh',
    'středoamerickéindiánskéjazyky'                 => 'cai',
    'středoangličtina'                                => 'enm',
    'středofrancouzština'                             => 'frm',
    'středoholandština'                               => 'dum',
    'středoirština'                                   => 'mga',
    'sukuma'                                            => 'suk',
    'sumerština'                                       => 'sux',
    'sundština'                                        => 'su',
    'susu'                                              => 'sus',
    'svahilština'                                      => 'sw',
    'swatština'                                        => 'ss',
    'swissfrench'                                       => 'fr_ch',
    'swissgerman'                                       => 'gsw',
    'swisshighgerman'                                   => 'de_ch',
    'syrština'                                         => 'syr',
    'tagalogština'                                     => 'fil',
    'tagalština'                                       => 'tl',
    'tahitština'                                       => 'ty',
    'tamašek'                                          => 'tmh',
    'tamilština'                                       => 'ta',
    'taroko'                                            => 'trv',
    'tatarština'                                       => 'tt',
    'telugština'                                       => 'te',
    'temne'                                             => 'tem',
    'tereno'                                            => 'ter',
    'tetumština'                                       => 'tet',
    'thajskéjazyky'                                    => 'tai',
    'thajština'                                        => 'th',
    'tibetočínskéjazyky'                             => 'sit',
    'tibetština'                                       => 'bo',
    'tigrejština'                                      => 'tig',
    'tigriňa'                                          => 'ti',
    'tivština'                                         => 'tiv',
    'tlingit'                                           => 'tli',
    'tokelauština'                                     => 'tkl',
    'tokpisin'                                          => 'tpi',
    'tongština'                                        => 'to',
    'tsimshijskéjazyky'                                => 'tsi',
    'tsongština'                                       => 'ts',
    'tswandština'                                      => 'tn',
    'tumbukština'                                      => 'tum',
    'tupilanguage'                                      => 'tup',
    'turečtina'                                        => 'tr',
    'turkmenština'                                     => 'tk',
    'tuvalština'                                       => 'tvl',
    'tuvinština'                                       => 'tyv',
    'twi'                                               => 'tw',
    'tyap'                                              => 'kcg',
    'tádžičtina'                                     => 'tg',
    'udmurtština'                                      => 'udm',
    'ugaritština'                                      => 'uga',
    'ugrofinskéjazyky'                                 => 'fiu',
    'ujgurština'                                       => 'ug',
    'ukrajinština'                                     => 'uk',
    'umbundu'                                           => 'umb',
    'uměléjazyky'                                     => 'art',
    'uppersorbian'                                      => 'hsb',
    'urdština'                                         => 'ur',
    'urijština'                                        => 'or',
    'uzbečtina'                                        => 'uz',
    'vai'                                               => 'vai',
    'valonština'                                       => 'wa',
    'velština'                                         => 'cy',
    'vendština'                                        => 've',
    'vietnamština'                                     => 'vi',
    'volapük'                                          => 'vo',
    'votiatština'                                      => 'vot',
    'wakashskéjazyky'                                  => 'wak',
    'walamština'                                       => 'wal',
    'waray'                                             => 'war',
    'washo'                                             => 'was',
    'wolofština'                                       => 'wo',
    'xhosština'                                        => 'xh',
    'yapese'                                            => 'yap',
    'yupik'                                             => 'ypk',
    'zandština'                                        => 'znd',
    'zapotéčtina'                                     => 'zap',
    'zaza'                                              => 'zza',
    'zenaga'                                            => 'zen',
    'znakovéjazyky'                                    => 'sgn',
    'zuluština'                                        => 'zu',
    'zunijština'                                       => 'zun',
    'ásámština'                                      => 'as',
    'ázerbájdžánština'                             => 'az',
    'íránskéjazyky'                                  => 'ira',
    'čagatajština'                                    => 'chg',
    'čamoro'                                           => 'ch',
    'čamština'                                        => 'cmc',
    'čejenština'                                      => 'chy',
    'čečenština'                                     => 'ce',
    'čeština'                                         => 'cs',
    'čibča'                                           => 'chb',
    'činukpidžin'                                     => 'chn',
    'čuangština'                                      => 'za',
    'čukština'                                        => 'chk',
    'čuvašština'                                     => 'cv',
    'čínština'                                       => 'zh',
    'ňamwežština'                                    => 'nym',
    'ňandžština'                                     => 'ny',
    'řečtina'                                         => 'el',
    'šanština'                                        => 'shn',
    'šonština'                                        => 'sn',
    'španělština'                                    => 'es',
    'švédština'                                      => 'sv',
);

1;
