/***************************************************************************
 *   Copyright (C) 2005 by Joris Guisson                                   *
 *   joris.guisson@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/
#ifndef BTUTPEX_H
#define BTUTPEX_H
		
#include <map>
#include <ktorrent_export.h>
#include <net/address.h>
#include <util/constants.h>
#include <peer/peermanager.h>
#include "peerprotocolextension.h"

namespace bt
{
	class Peer;
	class BEncoder;

	/**
	 * @author Joris Guisson <joris.guisson@gmail.com>
	 * 
	 * Class which handles µTorrent's peer exchange
	*/
	class KTORRENT_EXPORT UTPex : public PeerProtocolExtension, public PeerManager::PeerVisitor
	{
	public:
		UTPex(Peer* peer,Uint32 id);
		virtual ~UTPex();

		/**
		 * Handle a PEX packet
		 * @param packet The packet 
		 * @param size The size of the packet
		 */
		void handlePacket(const Uint8* packet,Uint32 size);
		
		/// Do we need to update PEX (should happen every minute)
		bool needsUpdate() const;
		
		/// Send a new PEX packet to the Peer
		void update();
		
		/// Change the ID used in the extended packets
		void changeID(Uint32 nid) {id = nid;}
		
		/// Globally disable or enabled PEX
		static void setEnabled(bool on) {pex_enabled = on;}
		
		/// Is PEX enabled globally
		static bool isEnabled() {return pex_enabled;}
	private:
		void encode(BEncoder & enc,const std::map<Uint32,net::Address> & ps);
		void encodeFlags(BEncoder & enc,const std::map<Uint32,Uint8> & flags);
		virtual void visit(const bt::Peer* p);
		
	private:
		std::map<Uint32,net::Address> peers; 
		TimeStamp last_updated;
		static bool pex_enabled;
		
		std::map<Uint32,net::Address> added;
		std::map<Uint32,Uint8> flags;
		std::map<Uint32,net::Address> npeers;
	};

}

#endif
