/*
 * libjingle
 * Copyright 2004--2005, Google Inc.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TALK_BASE_HTTPCOMMON_INL_H__
#define TALK_BASE_HTTPCOMMON_INL_H__

#include "talk/base/common.h"
#include "talk/base/httpcommon.h"

namespace cricket {

///////////////////////////////////////////////////////////////////////////////
// Url
///////////////////////////////////////////////////////////////////////////////

template<class CTYPE>
Url<CTYPE>::Url(const CTYPE* url) : m_port(HTTP_DEFAULT_PORT) {
  if (ascnicmp(url, "http://", 7) == 0) {
    url += 7;
    m_secure = false;
  } else if (ascnicmp(url, "https://", 8) == 0) {
    url += 8;
    m_secure = true;
  } else {
    return;
  }
  const CTYPE* colon = ::strchr(url, static_cast<CTYPE>(':'));
  const CTYPE* slash = ::strchr(url, static_cast<CTYPE>('/'));
  if (!colon && !slash) {
    m_server.assign(url);
    m_path.append(1, static_cast<CTYPE>('/'));
  } else {
    const CTYPE* ptr;
    if (colon == 0) {
      ptr = slash;
    } else if (slash == 0) {
      ptr = colon;
    } else {
      ptr = _min(colon, slash);
    }
    m_server.assign(url, ptr - url);
    if (ptr == colon) {
      CTYPE* tmp = 0;
      m_port = static_cast<uint16>(::strtoul(ptr + 1, &tmp, 10));
      ptr = tmp;
    }
    m_path.assign(ptr);
  }
  ASSERT(m_path.empty() || (m_path[0] == static_cast<CTYPE>('/')));
}

template<class CTYPE>
const CTYPE* Url<CTYPE>::url(CTYPE* buffer, size_t len) {
  size_t pos = asccpyn(buffer, len,
                       m_secure ? "https://" : "http://");
  pos += strcpyn(buffer + pos, len - pos, m_server.data(),
                 m_server.size());
  if (m_port != HTTP_DEFAULT_PORT) {
    CTYPE format[5];
    asccpyn(format, 5, ":%hu");
    pos += sprintfn(buffer + pos, len - pos, format, m_port);
  }
  pos += strcpyn(buffer + pos, len - pos, m_path.data(),
                          m_path.size());
  return buffer;
}

///////////////////////////////////////////////////////////////////////////////

}  // namespace cricket

#endif  // TALK_BASE_HTTPCOMMON_INL_H__
