/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;

public class SQLServerPreparedStatement
extends SQLServerStatement
implements PreparedStatement {
    private static final int BATCH_STATEMENT_DELIMITER_TDS_71 = 128;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_72 = 255;
    final int nBatchStatementDelimiter;
    private String sqlCommand;
    private String preparedTypeDefinitions;
    private String preparedSQL;
    final boolean bReturnValueSyntax;
    int outParamIndexAdjustment;
    ArrayList batchParamValues;
    private int prepStmtHandle;
    private boolean expectPrepStmtHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    final String getPreparedSQL() {
        return this.preparedSQL;
    }

    SQLServerPreparedStatement(SQLServerConnection sQLServerConnection, String string, int n, int n2) throws SQLServerException {
        super(sQLServerConnection, n, n2);
        this.nBatchStatementDelimiter = this.connection.isYukonOrLater() ? 255 : 128;
        this.prepStmtHandle = 0;
        this.expectPrepStmtHandle = false;
        this.sendStringParametersAsUnicode = sQLServerConnection.sendStringParametersAsUnicode();
        this.sqlCommand = string;
        JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
        string = jDBCCallSyntaxTranslator.translate(string);
        this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
        this.bReturnValueSyntax = jDBCCallSyntaxTranslator.hasReturnValueSyntax();
        this.userSQL = string;
        this.initParams(this.userSQL);
    }

    private void closePreparedHandle() throws SQLServerException {
        if (this.connection.isClosed()) {
            return;
        }
        final class PreparedHandleClose
        extends UninterruptableTDSCommand {
            static final /* synthetic */ boolean $assertionsDisabled;

            PreparedHandleClose() {
                super("closePreparedHandle");
            }

            final boolean doExecute() throws SQLServerException {
                if (!$assertionsDisabled && 0 == SQLServerPreparedStatement.this.prepStmtHandle) {
                    throw new AssertionError();
                }
                TDSWriter tDSWriter = this.startRequest((byte)3);
                tDSWriter.writeShort((short)-1);
                tDSWriter.writeShort(SQLServerPreparedStatement.this.isServerSideCursor ? (short)6 : 15);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeRPCInt(null, new Integer(SQLServerPreparedStatement.this.prepStmtHandle), false);
                SQLServerPreparedStatement.this.prepStmtHandle = 0;
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }

            static {
                $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$SQLServerPreparedStatement == null ? (class$com$microsoft$sqlserver$jdbc$SQLServerPreparedStatement = SQLServerPreparedStatement.class$("com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement")) : class$com$microsoft$sqlserver$jdbc$SQLServerPreparedStatement).desiredAssertionStatus();
            }
        }
        this.executeCommand(new PreparedHandleClose());
    }

    public void close() throws SQLServerException {
        block5: {
            if (this.bIsClosed || this.connection.isClosed()) {
                return;
            }
            super.close();
            this.batchParamValues = null;
            if (0 != this.prepStmtHandle) {
                if (this.getStatementLogger().isLoggable(Level.FINE)) {
                    this.getStatementLogger().fine(this.toLogString() + ": Closing PreparedHandle:" + this.prepStmtHandle);
                }
                try {
                    this.closePreparedHandle();
                }
                catch (SQLServerException sQLServerException) {
                    if (!this.getStatementLogger().isLoggable(Level.WARNING)) break block5;
                    this.getStatementLogger().log(Level.WARNING, this.toLogString() + ": Error (ignored) closing PreparedHandle:" + this.prepStmtHandle, sQLServerException);
                }
            }
        }
    }

    final void initParams(String string) {
        int n = 0;
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = ParameterUtils.scanSQLForChar('?', string, n2)) >= string.length()) break;
            ++n;
        }
        this.inOutParam = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            this.inOutParam[i] = new Parameter();
        }
    }

    public final void clearParameters() throws SQLServerException {
        this.checkClosed();
        if (this.inOutParam == null) {
            return;
        }
        for (int i = 0; i < this.inOutParam.length; ++i) {
            this.inOutParam[i].clearInputValue();
        }
    }

    private final boolean buildPreparedStrings(Parameter[] parameterArray) throws SQLServerException {
        String string = this.buildParamTypeDefinitions(parameterArray);
        if (null != this.preparedTypeDefinitions && string.equals(this.preparedTypeDefinitions)) {
            return false;
        }
        this.preparedTypeDefinitions = string;
        this.preparedSQL = this.connection.replaceParameterMarkers(this.userSQL, parameterArray, this.bReturnValueSyntax);
        if (this.bRequestedGeneratedKeys) {
            this.preparedSQL = this.preparedSQL + " select SCOPE_IDENTITY() AS GENERATED_KEYS";
        }
        return true;
    }

    private String buildParamTypeDefinitions(Parameter[] parameterArray) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parameterArray.length;
        char[] cArray = new char[10];
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            int n2 = SQLServerConnection.makeParamName(i, cArray, 0);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append(' ');
            String string = parameterArray[i].getTypeDefinition(this.connection, this.tdsReader);
            if (null == string) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            stringBuffer.append(string);
            if (!parameterArray[i].isOutput()) continue;
            stringBuffer.append(" OUTPUT");
        }
        return stringBuffer.toString();
    }

    public ResultSet executeQuery() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 1));
        return this.resultSet;
    }

    final ResultSet executeQueryInternal() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 5));
        return this.resultSet;
    }

    public int executeUpdate() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 2));
        return this.updateCount;
    }

    public boolean execute() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 3));
        return null != this.resultSet;
    }

    final void doExecutePreparedStatement(PrepStmtExecCmd prepStmtExecCmd) throws SQLServerException {
        this.resetForReexecute();
        if (2 != this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        }
        if (2 == this.executeMethod) {
            this.isServerSideCursor = false;
        }
        TDSWriter tDSWriter = prepStmtExecCmd.startRequest((byte)3);
        this.doPrepExec(tDSWriter, this.inOutParam);
        this.tdsReader = prepStmtExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
        this.startResults();
        this.getNextResult();
        if (1 == this.executeMethod && null == this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
        } else if (2 == this.executeMethod && null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    boolean consumeExecOutParam(TDSReader tDSReader) throws SQLServerException {
        if (!this.expectPrepStmtHandle) {
            return false;
        }
        this.expectPrepStmtHandle = false;
        Parameter parameter = new Parameter();
        parameter.skipRetValStatus(tDSReader);
        this.prepStmtHandle = parameter.getInt(tDSReader);
        parameter.skipValue(tDSReader, true);
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": Setting PreparedHandle:" + this.prepStmtHandle);
        }
        return true;
    }

    void sendParamsByRPC(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        for (int i = 0; i < this.inOutParam.length; ++i) {
            parameterArray[i].sendByRPC(tDSWriter, this.connection, i);
        }
    }

    private final void buildServerCursorPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_cursorprepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 7;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)5);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCString(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCString(this.preparedSQL);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & ~(0 == this.preparedTypeDefinitions.length() ? 4096 : 0)), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_prepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 3;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)13);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCString(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCString(this.preparedSQL);
    }

    private final void buildServerCursorExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_cursorexecute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 5;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)4);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        if (!$assertionsDisabled && 0 == this.prepStmtHandle) {
            throw new AssertionError();
        }
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & 0xFFFFEFFF), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_execute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 1;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)12);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        if (!$assertionsDisabled && 0 == this.prepStmtHandle) {
            throw new AssertionError();
        }
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
    }

    private final boolean doPrepExec(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        boolean bl;
        boolean bl2 = bl = this.buildPreparedStrings(parameterArray) || 0 == this.prepStmtHandle;
        if (bl) {
            if (this.isServerSideCursor && (3 == this.executeMethod || 1 == this.executeMethod)) {
                this.buildServerCursorPrepExecParams(tDSWriter);
            } else {
                this.buildPrepExecParams(tDSWriter);
            }
        } else if (this.isServerSideCursor && (3 == this.executeMethod || 1 == this.executeMethod)) {
            this.buildServerCursorExecParams(tDSWriter);
        } else {
            this.buildExecParams(tDSWriter);
        }
        this.sendParamsByRPC(tDSWriter, parameterArray);
        return bl;
    }

    public final ResultSetMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        boolean bl = false;
        try {
            if (this.resultSet != null) {
                this.resultSet.checkClosed();
            }
        }
        catch (SQLServerException sQLServerException) {
            bl = true;
        }
        if (this.resultSet == null || bl) {
            ResultSetMetaData resultSetMetaData = null;
            SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.buildExecuteMetaData();
            if (null != sQLServerResultSet) {
                resultSetMetaData = sQLServerResultSet.getMetaData();
            }
            return resultSetMetaData;
        }
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    private ResultSet buildExecuteMetaData() throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        block3: {
            String string = this.sqlCommand;
            if (string.indexOf(123) >= 0) {
                string = new JDBCCallSyntaxTranslator().translate(string);
            }
            sQLServerResultSet = null;
            try {
                string = SQLServerPreparedStatement.replaceMarkerWithNull(string);
                SQLServerStatement sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                sQLServerResultSet = sQLServerStatement.executeQueryInternal("set fmtonly on " + string + "\nset fmtonly off");
            }
            catch (SQLServerException sQLServerException) {
                if (sQLServerException.getMessage().equals(SQLServerException.getErrString("R_noResultset"))) break block3;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_processingError"));
                Object[] objectArray = new Object[]{new String(sQLServerException.getMessage())};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
            }
        }
        return sQLServerResultSet;
    }

    final Parameter setterGetParam(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 1 || n > this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n - 1];
    }

    private void checkLength(int n) throws SQLServerException {
        if (n < -1) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
        }
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        this.setterGetParam(n).setValue(-1, inputStream, new InputStreamSetterArgs(3, n2), this.connection);
    }

    private final Parameter getParam(int n) throws SQLServerException {
        if (--n < 0 || n >= this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n + 1)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n];
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        this.setterGetParam(n).setValue(3, bigDecimal, this.connection);
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        this.setterGetParam(n).setValue(-4, inputStream, new InputStreamSetterArgs(1, n2), this.connection);
    }

    public final void setBoolean(int n, boolean bl) throws SQLServerException {
        this.setterGetParam(n).setValue(-7, new Boolean(bl), this.connection);
    }

    public final void setByte(int n, byte by) throws SQLServerException {
        this.setterGetParam(n).setValue(5, new Byte(by), this.connection);
    }

    public final void setBytes(int n, byte[] byArray) throws SQLServerException {
        this.setterGetParam(n).setValue(-2, byArray, this.connection);
    }

    public final void setDouble(int n, double d) throws SQLServerException {
        this.setterGetParam(n).setValue(8, new Double(d), this.connection);
    }

    public final void setFloat(int n, float f) throws SQLServerException {
        this.setterGetParam(n).setValue(7, new Float(f), this.connection);
    }

    public final void setInt(int n, int n2) throws SQLServerException {
        this.setterGetParam(n).setValue(4, new Integer(n2), this.connection);
    }

    public final void setLong(int n, long l) throws SQLServerException {
        this.setterGetParam(n).setValue(-5, new Long(l), this.connection);
    }

    public final void setNull(int n, int n2) throws SQLServerException {
        this.setObject(n, null, n2, null);
    }

    public final void setObject(int n, Object object) throws SQLServerException {
        this.setObject(n, object, 999, null);
    }

    public final void setObject(int n, Object object, int n2) throws SQLServerException {
        this.setObject(n, object, n2, null);
    }

    public final void setObject(int n, Object object, int n2, int n3) throws SQLServerException {
        this.setObject(n, object, n2, new Integer(n3));
    }

    private final void setObject(int n, Object object, int n2, Integer n3) throws SQLServerException {
        Parameter parameter = this.setterGetParam(n);
        int n4 = DataTypes.getObjectJDBCType(object, n2);
        if (999 == n2) {
            n2 = n4;
        }
        if (null == object) {
            if (999 == n4) {
                n2 = parameter.getJdbcType();
                if (999 != n2) {
                    n4 = n2;
                } else {
                    n2 = 1;
                    n4 = 1;
                }
            } else if (DataTypes.isUnsupportedJDBCType(n2)) {
                n2 = -2;
            }
        }
        if (!DataTypes.canConvertFromJDBCTypeToJDBCType(n4, n2)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n4), Util.javaSqlTypeToString(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        if (Reader.class.isInstance(object)) {
            parameter.setValue(n2, object, new CharacterStreamSetterArgs(-1), this.connection);
        } else if (InputStream.class.isInstance(object)) {
            parameter.setValue(n2, object, new InputStreamSetterArgs(DataTypes.isBinaryJDBCType(n2) ? 1 : 3, -1L), this.connection);
        } else {
            parameter.setValue(n2, object, n3, this.connection);
        }
    }

    public final void setShort(int n, short s) throws SQLServerException {
        this.setterGetParam(n).setValue(5, new Short(s), this.connection);
    }

    public final void setString(int n, String string) throws SQLServerException {
        this.setterGetParam(n).setValue(1, string, this.connection);
    }

    private final void setTimeParam(int n, Time time, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(92, time, calendar, this.connection);
    }

    public final void setTime(int n, Time time) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n, time, null);
    }

    private final void setTimestampParam(int n, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(93, timestamp, calendar, this.connection);
    }

    public final void setTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        this.setTimestampParam(n, timestamp, null);
    }

    private final void setDateParam(int n, Date date, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(91, date, calendar, this.connection);
    }

    public final void setDate(int n, Date date) throws SQLServerException {
        this.setDateParam(n, date, null);
    }

    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.NotImplemented();
    }

    public final void addBatch() throws SQLServerException {
        this.checkClosed();
        if (this.batchParamValues == null) {
            this.batchParamValues = new ArrayList();
        }
        int n = this.inOutParam.length;
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = this.inOutParam[i].cloneForBatch();
        }
        this.batchParamValues.add(parameterArray);
    }

    public final void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchParamValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        this.checkClosed();
        this.resetForReexecute();
        if (this.batchParamValues == null) {
            return new int[0];
        }
        try {
            Object[] objectArray;
            for (int i = 0; i < this.batchParamValues.size(); ++i) {
                objectArray = (Parameter[])this.batchParamValues.get(i);
                for (int j = 0; j < objectArray.length; ++j) {
                    if (!objectArray[j].isOutput()) continue;
                    throw new BatchUpdateException(SQLServerException.getErrString("R_outParamsNotPermittedinBatch"), null, 0, null);
                }
            }
            PrepStmtBatchExecCmd prepStmtBatchExecCmd = new PrepStmtBatchExecCmd(this);
            this.executeStatement(prepStmtBatchExecCmd);
            if (null != prepStmtBatchExecCmd.batchException) {
                throw new BatchUpdateException(prepStmtBatchExecCmd.batchException.getMessage(), prepStmtBatchExecCmd.batchException.getSQLState(), prepStmtBatchExecCmd.batchException.getErrorCode(), prepStmtBatchExecCmd.updateCounts);
            }
            objectArray = prepStmtBatchExecCmd.updateCounts;
            return objectArray;
        }
        finally {
            this.batchParamValues = null;
        }
    }

    final void doExecutePreparedStatementBatch(PrepStmtBatchExecCmd prepStmtBatchExecCmd) throws SQLServerException {
        int n;
        this.executeMethod = 4;
        prepStmtBatchExecCmd.batchException = null;
        int n2 = this.batchParamValues.size();
        prepStmtBatchExecCmd.updateCounts = new int[n2];
        for (n = 0; n < n2; ++n) {
            prepStmtBatchExecCmd.updateCounts[n] = -3;
        }
        n = 0;
        int n3 = 0;
        if (this.isSelect(this.userSQL)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_selectNotPermittedinBatch"), null, true);
        }
        Parameter[] parameterArray = new Parameter[this.inOutParam.length];
        TDSWriter tDSWriter = null;
        while (n3 < n2) {
            int n4;
            Parameter[] parameterArray2 = (Parameter[])this.batchParamValues.get(n);
            if (!$assertionsDisabled && parameterArray2.length != parameterArray.length) {
                throw new AssertionError();
            }
            for (n4 = 0; n4 < parameterArray2.length; ++n4) {
                parameterArray[n4] = parameterArray2[n4];
            }
            if (n3 < n) {
                tDSWriter.writeByte((byte)this.nBatchStatementDelimiter);
            } else {
                tDSWriter = prepStmtBatchExecCmd.startRequest((byte)3);
            }
            if (!this.doPrepExec(tDSWriter, parameterArray) && ++n != n2) continue;
            this.tdsReader = prepStmtBatchExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
            while (n3 < n) {
                block14: {
                    n4 = this.connection.isInTransaction() ? 1 : 0;
                    this.startResults();
                    try {
                        if (!this.getNextResult()) {
                            return;
                        }
                        if (null != this.resultSet) {
                            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
                        }
                    }
                    catch (SQLServerException sQLServerException) {
                        if (this.connection.isClosed() || n4 != 0 && !this.connection.isInTransaction()) {
                            throw sQLServerException;
                        }
                        this.updateCount = -3;
                        if (null != prepStmtBatchExecCmd.batchException) break block14;
                        prepStmtBatchExecCmd.batchException = sQLServerException;
                    }
                }
                prepStmtBatchExecCmd.updateCounts[n3++] = -1 == this.updateCount ? -2 : this.updateCount;
                this.processBatch();
            }
            if (!$assertionsDisabled && n3 != n) {
                throw new AssertionError();
            }
        }
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        this.setterGetParam(n).setValue(-1, reader, new CharacterStreamSetterArgs(n2), this.connection);
    }

    public final void setRef(int n, Ref ref) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setBlob(int n, Blob blob) throws SQLServerException {
        this.setterGetParam(n).setValue(2004, blob, this.connection);
    }

    public final void setClob(int n, Clob clob) throws SQLServerException {
        this.setterGetParam(n).setValue(2005, clob, this.connection);
    }

    public final void setArray(int n, Array array) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setDateParam(n, date, calendar);
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n, time, calendar);
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimestampParam(n, timestamp, calendar);
    }

    public final void setNull(int n, int n2, String string) throws SQLServerException {
        this.checkClosed();
        this.setNull(n, n2);
    }

    public final ParameterMetaData getParameterMetaData() throws SQLServerException {
        this.checkClosed();
        return new SQLServerParameterMetaData(this, this.userSQL);
    }

    public final void setURL(int n, URL uRL) throws SQLServerException {
        this.NotImplemented();
    }

    public final int executeUpdate(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeUpdate()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final boolean execute(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("execute()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final ResultSet executeQuery(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeQuery()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public void addBatch(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("addBatch()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    static {
        $assertionsDisabled = !SQLServerPreparedStatement.class.desiredAssertionStatus();
    }

    private final class PrepStmtBatchExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;
        SQLServerException batchException;
        int[] updateCounts;

        PrepStmtBatchExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2) {
            super(sQLServerPreparedStatement2.toLogString() + " executeBatch", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatementBatch(this);
            return true;
        }

        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processExecuteResults(tDSReader);
        }
    }

    private final class PrepStmtExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;

        PrepStmtExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2, int n) {
            super(sQLServerPreparedStatement2.toLogString() + " executeXXX", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
            sQLServerPreparedStatement2.executeMethod = n;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatement(this);
            return false;
        }

        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processExecuteResults(tDSReader);
        }
    }
}

